/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.common.domain.remoting;

import com.alibaba.dts.common.constants.Constants;
import com.alibaba.dts.common.domain.remoting.RpcRequest;
import com.alibaba.dts.shade.io.netty.channel.Channel;
import java.util.concurrent.atomic.AtomicInteger;

public class RemoteMachine
implements Constants {
    private String groupId;
    private String clientId;
    private String localAddress;
    private String localVersion;
    private transient Channel channel;
    private String remoteAddress;
    private String systemRemoteAddress;
    private String remoteVersion;
    private long timeout = 5000L;
    private boolean crashRetry = false;
    private String environment;
    private RpcRequest rpcRequest;
    private String signature;
    private String clientAK;
    private long connectTime;
    private String serviceGroup;
    private String regionName;
    private int nodeListenPort;
    private int nodeSystemListenPort;
    private boolean h2Alive = true;
    private AtomicInteger runThreads = new AtomicInteger(0);

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public String getClientAK() {
        return this.clientAK;
    }

    public void setClientAK(String clientAK) {
        this.clientAK = clientAK;
    }

    public long getConnectTime() {
        return this.connectTime;
    }

    public void setConnectTime(long connectTime) {
        this.connectTime = connectTime;
    }

    public String getServiceGroup() {
        return this.serviceGroup;
    }

    public void setServiceGroup(String serviceGroup) {
        this.serviceGroup = serviceGroup;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public RpcRequest getRpcRequest() {
        return this.rpcRequest;
    }

    public void setRpcRequest(RpcRequest rpcRequest) {
        this.rpcRequest = rpcRequest;
    }

    public RemoteMachine() {
    }

    public RemoteMachine(String remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    public RemoteMachine(String remoteAddress, long timeout) {
        this.remoteAddress = remoteAddress;
        this.timeout = timeout;
    }

    public RemoteMachine(String groupId, String localAddress, String localVersion, String remoteAddress) {
        this.groupId = groupId;
        this.localAddress = localAddress;
        this.localVersion = localVersion;
        this.remoteAddress = remoteAddress;
    }

    public void reversal() {
        String localAddress = this.localAddress;
        String localVersion = this.localVersion;
        this.localAddress = this.remoteAddress;
        this.localVersion = this.remoteVersion;
        this.remoteAddress = localAddress;
        this.remoteVersion = localVersion;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RemoteMachine other = (RemoteMachine)obj;
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        if (this.localAddress == null ? other.localAddress != null : !this.localAddress.equals(other.localAddress)) {
            return false;
        }
        return !(this.remoteAddress == null ? other.remoteAddress != null : !this.remoteAddress.equals(other.remoteAddress));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
        result = 31 * result + (this.localAddress == null ? 0 : this.localAddress.hashCode());
        result = 31 * result + (this.remoteAddress == null ? 0 : this.remoteAddress.hashCode());
        return result;
    }

    public String toString() {
        return "RemoteMachine [groupId=" + this.groupId + ", clientId=" + this.clientId + ", localAddress=" + this.localAddress + ", localVersion=" + this.localVersion + ", remoteAddress=" + this.remoteAddress + ", remoteVersion=" + this.remoteVersion + ", timeout=" + this.timeout + ", nodeListenPort=" + this.nodeListenPort + ", nodeSystemListenPort=" + this.nodeSystemListenPort + ", crashRetry=" + this.crashRetry + ", h2Alive=" + this.h2Alive + "]";
    }

    public String toShortString() {
        return "[groupId=" + this.groupId + ", clientId=" + this.clientId + ", remoteAddress=" + this.remoteAddress + ", remoteVersion=" + this.remoteVersion + ", crashRetry=" + this.crashRetry + "]";
    }

    public String toTinyString() {
        return this.groupId + "," + this.clientId + "," + this.remoteAddress + "," + this.remoteVersion + "," + this.crashRetry;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    public void setLocalAddress(String localAddress) {
        this.localAddress = localAddress;
    }

    public String getLocalVersion() {
        return this.localVersion;
    }

    public void setLocalVersion(String localVersion) {
        this.localVersion = localVersion;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public void setRemoteAddress(String remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    public String getRemoteVersion() {
        return this.remoteVersion;
    }

    public void setRemoteVersion(String remoteVersion) {
        this.remoteVersion = remoteVersion;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public boolean isCrashRetry() {
        return this.crashRetry;
    }

    public void setCrashRetry(boolean crashRetry) {
        this.crashRetry = crashRetry;
    }

    public AtomicInteger getRunThreads() {
        return this.runThreads;
    }

    public void setRunThreads(AtomicInteger runThreads) {
        this.runThreads = runThreads;
    }

    public int getNodeListenPort() {
        return this.nodeListenPort;
    }

    public void setNodeListenPort(int nodeListenPort) {
        this.nodeListenPort = nodeListenPort;
    }

    public int getNodeSystemListenPort() {
        return this.nodeSystemListenPort;
    }

    public void setNodeSystemListenPort(int nodeSystemListenPort) {
        this.nodeSystemListenPort = nodeSystemListenPort;
    }

    public String getSystemRemoteAddress() {
        return this.systemRemoteAddress;
    }

    public void setSystemRemoteAddress(String systemRemoteAddress) {
        this.systemRemoteAddress = systemRemoteAddress;
    }

    public boolean isH2Alive() {
        return this.h2Alive;
    }

    public void setH2Alive(boolean h2Alive) {
        this.h2Alive = h2Alive;
    }
}

