/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.common.context;

import com.alibaba.dts.common.domain.remoting.RemoteMachine;
import com.alibaba.dts.common.exception.DtsException;

public class InvocationContext {
    private static ThreadLocal<RemoteMachine> remoteMachineThreadLocal = new ThreadLocal();

    public static void setRemoteMachine(RemoteMachine remoteMachine) {
        remoteMachineThreadLocal.set(remoteMachine);
    }

    public static RemoteMachine acquireRemoteMachine() {
        RemoteMachine remoteMachine = remoteMachineThreadLocal.get();
        if (null == remoteMachine) {
            throw new DtsException("Remote machine is null, acquire should not happen before set.");
        }
        return remoteMachine;
    }

    public static void clean() {
        remoteMachineThreadLocal.remove();
    }
}

