/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.client.store;

import com.alibaba.dts.client.executor.job.context.ClientContextImpl;
import com.alibaba.dts.client.store.access.CommonDao;
import com.alibaba.dts.client.store.access.ExecutionCounterDao;
import com.alibaba.dts.client.store.access.TaskSnapshotAccess;
import com.alibaba.dts.client.store.access.impl.CommonDaoH2;
import com.alibaba.dts.client.store.access.impl.ExecutionCounterDaoH2;
import com.alibaba.dts.client.store.access.impl.TaskSnapshotDaoH2;
import com.alibaba.dts.client.store.datasource.SchedulerXClientDataSource;
import com.alibaba.dts.common.exception.InitException;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import javax.sql.DataSource;

public class Store {
    private static final Logger logger = SchedulerXLoggerFactory.getLogger(Store.class);
    private final SchedulerXClientDataSource dataSource = new SchedulerXClientDataSource();
    private ExecutionCounterDao executionCounterDao = new ExecutionCounterDaoH2((DataSource)this.dataSource.getDataSource());
    private TaskSnapshotAccess taskSnapshotDao = new TaskSnapshotDaoH2((DataSource)this.dataSource.getDataSource());
    private CommonDao commonDao = new CommonDaoH2((DataSource)this.dataSource.getDataSource());
    private ClientContextImpl clientContext;

    public Store(ClientContextImpl clientContext) {
        this.clientContext = clientContext;
    }

    public void init() throws InitException {
        this.dataSource.init(this.clientContext);
        int result = 0;
        try {
            this.taskSnapshotDao.createTaskSnapshotTable();
            this.executionCounterDao.createExecutionCounterTable();
            this.commonDao.createHealthCheckTable();
        }
        catch (Throwable e) {
            throw new InitException("[Store]: init db error", e);
        }
        logger.info("[Store]: createTaskSnapshotTable, result:" + result);
    }

    public SchedulerXClientDataSource getDataSource() {
        return this.dataSource;
    }

    public TaskSnapshotAccess getTaskSnapshotDao() {
        return this.taskSnapshotDao;
    }

    public ExecutionCounterDao getExecutionCounterDao() {
        return this.executionCounterDao;
    }

    public CommonDao getCommonDao() {
        return this.commonDao;
    }
}

