/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.client.service;

import com.alibaba.dts.client.executor.job.context.ClientContextImpl;
import com.alibaba.dts.client.service.JobRunningException;
import com.alibaba.dts.client.service.JobRunningStateManager;
import com.alibaba.dts.client.store.access.TaskSnapshotAccess;
import com.alibaba.dts.common.constants.Constants;
import com.alibaba.dts.common.context.InvocationContext;
import com.alibaba.dts.common.domain.ExecutableTask;
import com.alibaba.dts.common.domain.ExecuteLogger;
import com.alibaba.dts.common.domain.ExecutionInfo;
import com.alibaba.dts.common.domain.JobInstanceInfo;
import com.alibaba.dts.common.domain.remoting.RemoteMachine;
import com.alibaba.dts.common.domain.result.Result;
import com.alibaba.dts.common.domain.result.ResultCode;
import com.alibaba.dts.common.domain.store.ExecutionCounter;
import com.alibaba.dts.common.domain.store.TaskSnapshot;
import com.alibaba.dts.common.domain.store.assemble.ExecuteLog;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import com.alibaba.dts.common.service.ClientService;
import com.alibaba.dts.common.util.EagleEyeUtil;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class ClientServiceImpl
implements ClientService,
Constants {
    private static final Logger logger = SchedulerXLoggerFactory.getLogger(ClientServiceImpl.class);
    private final ClientContextImpl clientContext;

    public ClientServiceImpl(ClientContextImpl clientContext) {
        this.clientContext = clientContext;
    }

    @Override
    public Result<String> heartBeatCheck() {
        return new Result<String>("I am alive !", ResultCode.SUCCESS);
    }

    @Override
    public Result<String> heartBeatCheckJobInstance(int jobType, long jobId, long jobInstanceId) {
        return this.clientContext.getExecutor().heartBeatCheckJobInstance(jobType, jobId, jobInstanceId);
    }

    @Override
    public Result<Boolean> executeTask(ExecutableTask executableTask) {
        RemoteMachine remoteMachine = InvocationContext.acquireRemoteMachine();
        if (remoteMachine.getRpcRequest() != null) {
            EagleEyeUtil.buildContextFromRpcRequest(remoteMachine, "ClientService", "executeTask");
        }
        Result<Boolean> result = this.clientContext.getExecutor().executeTask(executableTask);
        if (remoteMachine.getRpcRequest() != null) {
            EagleEyeUtil.endRpc();
        }
        return result;
    }

    @Override
    public Result<Boolean> activeTask(ExecutableTask executableTask) {
        return this.clientContext.getExecutor().activeTask(executableTask);
    }

    @Override
    public Result<Boolean> stopTask(int jobType, long jobId, long jobInstanceId) {
        logger.info("stop job, jobId=" + jobId + ", jobInstanceId=" + jobInstanceId + ", jobType=" + jobType);
        return this.clientContext.getExecutor().stopTask(jobType, jobId, jobInstanceId);
    }

    @Override
    public Result<Boolean> forceStopTask(ExecutableTask executableTask) {
        return this.clientContext.getExecutor().forceStopTask(executableTask);
    }

    @Override
    public Result<Boolean> push(int jobType, long jobId, long jobInstanceId, TaskSnapshot taskSnapshot) {
        return this.clientContext.getExecutor().push(jobType, jobId, jobInstanceId, taskSnapshot);
    }

    @Override
    public Result<Boolean> releaseCompleteTask(ExecutableTask executableTask) {
        return this.clientContext.getExecutor().releaseCompleteTask(executableTask);
    }

    @Override
    public Result<ExecuteLogger> getExceptionInfo(JobInstanceInfo jobInstance) {
        ExecuteLogger executeLogger = new ExecuteLogger();
        if (jobInstance == null) {
            return new Result<Object>(null, ResultCode.FAILURE);
        }
        JobRunningException jobRunningException = JobRunningStateManager.getManageHandler().getJobRunningException(jobInstance.getJobInstanceId());
        if (jobRunningException == null) {
            return new Result<Object>(null, ResultCode.FAILURE);
        }
        executeLogger.setContents(jobRunningException.getThrowableStrRep());
        executeLogger.setHappenTime(jobRunningException.getUpdateTime());
        return new Result<ExecuteLogger>(executeLogger, ResultCode.SUCCESS);
    }

    @Override
    public Result<Integer> queryGridTasksCountByJobInstanceId(long jobInstanceId, int status) {
        TaskSnapshotAccess taskSnapshotAccess = this.clientContext.getStore().getTaskSnapshotDao();
        Result<Integer> result = null;
        try {
            int count = taskSnapshotAccess.queryTaskCountByJobInstanceId(jobInstanceId, status);
            result = new Result<Integer>(count, ResultCode.SUCCESS);
            return result;
        }
        catch (Throwable e) {
            logger.error("queryGridTasksCountByJobInstanceId failed, jobInstanceId=" + jobInstanceId, e);
            result = new Result(ResultCode.FAILURE);
            return result;
        }
    }

    @Override
    public Result<ConcurrentHashMap<String, ConcurrentHashMap<String, ExecutionCounter>>> getExecutionCounters(long jobInstanceId) {
        return new Result<ConcurrentHashMap<String, ConcurrentHashMap<String, ExecutionCounter>>>(this.clientContext.getExecutor().getExecutionCounters(jobInstanceId));
    }

    @Override
    public Result<ExecutionInfo> isJobInstanceFinished(long jobInstanceId) {
        ExecutionInfo executionInfo = null;
        try {
            boolean canFinish = this.clientContext.getExecutor().isJobInstanceFinished(jobInstanceId);
            ConcurrentHashMap<String, ConcurrentHashMap<String, ExecutionCounter>> executionCounterByReceiveNode = this.clientContext.getExecutor().getExecutionCounters(jobInstanceId);
            boolean canDelete = false;
            if (canFinish) {
                canDelete = this.clientContext.getExecutor().isJobInstanceCanBeDeleted(jobInstanceId);
            }
            executionInfo = new ExecutionInfo(canFinish, canDelete, executionCounterByReceiveNode);
        }
        catch (Throwable throwable) {
            logger.error("isTasksFinished error, jobInstanceId=" + jobInstanceId, throwable);
        }
        return new Result<Object>(executionInfo);
    }

    @Override
    public Result<ExecutionInfo> isJobInstanceCanBeDeleted(long jobInstanceId) {
        ExecutionInfo executionInfo = null;
        try {
            boolean canDelete = this.clientContext.getExecutor().isJobInstanceCanBeDeleted(jobInstanceId);
            ConcurrentHashMap<String, ConcurrentHashMap<String, ExecutionCounter>> executionCounterByReceiveNode = this.clientContext.getExecutor().getExecutionCounters(jobInstanceId);
            executionInfo = new ExecutionInfo(true, canDelete, executionCounterByReceiveNode);
        }
        catch (Throwable throwable) {
            logger.error("isTasksFinished error, jobInstanceId=" + jobInstanceId, throwable);
        }
        return new Result<Object>(executionInfo);
    }

    @Override
    public Result<Boolean> doGridJobCleanTask(long jobInstanceId) {
        return this.clientContext.getExecutor().doGridJobCleanTask(jobInstanceId);
    }

    @Override
    public Result<ExecuteLog> getLog(long jobId, long jobInstanceId, String fireTime, int streamType) {
        Result<ExecuteLog> result = new Result<ExecuteLog>();
        ExecuteLog executeLog = new ExecuteLog();
        try {
            List<String> lines = this.clientContext.getExecutor().getLog(jobId, jobInstanceId, fireTime, streamType);
            executeLog.setLines(lines);
            result.setResultCode(ResultCode.SUCCESS);
            result.setData(executeLog);
        }
        catch (IOException e) {
            result.setResultCode(ResultCode.FAILURE);
            executeLog.setErrMsg(e.getMessage());
            result.setData(executeLog);
        }
        return result;
    }
}

