/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.client.remoting.timer;

import com.alibaba.dts.client.executor.job.context.ClientContextImpl;
import com.alibaba.dts.common.context.InvocationContext;
import com.alibaba.dts.common.domain.remoting.RemoteMachine;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import com.alibaba.dts.common.service.ServerSystemService;
import com.alibaba.dts.common.util.NamedThreadFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.springframework.util.CollectionUtils;

public class NodeSnifferTimer
implements Runnable {
    private static final Logger logger = SchedulerXLoggerFactory.getLogger(NodeSnifferTimer.class);
    private final ClientContextImpl clientContext;
    private final ServerSystemService serverSystemService;
    private ExecutorService snifferThreadPool = Executors.newFixedThreadPool(10, new NamedThreadFactory("SchedulerX-Node-Sniffer-Thread-"));

    public NodeSnifferTimer(ClientContextImpl clientContext) {
        this.clientContext = clientContext;
        this.serverSystemService = clientContext.getClientRemoting().getServerSystemService();
    }

    @Override
    public void run() {
        try {
            List<String> serverList = this.clientContext.getZookeeper().getServerList();
            if (CollectionUtils.isEmpty(serverList)) {
                logger.warn("serverList is empty, clientConfig:" + this.clientContext.getClientConfig().toString());
                return;
            }
            this.clientContext.getClientRemoting().setServerListCache(serverList);
            List<Object> remoteNodes = new ArrayList();
            for (String server : serverList) {
                InvocationContext.setRemoteMachine(new RemoteMachine(server));
                remoteNodes = this.serverSystemService.getRemoteMachines(this.clientContext.getClientConfig().getGroupId(), 0L);
                if (remoteNodes == null || remoteNodes.size() == 0) continue;
            }
            if (remoteNodes.size() <= 0) {
                return;
            }
            final CountDownLatch latch = new CountDownLatch(remoteNodes.size());
            for (final RemoteMachine remoteMachine : remoteNodes) {
                this.snifferThreadPool.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            String remoteIp = remoteMachine.getRemoteAddress().substring(0, remoteMachine.getRemoteAddress().indexOf(":"));
                            remoteMachine.setRemoteAddress(remoteIp + ":" + remoteMachine.getNodeListenPort());
                            remoteMachine.setSystemRemoteAddress(remoteIp + ":" + remoteMachine.getNodeSystemListenPort());
                            NodeSnifferTimer.this.clientContext.getNodeRemoting().sniffer(remoteMachine);
                        }
                        catch (Throwable throwable) {
                            logger.error("sniffer remote node error : " + remoteMachine);
                        }
                        finally {
                            latch.countDown();
                        }
                    }
                });
            }
            latch.await();
        }
        catch (Throwable e) {
            logger.error("[NodeSnifferTimer]: run error, clientConfig:" + this.clientContext.getClientConfig().toString(), e);
        }
    }
}

