/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.client.executor.simple.processor;

import com.alibaba.dts.client.executor.job.context.ClientContextImpl;
import com.alibaba.dts.client.executor.job.processor.ExSimpleJobProcessor;
import com.alibaba.dts.client.executor.job.processor.SimpleJobProcessor;
import com.alibaba.dts.client.executor.logcollector.AbstractLogCollector;
import com.alibaba.dts.client.executor.simple.processor.SimpleJobContext;
import com.alibaba.dts.client.executor.simple.processor.SimpleJobContextImpl;
import com.alibaba.dts.common.constants.Constants;
import com.alibaba.dts.common.domain.ExecutableTask;
import com.alibaba.dts.common.domain.result.ProcessResult;
import com.alibaba.dts.common.domain.store.TaskSnapshot;
import com.alibaba.dts.common.logger.DtsLogger;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import com.alibaba.dts.shade.com.taobao.eagleeye.EagleEye;
import org.springframework.aop.framework.Advised;

public class SimpleTaskProcessor
extends Thread
implements Constants {
    private static final Logger logger = SchedulerXLoggerFactory.getLogger(SimpleTaskProcessor.class);
    private static final Logger executeLogger = SchedulerXLoggerFactory.getExecuteLogger();
    private ExecutableTask executableTask;
    private int status = 0;
    private SimpleJobContext context;
    private SimpleJobProcessor simpleJobProcessor = null;
    private Object LOCK = new Object();
    private final ClientContextImpl clientContext;
    private Object rpcContext;

    public SimpleTaskProcessor(ClientContextImpl clientContext, ExecutableTask executableTask) {
        this.clientContext = clientContext;
        this.executableTask = executableTask;
        super.setName("DtsTaskProcessor-" + executableTask.getJob().getId() + "-" + executableTask.getJob().getJobProcessor() + "-" + executableTask.getJobInstanceSnapshot().getId() + "-" + executableTask.getJobInstanceSnapshot().getFireTime() + "-" + executableTask.getJobInstanceSnapshot().getRetryCount());
        this.context = new SimpleJobContextImpl(executableTask.getJob(), executableTask.getJobInstanceSnapshot(), executableTask.getJobInstanceSnapshot().getRetryCount());
        this.context.setAvailableMachineAmount(executableTask.getAvailableMachineAmount());
        this.context.setCurrentMachineNumber(executableTask.getCurrentMachineNumber());
    }

    @Override
    public void run() {
        this.status = 1;
        if ("JuShiTa".equals(this.clientContext.getClientConfig().getEnvironment())) {
            DtsLogger.info(this.executableTask.getJob().getId(), this.executableTask.getJobInstanceSnapshot().getId(), "task init start ...");
        }
        try {
            block9: {
                try {
                    this.simpleJobProcessor = this.clientContext.getJobProcessorFactory().createAndGetSimpleJobProcessor(this.executableTask.getJob(), false);
                }
                catch (Throwable e) {
                    logger.error("[SimpleTaskProcessor]: createAndGetSimpleJobProcessor error, jobProcessor:" + this.executableTask.getJob().getJobProcessor(), e);
                    if (!"JuShiTa".equals(this.clientContext.getClientConfig().getEnvironment())) break block9;
                    DtsLogger.info(this.executableTask.getJob().getId(), this.executableTask.getJobInstanceSnapshot().getId(), "createAndGetSimpleJobProcessor error, jobProcessor:" + this.executableTask.getJob().getJobProcessor(), e);
                }
            }
            if ("JuShiTa".equals(this.clientContext.getClientConfig().getEnvironment())) {
                DtsLogger.info(this.executableTask.getJob().getId(), this.executableTask.getJobInstanceSnapshot().getId(), "task execute start ...");
            }
            EagleEye.setRpcContext(this.rpcContext);
            this.executeTask(this.executableTask, this.simpleJobProcessor);
        }
        catch (Throwable e) {
            logger.error("[SimpleTaskProcessor]: executeTask error, instanceId:" + this.executableTask.getJobInstanceSnapshot().getId(), e);
        }
        finally {
            this.status = 0;
            this.clientContext.getExecutor().getSimplePool().removeTask(this.executableTask);
            EagleEye.clearRpcContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeTask(ExecutableTask executableTask, SimpleJobProcessor simpleJobProcessor) {
        int taskStatus;
        TaskSnapshot taskSnapshot = executableTask.getTaskSnapshot();
        if (null == simpleJobProcessor) {
            logger.error("[SimpleTaskProcessor]: jobProcessor is null, please check " + executableTask.getJob().getJobProcessor());
            if ("JuShiTa".equals(this.clientContext.getClientConfig().getEnvironment())) {
                DtsLogger.info(executableTask.getJob().getId(), executableTask.getJobInstanceSnapshot().getId(), "jobProcessor is null, please check " + executableTask.getJob().getJobProcessor());
            }
            this.clientContext.getExecutor().acknowledge(taskSnapshot, 4, 0);
            return;
        }
        this.context.setTask(taskSnapshot);
        ProcessResult processResult = null;
        AbstractLogCollector logCollector = this.context.getLogCollector();
        try {
            EagleEye.startLocal(simpleJobProcessor.getClass().getName(), "process");
            if (simpleJobProcessor instanceof Advised) {
                if (((Advised)simpleJobProcessor).getTargetSource().getTarget() instanceof ExSimpleJobProcessor) {
                    ((ExSimpleJobProcessor)((Advised)simpleJobProcessor).getTargetSource().getTarget()).preProcess(this.context);
                    logger.info("[SimpleTaskProcessor] instanceId=" + executableTask.getJobInstanceSnapshot().getId() + " preProcess finished.");
                }
            } else if (simpleJobProcessor instanceof ExSimpleJobProcessor) {
                ((ExSimpleJobProcessor)simpleJobProcessor).preProcess(this.context);
                logger.info("[SimpleTaskProcessor] instanceId=" + executableTask.getJobInstanceSnapshot().getId() + " preProcess finished.");
            }
            processResult = simpleJobProcessor.process(this.context);
            logger.info("[SimpleTaskProcessor] instanceId=" + executableTask.getJobInstanceSnapshot().getId() + " process finished.");
        }
        catch (Exception e) {
            logCollector.collectStderr(e.getMessage());
            logger.error("[SimpleTaskProcessor]: process error, instanceId:" + executableTask.getJobInstanceSnapshot().getId(), e);
        }
        finally {
            if (simpleJobProcessor instanceof Advised) {
                try {
                    if (((Advised)simpleJobProcessor).getTargetSource().getTarget() instanceof ExSimpleJobProcessor) {
                        ((ExSimpleJobProcessor)((Advised)simpleJobProcessor).getTargetSource().getTarget()).postProcess(this.context);
                        logger.info("[SimpleTaskProcessor] instanceId=" + executableTask.getJobInstanceSnapshot().getId() + " postProcess finished.");
                    }
                }
                catch (Exception e) {
                    logger.error("[SimpleTaskProcessor]: postProcess error, instanceId:" + executableTask.getJobInstanceSnapshot().getId(), e);
                }
            } else if (simpleJobProcessor instanceof ExSimpleJobProcessor) {
                ((ExSimpleJobProcessor)simpleJobProcessor).postProcess(this.context);
                logger.info("[SimpleTaskProcessor] instanceId=" + executableTask.getJobInstanceSnapshot().getId() + " postProcess finished.");
            }
            String bizResultCode = "00";
            String appendMsg = "";
            if (processResult == null) {
                bizResultCode = "01";
                appendMsg = "processResult is NULL, error occurred!";
            } else {
                appendMsg = processResult.toString();
            }
            EagleEye.attribute("processResult", appendMsg);
            EagleEye.endLocal(bizResultCode, appendMsg);
        }
        if (null == processResult) {
            logger.error("[SimpleTaskProcessor]: process error, processResult is null, instanceId:" + executableTask.getJobInstanceSnapshot().getId());
            processResult = new ProcessResult(false);
        }
        this.handleRetryCount(taskSnapshot, processResult);
        Object object = this.LOCK;
        synchronized (object) {
            taskStatus = this.context.isStop() ? 10 : (processResult.isSuccess() ? 3 : 4);
        }
        this.clientContext.getExecutor().acknowledge(taskSnapshot, taskStatus, processResult.getRetryCount());
        if ("JuShiTa".equals(this.clientContext.getClientConfig().getEnvironment())) {
            DtsLogger.info(executableTask.getJob().getId(), executableTask.getJobInstanceSnapshot().getId(), "task execute end, processResult:" + processResult);
        }
    }

    private void handleRetryCount(TaskSnapshot taskSnapshot, ProcessResult processResult) {
        if (processResult.isSuccess()) {
            processResult.setRetryCount(0);
            return;
        }
        if (this.executableTask.isCompensation()) {
            if (taskSnapshot.getRetryCount() > 0) {
                processResult.setRetryCount(taskSnapshot.getRetryCount() - 1);
            } else {
                processResult.setRetryCount(0);
            }
            return;
        }
        if (processResult.getRetryCount() > 100) {
            processResult.setRetryCount(100);
            return;
        }
    }

    public int getStatus() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() {
        block9: {
            try {
                if (this.simpleJobProcessor == null) break block9;
                Object object = this.LOCK;
                synchronized (object) {
                    if (this.simpleJobProcessor instanceof Advised) {
                        if (((Advised)this.simpleJobProcessor).getTargetSource().getTarget() instanceof ExSimpleJobProcessor && ((ExSimpleJobProcessor)((Advised)this.simpleJobProcessor).getTargetSource().getTarget()).kill()) {
                            this.context.setStop(true);
                        }
                    } else if (this.simpleJobProcessor instanceof ExSimpleJobProcessor && ((ExSimpleJobProcessor)this.simpleJobProcessor).kill()) {
                        this.context.setStop(true);
                    }
                }
            }
            catch (Exception e) {
                logger.error("[SimpleTaskProcessor]: kill error, instanceId:" + this.executableTask.getJobInstanceSnapshot().getId(), e);
            }
        }
    }

    public Object getRpcContext() {
        return this.rpcContext;
    }

    public void setRpcContext(Object rpcContext) {
        this.rpcContext = rpcContext;
    }
}

