/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.client.executor.simple;

import com.alibaba.dts.client.executor.job.context.ClientContextImpl;
import com.alibaba.dts.client.executor.simple.processor.ScxSimpleTaskProcessor;
import com.alibaba.dts.client.service.JobRunningStateManager;
import com.alibaba.dts.common.domain.ExecutableTask;
import com.alibaba.dts.common.domain.result.Result;
import com.alibaba.dts.common.domain.result.ResultCode;
import com.alibaba.dts.common.domain.store.Job;
import com.alibaba.dts.common.domain.store.JobInstanceSnapshot;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.util.CollectionUtils;

public class ScxSimplePool {
    private static final Logger logger = SchedulerXLoggerFactory.getLogger(ScxSimplePool.class);
    private ConcurrentHashMap<Long, ConcurrentHashMap<Long, ScxSimpleTaskProcessor>> scxSimpleJobTable = new ConcurrentHashMap();
    private final ClientContextImpl clientContext;

    public ScxSimplePool(ClientContextImpl clientContext) {
        this.clientContext = clientContext;
    }

    public void stopService() {
        Iterator<Map.Entry<Long, ConcurrentHashMap<Long, ScxSimpleTaskProcessor>>> iterator = this.scxSimpleJobTable.entrySet().iterator();
        long jobCount = 0L;
        long processorCount = 0L;
        while (iterator.hasNext()) {
            long jobid = 0L;
            ++jobCount;
            try {
                Map.Entry<Long, ConcurrentHashMap<Long, ScxSimpleTaskProcessor>> entry = iterator.next();
                jobid = entry.getKey();
                ConcurrentHashMap<Long, ScxSimpleTaskProcessor> scxSimpleTaskProcessorMap = entry.getValue();
                if (CollectionUtils.isEmpty(scxSimpleTaskProcessorMap)) continue;
                Iterator<Map.Entry<Long, ScxSimpleTaskProcessor>> processorIterator = scxSimpleTaskProcessorMap.entrySet().iterator();
                while (processorIterator.hasNext()) {
                    ++processorCount;
                    Map.Entry<Long, ScxSimpleTaskProcessor> processorEntity = processorIterator.next();
                    ScxSimpleTaskProcessor processor = processorEntity.getValue();
                    processor.setStop(true);
                }
            }
            catch (Throwable e) {
                logger.error("[ScxSimplePool]: stopService error, jobid:" + jobid, e);
            }
            logger.info("[ScxSimplePool]: stopService, jobCount:" + jobCount + ", processorCount:" + processorCount);
        }
        this.scxSimpleJobTable.clear();
    }

    public boolean executeTask(ExecutableTask executableTask) {
        try {
            logger.info("executeTask start......");
            ConcurrentHashMap<Long, ScxSimpleTaskProcessor> instanceTable = this.scxSimpleJobTable.get(executableTask.getJob().getId());
            if (null == instanceTable) {
                instanceTable = new ConcurrentHashMap();
                this.scxSimpleJobTable.put(executableTask.getJob().getId(), instanceTable);
            }
            ScxSimpleTaskProcessor scxSimpleTaskProcessor = new ScxSimpleTaskProcessor(this.clientContext, executableTask);
            scxSimpleTaskProcessor.start();
            instanceTable.put(executableTask.getJobInstanceSnapshot().getId(), scxSimpleTaskProcessor);
        }
        catch (Throwable e) {
            logger.error("[ScxSimplePool]: executeTask error, instanceId:" + executableTask.getJobInstanceSnapshot().getId(), e);
            return false;
        }
        return true;
    }

    public int getInstanceAmount(Job job) {
        ConcurrentHashMap<Long, ScxSimpleTaskProcessor> instanceTable = this.scxSimpleJobTable.get(job.getId());
        if (null == instanceTable) {
            return 0;
        }
        return instanceTable.size();
    }

    public boolean stopTask(long jobId, long jobInstanceId) {
        ConcurrentHashMap<Long, ScxSimpleTaskProcessor> instanceTable = this.scxSimpleJobTable.get(jobId);
        if (null == instanceTable) {
            return true;
        }
        ScxSimpleTaskProcessor scxSimpleTaskProcessor = instanceTable.get(jobInstanceId);
        if (null == scxSimpleTaskProcessor) {
            return true;
        }
        try {
            Job job = new Job();
            job.setId(jobId);
            JobInstanceSnapshot jobInstanceSnapshot = new JobInstanceSnapshot();
            jobInstanceSnapshot.setId(jobInstanceId);
            this.removeTask(new ExecutableTask(job, jobInstanceSnapshot));
        }
        catch (Throwable e) {
            logger.error("[ScxSimplePool]: stopTask removeTask error, jobId:" + jobId + ", jobInstanceId:" + jobInstanceId, e);
            return false;
        }
        return true;
    }

    public boolean forceStopTask(long jobId, long jobInstanceId) {
        ConcurrentHashMap<Long, ScxSimpleTaskProcessor> instanceTable = this.scxSimpleJobTable.get(jobId);
        if (null == instanceTable) {
            return true;
        }
        ScxSimpleTaskProcessor scxSimpleTaskProcessor = instanceTable.get(jobInstanceId);
        if (null == scxSimpleTaskProcessor) {
            return true;
        }
        try {
            scxSimpleTaskProcessor.stop();
        }
        catch (Throwable e) {
            logger.error("[ScxSimplePool]: forceStopTask error, jobId:" + jobId + ", jobInstanceId:" + jobInstanceId, e);
        }
        try {
            Job job = new Job();
            job.setId(jobId);
            JobInstanceSnapshot jobInstanceSnapshot = new JobInstanceSnapshot();
            jobInstanceSnapshot.setId(jobInstanceId);
            this.removeTask(new ExecutableTask(job, jobInstanceSnapshot));
        }
        catch (Throwable e) {
            logger.error("[ScxSimplePool]: forceStopTask removeTask error, jobId:" + jobId + ", jobInstanceId:" + jobInstanceId, e);
            return false;
        }
        return true;
    }

    public void removeTask(ExecutableTask executableTask) {
        try {
            ConcurrentHashMap<Long, ScxSimpleTaskProcessor> instanceTable = this.scxSimpleJobTable.get(executableTask.getJob().getId());
            if (null == instanceTable) {
                logger.warn("[ScxSimplePool]: removeTask warn instanceTable is null, instanceId:" + executableTask.getJobInstanceSnapshot().getId());
                return;
            }
            ScxSimpleTaskProcessor scxSimpleTaskProcessor = instanceTable.get(executableTask.getJobInstanceSnapshot().getId());
            if (null == scxSimpleTaskProcessor) {
                logger.warn("[ScxSimplePool]: removeTask warn simpleTaskProcessor is null, instanceId:" + executableTask.getJobInstanceSnapshot().getId());
                return;
            }
            instanceTable.remove(executableTask.getJobInstanceSnapshot().getId());
            if (instanceTable.size() <= 0) {
                this.scxSimpleJobTable.remove(executableTask.getJob().getId());
            }
        }
        catch (Throwable e) {
            logger.error("[ScxSimplePool]: removeTask error, instanceId:" + executableTask.getJobInstanceSnapshot().getId(), e);
        }
    }

    public Result<String> heartBeatCheckJobInstance(long jobId, long jobInstanceId) {
        Result<String> result = new Result<String>();
        ConcurrentHashMap<Long, ScxSimpleTaskProcessor> instanceTable = this.scxSimpleJobTable.get(jobId);
        if (null == instanceTable) {
            result.setResultCode(ResultCode.HEART_BEAT_CHECK_FAILURE);
            return result;
        }
        ScxSimpleTaskProcessor scxSimpleTaskProcessor = instanceTable.get(jobInstanceId);
        if (null == scxSimpleTaskProcessor) {
            JobRunningStateManager.getManageHandler().deleteJobRunningState(jobInstanceId);
            result.setResultCode(ResultCode.HEART_BEAT_CHECK_FAILURE);
            return result;
        }
        result.setResultCode(ResultCode.HEART_BEAT_CHECK_SUCCESS);
        result.setData(JobRunningStateManager.getManageHandler().getJobRunningStateDescribe(jobInstanceId));
        return result;
    }

    public ConcurrentHashMap<Long, ConcurrentHashMap<Long, ScxSimpleTaskProcessor>> getSimpleJobTable() {
        return this.scxSimpleJobTable;
    }
}

