/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.client.executor.logcollector;

import com.alibaba.dts.client.executor.logcollector.AbstractLogCollector;
import com.alibaba.dts.client.executor.logcollector.StreamType;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class LocalLogCollector
extends AbstractLogCollector {
    private static final Logger LOGGER = SchedulerXLoggerFactory.getLogger(LocalLogCollector.class);
    private String fileName;
    private String fireDate;
    public static final String DIR_PREFIX = System.getProperties().getProperty("user.home") + "/logs/schedulerx-log/script";

    public LocalLogCollector(String fireDate, String fileName) {
        this.fireDate = fireDate;
        this.fileName = fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(String text, StreamType streamType) {
        String type = streamType == StreamType.STD_OUT ? ".out" : ".err";
        String dirPath = DIR_PREFIX + "/" + this.fireDate + "/";
        File dir = new File(dirPath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        String logFile = dirPath + this.fileName + type;
        FileWriter writer = null;
        try {
            writer = new FileWriter(logFile, true);
            writer.write(text);
        }
        catch (IOException e) {
            LOGGER.error("", e);
        }
        finally {
            if (writer != null) {
                try {
                    ((Writer)writer).close();
                }
                catch (IOException e) {
                    LOGGER.error("", e);
                }
            }
        }
    }

    @Override
    public void collect(String line, StreamType streamType, boolean isEnd) {
        if (isEnd) {
            this.write(String.valueOf(AbstractLogCollector.END_OF_LOG), streamType);
        } else {
            this.write(line + "\n", streamType);
        }
    }

    @Override
    public List<String> readLines(long lineOffset, int lineNumber, StreamType streamType) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        if (lineNumber <= 0 || lineOffset < 0L) {
            return lines;
        }
        String type = streamType == StreamType.STD_OUT ? ".out" : ".err";
        String logFile = DIR_PREFIX + "/" + this.fireDate + "/" + this.fileName + type;
        FileReader reader = null;
        BufferedReader br = null;
        String endOfLog = String.valueOf(AbstractLogCollector.END_OF_LOG);
        try {
            reader = new FileReader(logFile);
            br = new BufferedReader(reader);
            String line = null;
            int offsetCounter = 0;
            while ((long)offsetCounter < lineOffset && (line = br.readLine()) != null && !line.equals(endOfLog)) {
                ++offsetCounter;
            }
            for (int lineCounter = 0; lineCounter < lineNumber && (line = br.readLine()) != null; ++lineCounter) {
                if (line.equals(endOfLog)) {
                    break;
                }
                lines.add(line);
            }
        }
        catch (IOException e) {
            LOGGER.error("", e);
            throw e;
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {
                LOGGER.error("", e);
            }
        }
        return lines;
    }

    @Override
    public List<String> tailLines(int lineNumber, StreamType streamType) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        String type = streamType == StreamType.STD_OUT ? ".out" : ".err";
        String logFile = DIR_PREFIX + "/" + this.fireDate + "/" + this.fileName + type;
        RandomAccessFile rf = null;
        int counter = 0;
        try {
            rf = new RandomAccessFile(logFile, "r");
            long len = rf.length();
            long start = rf.getFilePointer();
            long nextend = start + len - 1L;
            rf.seek(nextend);
            int n = -1;
            while (nextend > start && counter < lineNumber) {
                int n2 = rf.read();
                if (n2 == AbstractLogCollector.END_OF_LOG) {
                    --nextend;
                    continue;
                }
                if (n2 == 10 || n2 == 13) {
                    String line = rf.readLine();
                    if (line != null) {
                        lines.add(line);
                        ++counter;
                    }
                    --nextend;
                }
                rf.seek(--nextend);
                if (nextend != 0L) continue;
                ++counter;
                lines.add(rf.readLine());
            }
        }
        catch (IOException e) {
            LOGGER.error("", e);
            throw e;
        }
        finally {
            try {
                if (rf != null) {
                    rf.close();
                }
            }
            catch (IOException e) {
                LOGGER.error("", e);
            }
        }
        return lines;
    }

    @Override
    public void delete() throws IOException {
        File errFile;
        File outFile = new File(DIR_PREFIX + "/" + this.fireDate + "/" + this.fileName + ".out");
        if (outFile.exists()) {
            outFile.delete();
        }
        if ((errFile = new File(DIR_PREFIX + "/" + this.fireDate + "/" + this.fileName + ".err")).exists()) {
            errFile.delete();
        }
    }
}

