/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.client.executor.grid.timer;

import com.alibaba.dts.client.executor.grid.timer.ExecutionCounterUpdateTimer;
import com.alibaba.dts.client.executor.job.context.ClientContextImpl;
import com.alibaba.dts.client.store.access.ExecutionCounterDao;
import com.alibaba.dts.common.context.InvocationContext;
import com.alibaba.dts.common.domain.remoting.RemoteMachine;
import com.alibaba.dts.common.domain.result.Result;
import com.alibaba.dts.common.domain.store.JobInstanceSnapshot;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class ExecutionCounterDeleteTimer {
    private static final Logger logger = SchedulerXLoggerFactory.getLogger(ExecutionCounterUpdateTimer.class);
    private ClientContextImpl clientContext;
    private ExecutionCounterDao executionCounterDao;

    public ExecutionCounterDeleteTimer(ClientContextImpl clientContext) {
        this.clientContext = clientContext;
        this.executionCounterDao = clientContext.getStore().getExecutionCounterDao();
    }

    public void init() {
        Executors.newScheduledThreadPool(1).scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    List<String> servers = ExecutionCounterDeleteTimer.this.clientContext.getClientRemoting().getServerList();
                    if (servers == null || servers.isEmpty()) {
                        logger.warn("server list is null or empty");
                        return;
                    }
                    List<Long> jobInstanceIds = ExecutionCounterDeleteTimer.this.executionCounterDao.listJobInstances();
                    if (jobInstanceIds == null || jobInstanceIds.isEmpty()) {
                        logger.warn("jobInstanceIds is null or empty");
                        return;
                    }
                    for (Long jobInstanceId : jobInstanceIds) {
                        try {
                            JobInstanceSnapshot jobInstanceSnapshot = null;
                            for (String server : servers) {
                                InvocationContext.setRemoteMachine(new RemoteMachine(server, 10000L));
                                Result<JobInstanceSnapshot> result = ExecutionCounterDeleteTimer.this.clientContext.getServerService().getJobInstanceById(jobInstanceId);
                                if (result == null) {
                                    logger.error("getJobInstanceById error, jobInstanceId = {}, server= {}", (Object)jobInstanceId, (Object)server);
                                    continue;
                                }
                                if (!"success".equals(result.getResultCode())) {
                                    logger.error("getJobInstanceById error, jobInstanceId = {}, server= {}, errorCode = ", jobInstanceId, server, result.getResultCode());
                                    continue;
                                }
                                jobInstanceSnapshot = result.getData();
                                break;
                            }
                            if (jobInstanceSnapshot == null) {
                                ExecutionCounterDeleteTimer.this.executionCounterDao.deleteByJobInstanceId(jobInstanceId);
                                return;
                            }
                            int status = jobInstanceSnapshot.getStatus();
                            if (status != 4 && status != 9) continue;
                            ExecutionCounterDeleteTimer.this.executionCounterDao.deleteByJobInstanceId(jobInstanceId);
                        }
                        catch (Throwable e) {
                            logger.error("delete execution counter error, jobInstanceId = {}", (Object)jobInstanceId, (Object)e);
                        }
                    }
                }
                catch (Throwable throwable) {
                    logger.error(throwable.getMessage(), throwable);
                }
            }
        }, 0L, 600L, TimeUnit.SECONDS);
    }
}

