/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.client.executor.grid.processor;

import com.alibaba.dts.client.executor.grid.processor.GridJobContextImpl;
import com.alibaba.dts.client.executor.job.context.ClientContextImpl;
import com.alibaba.dts.client.executor.job.processor.GridJobProcessor;
import com.alibaba.dts.common.constants.Constants;
import com.alibaba.dts.common.domain.ExecutableTask;
import com.alibaba.dts.common.domain.result.ProcessResult;
import com.alibaba.dts.common.domain.store.TaskSnapshot;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;

public class GridTaskProcessor
implements Runnable,
Constants {
    private static final Logger logger = SchedulerXLoggerFactory.getLogger(GridTaskProcessor.class);
    private ClientContextImpl clientContext;
    private ExecutableTask executableTask;
    private TaskSnapshot taskSnapshot;
    private GridJobContextImpl context;

    public GridTaskProcessor(ClientContextImpl clientContext, ExecutableTask executableTask, TaskSnapshot taskSnapshot) {
        this.clientContext = clientContext;
        this.executableTask = executableTask;
        this.taskSnapshot = taskSnapshot;
        this.context = new GridJobContextImpl(clientContext, executableTask.getJob(), executableTask.getJobInstanceSnapshot(), executableTask.getJobInstanceSnapshot().getRetryCount());
    }

    @Override
    public void run() {
        GridJobProcessor gridJobProcessor = null;
        try {
            if (this.clientContext.getGridTaskSender().isInterruptedInstance(this.executableTask.getJobInstanceSnapshot().getId())) {
                return;
            }
            gridJobProcessor = this.clientContext.getJobProcessorFactory().createAndGetGridJobProcessor(this.executableTask.getJob(), false);
        }
        catch (Throwable e) {
            logger.error("createAndGetGridJobProcessor error, jobProcessor:" + this.executableTask.getJob().getJobProcessor(), e);
        }
        this.executeTask(gridJobProcessor, this.taskSnapshot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeTask(GridJobProcessor gridJobProcessor, TaskSnapshot taskSnapshot) {
        block11: {
            if (null == gridJobProcessor) {
                logger.error("jobProcessor is null , please check " + this.executableTask.getJob().getJobProcessor());
                if ("defaultTaskName4DtsServerSelf".equals(taskSnapshot.getTaskName())) {
                    this.clientContext.getExecutor().acknowledge(taskSnapshot, 4, 0);
                } else {
                    this.clientContext.getExecutor().acknowledgeNode(taskSnapshot, 4, 0);
                }
                return;
            }
            try {
                this.context.setTask(taskSnapshot);
                this.context.initRetryCount(taskSnapshot.getRetryCount());
                ProcessResult processResult = null;
                try {
                    processResult = gridJobProcessor.process(this.context);
                }
                catch (Throwable e) {
                    logger.error("[GridTaskProcessor]: process error, instanceId:" + taskSnapshot.getJobInstanceId() + ", id:" + taskSnapshot.getId(), e);
                }
                if (null == processResult) {
                    logger.error("[GridTaskProcessor]: process error, processResult is null, instanceId:" + taskSnapshot.getJobInstanceId() + ", id:" + taskSnapshot.getId());
                    processResult = new ProcessResult(false);
                }
                this.handleRetryCount(taskSnapshot, processResult);
                String taskName = this.context.getTaskName();
                if ("defaultTaskName4DtsServerSelf".equals(taskName)) {
                    this.clientContext.getExecutor().acknowledge(taskSnapshot, processResult.isSuccess() ? 3 : 4, processResult.getRetryCount());
                    break block11;
                }
                this.clientContext.getExecutor().acknowledgeNode(taskSnapshot, processResult.isSuccess() ? 3 : 4, processResult.getRetryCount());
            }
            catch (Throwable e) {
                logger.error("[GridTaskProcessor]: executeTask error, instanceId:" + taskSnapshot.getJobInstanceId() + ", id:" + taskSnapshot.getId(), e);
            }
        }
    }

    private void handleRetryCount(TaskSnapshot taskSnapshot, ProcessResult processResult) {
        if (processResult.isSuccess()) {
            processResult.setRetryCount(0);
            return;
        }
        if (taskSnapshot.isCompensation()) {
            if (taskSnapshot.getRetryCount() > 0) {
                processResult.setRetryCount(taskSnapshot.getRetryCount() - 1);
            } else {
                processResult.setRetryCount(0);
            }
            return;
        }
        if (processResult.getRetryCount() > 100) {
            processResult.setRetryCount(100);
            return;
        }
    }
}

