/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.client.executor.grid;

import com.alibaba.dts.client.executor.job.context.ClientContextImpl;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import com.alibaba.dts.common.remoting.ChannelEventListener;
import com.alibaba.dts.common.remoting.netty.NettyServerConfig;
import com.alibaba.dts.common.remoting.netty.NodeNettyRemotingServer;
import com.alibaba.dts.shade.io.netty.bootstrap.ServerBootstrap;
import com.alibaba.dts.shade.io.netty.channel.ChannelFuture;
import java.net.BindException;
import java.net.InetSocketAddress;

public class ClientNodeRemotingServer
extends NodeNettyRemotingServer {
    private static final Logger logger = SchedulerXLoggerFactory.getLogger(ClientNodeRemotingServer.class);
    private ClientContextImpl clientContext;

    public ClientNodeRemotingServer(NettyServerConfig nettyServerConfig, ClientContextImpl clientContext) {
        super(nettyServerConfig);
        this.clientContext = clientContext;
    }

    public ClientNodeRemotingServer(NettyServerConfig nettyServerConfig, ChannelEventListener channelEventListener, ClientContextImpl clientContext) {
        super(nettyServerConfig, channelEventListener);
        this.clientContext = clientContext;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void boot(ServerBootstrap serverBootstrap) {
        try {
            boolean bindSuccess = false;
            while (!bindSuccess) {
                int listenPort = this.clientContext.getNodeConfig().getListenPort();
                try {
                    ChannelFuture sync = serverBootstrap.bind(listenPort);
                    sync.sync();
                    bindSuccess = true;
                    InetSocketAddress addr = (InetSocketAddress)sync.channel().localAddress();
                    this.port = addr.getPort();
                }
                catch (Exception e) {
                    if (e instanceof BindException) {
                        logger.warn(e.getMessage() + ", port=" + listenPort + ", we will try a new port");
                        if (++listenPort > 65535) {
                            listenPort = 40000;
                        }
                        this.clientContext.getNodeConfig().setListenPort(listenPort);
                        continue;
                    }
                    if (!(e instanceof InterruptedException)) throw new RuntimeException(e);
                    throw (InterruptedException)e;
                    return;
                }
            }
        }
        catch (InterruptedException e1) {
            throw new RuntimeException("this.serverBootstrap.bind().sync() InterruptedException", e1);
        }
    }
}

