/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.client.config;

import com.alibaba.dts.client.SchedulerxClient;
import com.alibaba.dts.client.config.ClientConfig;
import com.alibaba.dts.client.executor.job.context.ClientContextImpl;
import com.alibaba.dts.client.executor.job.processor.FailureJobProcessor;
import com.alibaba.dts.client.executor.job.processor.StopJobProcessor;
import com.alibaba.dts.common.constants.Constants;
import com.alibaba.dts.common.domain.Machine;
import com.alibaba.dts.common.domain.store.EnvGroup;
import com.alibaba.dts.common.exception.InitException;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import com.alibaba.dts.common.util.DiamondHelper;
import com.alibaba.dts.common.util.IniUtil;
import com.alibaba.dts.common.util.RemotingUtil;
import com.alibaba.dts.common.util.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.Map;
import java.util.UUID;

public class ClientConfigImpl
implements Constants,
ClientConfig {
    private static final Logger logger = SchedulerXLoggerFactory.getLogger(ClientConfigImpl.class);
    private int remotingThreads = DEFAULT_REMOTING_THREADS;
    private long heartBeatIntervalTime = 120000L;
    private long connectionTimeout = 3000L;
    private String groupId;
    private boolean enableIsolateEnvSupport = false;
    private String zkHosts;
    private String namespace = "zk-dts-root";
    private int zkSessionTimeout = 10000;
    private int zkConnectionTimeout = 10000;
    private boolean isSpring = false;
    private int queueSize = 10000;
    private int consumerThreads = 5;
    private Map<String, Integer> consumerThreadsMap = null;
    private String version;
    private int pageSize = 1000;
    private Map<String, Integer> pageSizeMap = null;
    private String accessKey;
    private String secretKey;
    private String localAddress;
    private String clientId;
    private boolean crashRetry = false;
    private long pullTaskListOverSleepTime = 20000L;
    private Map<String, FailureJobProcessor> failureJobProcessorMap = null;
    private StopJobProcessor stopJobProcessor = null;
    private boolean finishLog = true;
    private boolean isEveryTimeNew = false;
    private boolean zkHostsAutoChange = true;
    private long maxBodySize = 65536L;
    private String environment;
    private String signature;
    private Map<String, String> jobMap;
    private Machine machine;
    private String domainName;
    private String serviceGroup;
    private String regionName;
    private String serviceGroupId;
    private boolean autoInit = true;
    private boolean isAgent = false;
    private boolean newInstance = true;
    private boolean newVersion = false;
    private String configPath;
    private ClientContextImpl clientContext;
    private long connectTime;
    private int innerDebug = 0;
    private DiamondHelper.DataListener dataListener = new DiamondHelper.DataListener(){

        @Override
        public void receiveConfigInfo(String dataId, String configInfo) {
            ClientConfigImpl.this.domainName = configInfo;
        }
    };

    @Override
    public boolean isEnableIsolateEnvSupport() {
        return this.enableIsolateEnvSupport;
    }

    @Override
    public void setEnableIsolateEnvSupport(boolean enableIsolateEnvSupport) {
        this.enableIsolateEnvSupport = enableIsolateEnvSupport;
    }

    public ClientConfigImpl(ClientContextImpl clientContext) {
        this.clientContext = clientContext;
    }

    @Override
    public String getServiceGroupId() {
        return this.serviceGroupId;
    }

    @Override
    public void setServiceGroupId(String serviceGroupId) {
        this.serviceGroupId = serviceGroupId;
    }

    @Override
    public long getConnectTime() {
        return this.connectTime;
    }

    @Override
    public void setConnectTime(long connectTime) {
        this.connectTime = connectTime;
    }

    @Override
    public int getInnerDebug() {
        return this.innerDebug;
    }

    @Override
    public void setInnerDebug(int innerDebug) {
        this.innerDebug = innerDebug;
    }

    @Override
    public void init() throws InitException {
        Map<String, String> configMap;
        try {
            this.version = "2.1.4-SNAPSHOT";
        }
        catch (Throwable e) {
            throw new InitException("[ClientConfig]: init version error", e);
        }
        this.localAddress = RemotingUtil.getLocalAddress("SchedulerX".equals(this.getEnvironment()));
        try {
            this.clientId = UUID.randomUUID().toString() + ":" + this.localAddress;
        }
        catch (Throwable e) {
            throw new InitException("[ClientConfig]: init clientId error", e);
        }
        if (!StringUtil.isBlank(this.configPath) && (configMap = IniUtil.getIniValuesFromFile(this.configPath, "baseSection")) != null && !configMap.isEmpty()) {
            String newVersion;
            String innerDebug;
            String regionName;
            String domainName;
            String groupId = configMap.get("groupId");
            if (StringUtil.isNotBlank(groupId)) {
                this.groupId = groupId;
            }
            if (StringUtil.isNotBlank(domainName = configMap.get("domainName"))) {
                this.domainName = domainName;
            }
            if (StringUtil.isNotBlank(regionName = configMap.get("regionName"))) {
                this.regionName = regionName;
            }
            if (StringUtil.isNotBlank(innerDebug = configMap.get("innerDebug"))) {
                this.innerDebug = Integer.valueOf(innerDebug);
            }
            if (StringUtil.isNotBlank(newVersion = configMap.get("newVersion"))) {
                this.newVersion = Boolean.valueOf(newVersion);
            }
        }
        if ("SchedulerX".equals(this.getEnvironment())) {
            if (StringUtil.isBlank(this.domainName)) {
                this.domainName = "schedulerx.console.aliyun.com";
            }
        } else if (StringUtil.isBlank(this.domainName)) {
            try {
                this.domainName = DiamondHelper.getData("com.alibaba.dts.common.domainName", 10000L);
                DiamondHelper.addListener("com.alibaba.dts.common.domainName", this.dataListener);
            }
            catch (Throwable e) {
                throw new InitException("[ClientConfig]: get domainName from diamond error", e);
            }
        }
        if (StringUtil.isBlank(this.domainName)) {
            throw new InitException("[ClientConfig]: domainName is empty error, domainName:" + this.domainName);
        }
        if (!"SchedulerX".equals(this.getEnvironment()) && this.enableIsolateEnvSupport) {
            this.setRealGroupId(this.domainName, this.groupId);
        }
    }

    private void setRealGroupId(String domainName, String groupId) throws InitException {
        String realGroupId;
        this.groupId = realGroupId = this.calculateRealGroupId(domainName, groupId);
        this.clientContext.getNodeConfig().setGroupId(realGroupId);
    }

    private String calculateRealGroupId(String domainName, String groupId) throws InitException {
        String ip = RemotingUtil.getLocalAddress();
        if (ip == null) {
            throw new RuntimeException("local ip is null");
        }
        String vipUrl = "http://openapi.vipserver.alibaba-inc.com/vipserver/api/armoryNode?action=view&ip=" + ip;
        String env = this.requestEnvFromVipServer(vipUrl);
        if (env == null || "".equals(env)) {
            return groupId;
        }
        String dtsConsoleUrl = "http://" + domainName + "/dts-console/apiManager.do?action=ApiAction&event_submit_do_get_real_group=1&env=" + env + "&defaultGroupId=" + groupId;
        String realEnvGroupId = this.requestRealEnvGroupId(dtsConsoleUrl);
        if (realEnvGroupId == null || realEnvGroupId.trim().isEmpty()) {
            throw new InitException("The env is an isolated env, but no isolated env group exists, domainName=" + domainName + ", defaultGroupId=" + groupId);
        }
        return realEnvGroupId;
    }

    private String requestEnvFromVipServer(String vipUrl) throws InitException {
        String response = this.clientContext.getHttpService().request(vipUrl).getValue();
        if (response != null) {
            try {
                logger.info("response before escape: " + response);
                response = response.replace("\\", "");
                response = response.replace("\"{", "{");
                response = response.replace("}\"", "}");
                logger.info("response after escape: " + response);
                JSONObject jsonObject = JSON.parseObject((String)response);
                return jsonObject.getJSONObject("msg").getString("ipGroup");
            }
            catch (Exception e) {
                throw new InitException("failed to parse response", e);
            }
        }
        logger.error("failed to get env, url=" + vipUrl + ", if the app env is daily, pls set enableIsolateEnvSupport=false as a property of " + SchedulerxClient.class.getCanonicalName());
        throw new InitException("failed to get env, vipUrl=" + vipUrl);
    }

    private String requestRealEnvGroupId(String dtsConsoleUrl) throws InitException {
        EnvGroup envGroup;
        Response envGroupResponse;
        String response = this.clientContext.getHttpService().request(dtsConsoleUrl).getValue();
        if (response != null && (envGroupResponse = (Response)JSON.parseObject((String)response, (TypeReference)new TypeReference<Response<EnvGroup>>(){}, (Feature[])new Feature[0])) != null && envGroupResponse.isSuccess() && (envGroup = (EnvGroup)envGroupResponse.getData()) != null && envGroup.getRealGroupId() != null && !envGroup.getRealGroupId().trim().isEmpty()) {
            return envGroup.getRealGroupId();
        }
        throw new InitException("The env is an isolated env, but no isolated env group exists, dtsConsoleUrl=" + dtsConsoleUrl);
    }

    @Override
    public void removeDataListener() {
        DiamondHelper.removeListener("com.alibaba.dts.common.domainName", this.dataListener);
    }

    @Override
    public int getRemotingThreads() {
        return this.remotingThreads;
    }

    @Override
    public void setRemotingThreads(int remotingThreads) {
        if (remotingThreads <= 0) {
            this.remotingThreads = DEFAULT_REMOTING_THREADS;
            logger.warn("[ClientConfig]: setRemotingThreads error, you set remotingThreads:" + remotingThreads);
            return;
        }
        if (remotingThreads > 10 * DEFAULT_REMOTING_THREADS) {
            this.remotingThreads = 10 * DEFAULT_REMOTING_THREADS;
            logger.warn("[ClientConfig]: setRemotingThreads too large, you set remotingThreads:" + remotingThreads + ", max:" + 10 * DEFAULT_REMOTING_THREADS);
            return;
        }
        this.remotingThreads = remotingThreads;
    }

    @Override
    public long getHeartBeatIntervalTime() {
        return this.heartBeatIntervalTime;
    }

    @Override
    public void setHeartBeatIntervalTime(long heartBeatIntervalTime) {
        if (heartBeatIntervalTime <= 0L) {
            this.heartBeatIntervalTime = 10000L;
            logger.warn("[ClientConfig]: setHeartBeatIntervalTime error, you set heartBeatIntervalTime:" + heartBeatIntervalTime);
            return;
        }
        if (heartBeatIntervalTime > 200000L) {
            this.heartBeatIntervalTime = 200000L;
            logger.warn("[ClientConfig]: setHeartBeatIntervalTime too large, you set heartBeatIntervalTime:" + heartBeatIntervalTime + ", max:" + 200000L);
            return;
        }
        this.heartBeatIntervalTime = heartBeatIntervalTime;
    }

    @Override
    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Override
    public void setConnectionTimeout(long connectionTimeout) {
        if (connectionTimeout <= 0L) {
            this.connectionTimeout = 3000L;
            logger.warn("[ClientConfig]: setConnectionTimeout error, you set connectionTimeout:" + connectionTimeout);
            return;
        }
        if (connectionTimeout > 30000L) {
            this.connectionTimeout = 30000L;
            logger.warn("[ClientConfig]: setConnectionTimeout too large, you set connectionTimeout:" + connectionTimeout + ", max:" + 30000L);
            return;
        }
        this.connectionTimeout = connectionTimeout;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @Override
    public String getZkHosts() {
        return this.zkHosts;
    }

    @Override
    public void setZkHosts(String zkHosts) {
        this.zkHosts = zkHosts;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public int getZkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public void setZkSessionTimeout(int zkSessionTimeout) {
        if (zkSessionTimeout <= 0) {
            this.zkSessionTimeout = 10000;
            logger.warn("[ClientConfig]: setZkSessionTimeout error, you set zkSessionTimeout:" + zkSessionTimeout);
            return;
        }
        if (zkSessionTimeout > 200000) {
            this.zkSessionTimeout = 200000;
            logger.warn("[ClientConfig]: setZkSessionTimeout too large, you set zkSessionTimeout:" + zkSessionTimeout + ", max:" + 200000);
            return;
        }
        this.zkSessionTimeout = zkSessionTimeout;
    }

    @Override
    public int getZkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public void setZkConnectionTimeout(int zkConnectionTimeout) {
        if (zkConnectionTimeout <= 0) {
            this.zkConnectionTimeout = 10000;
            logger.warn("[ClientConfig]: setZkConnectionTimeout error, you set zkConnectionTimeout:" + zkConnectionTimeout);
            return;
        }
        if (zkConnectionTimeout > 200000) {
            this.zkConnectionTimeout = 200000;
            logger.warn("[ClientConfig]: setZkConnectionTimeout too large, you set zkConnectionTimeout:" + zkConnectionTimeout + ", max:" + 200000);
            return;
        }
        this.zkConnectionTimeout = zkConnectionTimeout;
    }

    @Override
    public boolean isSpring() {
        return this.isSpring;
    }

    @Override
    public void setSpring(boolean isSpring) {
        this.isSpring = isSpring;
    }

    @Override
    public int getQueueSize() {
        return this.queueSize;
    }

    @Override
    public void setQueueSize(int queueSize) {
        if (queueSize <= 0) {
            this.queueSize = 10000;
            logger.warn("[ClientConfig]: setQueueSize error, you set queueSize:" + queueSize);
            return;
        }
        if (queueSize > 100000) {
            this.queueSize = 100000;
            logger.warn("[ClientConfig]: setQueueSize too large, you set queueSize:" + queueSize + ", max:" + 100000);
            return;
        }
        this.queueSize = queueSize;
    }

    @Override
    public int getConsumerThreads() {
        return this.consumerThreads;
    }

    @Override
    public void setConsumerThreads(int consumerThreads) {
        this.consumerThreads = this.checkConsumerThreads(consumerThreads);
    }

    @Override
    public int checkConsumerThreads(int consumerThreads) {
        if (consumerThreads <= 0) {
            logger.warn("[ClientConfig]: setConsumerThreads error, you set consumerThreads:" + consumerThreads);
            return 5;
        }
        if (consumerThreads > 500) {
            logger.warn("[ClientConfig]: setConsumerThreads too large, you set consumerThreads:" + consumerThreads + ", max:" + 500);
            return 500;
        }
        return consumerThreads;
    }

    @Override
    public Map<String, Integer> getConsumerThreadsMap() {
        return this.consumerThreadsMap;
    }

    @Override
    public void setConsumerThreadsMap(Map<String, Integer> consumerThreadsMap) {
        this.consumerThreadsMap = consumerThreadsMap;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public void setPageSize(int pageSize) {
        this.pageSize = this.checkPageSize(pageSize);
    }

    @Override
    public int checkPageSize(int pageSize) {
        if (pageSize <= 0) {
            logger.warn("[ClientConfig]: setPageSize error, you set pageSize:" + pageSize);
            return 1000;
        }
        if (pageSize > 2000) {
            logger.warn("[ClientConfig]: setPageSize too large, you set pageSize:" + pageSize + ", max:" + 2000);
            return 2000;
        }
        return pageSize;
    }

    @Override
    public Map<String, Integer> getPageSizeMap() {
        return this.pageSizeMap;
    }

    @Override
    public void setPageSizeMap(Map<String, Integer> pageSizeMap) {
        this.pageSizeMap = pageSizeMap;
    }

    @Override
    public String getAccessKey() {
        return this.accessKey;
    }

    @Override
    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    @Override
    public String getLocalAddress() {
        return this.localAddress;
    }

    @Override
    public void setLocalAddress(String localAddress) {
        this.localAddress = localAddress;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Override
    public boolean isCrashRetry() {
        return this.crashRetry;
    }

    @Override
    public void setCrashRetry(boolean crashRetry) {
        this.crashRetry = crashRetry;
    }

    @Override
    public long getPullTaskListOverSleepTime() {
        return this.pullTaskListOverSleepTime;
    }

    @Override
    public void setPullTaskListOverSleepTime(long pullTaskListOverSleepTime) {
        this.pullTaskListOverSleepTime = pullTaskListOverSleepTime;
    }

    @Override
    public Map<String, FailureJobProcessor> getFailureJobProcessorMap() {
        return this.failureJobProcessorMap;
    }

    @Override
    public void setFailureJobProcessorMap(Map<String, FailureJobProcessor> failureJobProcessorMap) {
        this.failureJobProcessorMap = failureJobProcessorMap;
    }

    @Override
    public boolean isFinishLog() {
        return this.finishLog;
    }

    @Override
    public void setFinishLog(boolean finishLog) {
        this.finishLog = finishLog;
    }

    @Override
    public StopJobProcessor getStopJobProcessor() {
        return this.stopJobProcessor;
    }

    @Override
    public void setStopJobProcessor(StopJobProcessor stopJobProcessor) {
        this.stopJobProcessor = stopJobProcessor;
    }

    @Override
    public boolean isEveryTimeNew() {
        return this.isEveryTimeNew;
    }

    @Override
    public void setEveryTimeNew(boolean isEveryTimeNew) {
        this.isEveryTimeNew = isEveryTimeNew;
    }

    @Override
    public boolean isZkHostsAutoChange() {
        return this.zkHostsAutoChange;
    }

    @Override
    public void setZkHostsAutoChange(boolean zkHostsAutoChange) {
        this.zkHostsAutoChange = zkHostsAutoChange;
    }

    @Override
    public long getMaxBodySize() {
        return this.maxBodySize;
    }

    @Override
    public void setMaxBodySize(long maxBodySize) {
        this.maxBodySize = maxBodySize;
    }

    @Override
    public String getSecretKey() {
        return this.secretKey;
    }

    @Override
    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    @Override
    public String getEnvironment() {
        return this.environment;
    }

    @Override
    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    @Override
    public Map<String, String> getJobMap() {
        return this.jobMap;
    }

    @Override
    public void setJobMap(Map<String, String> jobMap) {
        this.jobMap = jobMap;
    }

    @Override
    public Machine getMachine() {
        return this.machine;
    }

    @Override
    public void setMachine(Machine machine) {
        this.machine = machine;
    }

    @Override
    public String getDomainName() {
        return this.domainName;
    }

    @Override
    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    @Override
    public String getServiceGroup() {
        return this.serviceGroup;
    }

    @Override
    public void setServiceGroup(String serviceGroup) {
        this.serviceGroup = serviceGroup;
    }

    @Override
    public String getRegionName() {
        return this.regionName;
    }

    @Override
    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    @Override
    public String getSignature() {
        return this.signature;
    }

    @Override
    public void setSignature(String signature) {
        this.signature = signature;
    }

    @Override
    public boolean isAutoInit() {
        return this.autoInit;
    }

    @Override
    public void setAutoInit(boolean autoInit) {
        this.autoInit = autoInit;
    }

    @Override
    public String getConfigPath() {
        return this.configPath;
    }

    @Override
    public void setConfigPath(String configPath) {
        this.configPath = configPath;
    }

    @Override
    public boolean isAgent() {
        return this.isAgent;
    }

    @Override
    public void setAgent(boolean isAgent) {
        this.isAgent = isAgent;
    }

    @Override
    public boolean isNewInstance() {
        return this.newInstance;
    }

    @Override
    public void setNewInstance(boolean newInstance) {
        this.newInstance = newInstance;
    }

    @Override
    public boolean isNewVersion() {
        return this.newVersion;
    }

    @Override
    public void setNewVersion(boolean newVersion) {
        this.newVersion = newVersion;
    }

    @Override
    public String toString() {
        return "ClientConfig [remotingThreads=" + this.remotingThreads + ", heartBeatIntervalTime=" + this.heartBeatIntervalTime + ", connectionTimeout=" + this.connectionTimeout + ", groupId=" + this.groupId + ", zkHosts=" + this.zkHosts + ", namespace=" + this.namespace + ", zkSessionTimeout=" + this.zkSessionTimeout + ", zkConnectionTimeout=" + this.zkConnectionTimeout + ", isSpring=" + this.isSpring + ", queueSize=" + this.queueSize + ", consumerThreads=" + this.consumerThreads + ", consumerThreadsMap=" + this.consumerThreadsMap + ", version=" + this.version + ", pageSize=" + this.pageSize + ", pageSizeMap=" + this.pageSizeMap + ", accessKey=" + this.accessKey + ", secretKey=" + this.secretKey + ", localAddress=" + this.localAddress + ", clientId=" + this.clientId + ", crashRetry=" + this.crashRetry + ", pullTaskListOverSleepTime=" + this.pullTaskListOverSleepTime + ", failureJobProcessorMap=" + this.failureJobProcessorMap + ", stopJobProcessor=" + this.stopJobProcessor + ", finishLog=" + this.finishLog + ", isEveryTimeNew=" + this.isEveryTimeNew + ", zkHostsAutoChange=" + this.zkHostsAutoChange + ", maxBodySize=" + this.maxBodySize + ", environment=" + this.environment + ", signature=" + this.signature + ", jobMap=" + this.jobMap + ", machine=" + this.machine + ", domainName=" + this.domainName + ", serviceGroup=" + this.serviceGroup + ", regionName=" + this.regionName + ", serviceGroupId=" + this.serviceGroupId + ", autoInit=" + this.autoInit + ", isAgent=" + this.isAgent + ", newInstance=" + this.newInstance + ", configPath=" + this.configPath + ", connectTime=" + this.connectTime + ", innerDebug=" + this.innerDebug + ", newVersion=" + this.newVersion + "]";
    }

    static class Response<T> {
        private boolean success;
        private T data;

        Response() {
        }

        public boolean isSuccess() {
            return this.success;
        }

        public void setSuccess(boolean success) {
            this.success = success;
        }

        public T getData() {
            return this.data;
        }

        public void setData(T data) {
            this.data = data;
        }
    }
}

