/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.diamond.client.impl;

import com.taobao.diamond.client.impl.DiamondEnv;
import com.taobao.diamond.client.impl.LocalConfigInfoProcessor;
import com.taobao.diamond.client.impl.ManagerListenerWrap;
import com.taobao.diamond.client.impl.TenantUtil;
import com.taobao.diamond.exception.DiamondException;
import com.taobao.diamond.manager.ManagerListener;
import com.taobao.diamond.manager.SharedManagerListenerAdapter;
import com.taobao.diamond.manager.impl.ConfigResponse;
import com.taobao.diamond.md5.MD5;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class CacheData {
    private final DiamondEnv env;
    public final String dataId;
    public final String group;
    public final String tenant;
    private final CopyOnWriteArrayList<ManagerListenerWrap> listeners;
    private volatile String md5;
    private volatile boolean isUseLocalConfig = false;
    private volatile long localConfigLastModified;
    private volatile String content;
    private int taskId;
    private volatile boolean isInitializing = true;

    public boolean isInitializing() {
        return this.isInitializing;
    }

    public void setInitializing(boolean isInitializing) {
        this.isInitializing = isInitializing;
    }

    public String getMd5() {
        return this.md5;
    }

    public String getTenant() {
        return this.tenant;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String newContent) {
        this.content = newContent;
        this.md5 = CacheData.getMd5String(this.content);
    }

    public void addListener(ManagerListener listener) {
        if (null == listener) {
            throw new IllegalArgumentException("listener is null");
        }
        ManagerListenerWrap wrap = new ManagerListenerWrap(listener);
        if (this.listeners.addIfAbsent(wrap)) {
            DiamondEnv.log.info(this.env.getName(), "[add-listener] ok, tenant={}, dataId={}, group={}, cnt={}", this.tenant, this.dataId, this.group, this.listeners.size());
        }
    }

    public void removeListener(ManagerListener listener) {
        if (null == listener) {
            throw new IllegalArgumentException("listener is null");
        }
        ManagerListenerWrap wrap = new ManagerListenerWrap(listener);
        if (this.listeners.remove(wrap)) {
            DiamondEnv.log.info(this.env.getName(), "[remove-listener] ok, dataId={}, group={}, cnt={}", this.dataId, this.group, this.listeners.size());
        }
    }

    public List<ManagerListener> getListeners() {
        ArrayList<ManagerListener> result = new ArrayList<ManagerListener>();
        for (ManagerListenerWrap wrap : this.listeners) {
            result.add(wrap.listener);
        }
        return result;
    }

    public long getLocalConfigInfoVersion() {
        return this.localConfigLastModified;
    }

    public void setLocalConfigInfoVersion(long localConfigLastModified) {
        this.localConfigLastModified = localConfigLastModified;
    }

    public boolean isUseLocalConfigInfo() {
        return this.isUseLocalConfig;
    }

    public void setUseLocalConfigInfo(boolean useLocalConfigInfo) {
        this.isUseLocalConfig = useLocalConfigInfo;
        if (!useLocalConfigInfo) {
            this.localConfigLastModified = -1L;
        }
    }

    public int getTaskId() {
        return this.taskId;
    }

    public void setTaskId(int taskId) {
        this.taskId = taskId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dataId == null ? 0 : this.dataId.hashCode());
        result = 31 * result + (this.group == null ? 0 : this.group.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (null == obj || obj.getClass() != this.getClass()) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        CacheData other = (CacheData)obj;
        return this.dataId.equals(other.dataId) && this.group.equals(other.group);
    }

    public String toString() {
        return "CacheData [" + this.dataId + ", " + this.group + "]";
    }

    void checkListenerMd5() {
        for (ManagerListenerWrap wrap : this.listeners) {
            if (this.md5.equals(wrap.lastCallMd5)) continue;
            CacheData.safeNotifyListener(this.env, this.dataId, this.group, this.content, this.md5, wrap);
        }
    }

    static void safeNotifyListener(final DiamondEnv env, final String dataId, final String group, final String content, final String md5, final ManagerListenerWrap listenerWrap) {
        final ManagerListener listener = listenerWrap.listener;
        Runnable job = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ClassLoader diamondClassLoader = Thread.currentThread().getContextClassLoader();
                ClassLoader appClassLoader = listener.getClass().getClassLoader();
                try {
                    if (listener instanceof SharedManagerListenerAdapter) {
                        SharedManagerListenerAdapter adapter = (SharedManagerListenerAdapter)listener;
                        adapter.fillContext(dataId, group);
                        DiamondEnv.log.info(env.getName(), "[notify-context] dataId={}, group={}, md5={}", dataId, group, md5);
                    }
                    Thread.currentThread().setContextClassLoader(appClassLoader);
                    ConfigResponse cr = new ConfigResponse();
                    cr.setDataId(dataId);
                    cr.setGroup(group);
                    cr.setContent(content);
                    env.getConfigFilterChainManager().doFilter(null, cr);
                    String contentTmp = cr.getContent();
                    listener.receiveConfigInfo(contentTmp);
                    listenerWrap.lastCallMd5 = md5;
                    DiamondEnv.log.info(env.getName(), "[notify-ok] dataId={}, group={}, md5={}, listener={} ", dataId, group, md5, listener);
                }
                catch (DiamondException de) {
                    DiamondEnv.log.error(env.getName(), "DIAMOND-XXXX", "[notify-error] dataId={}, group={}, md5={}, listener={} errCode={} errMsg={}", dataId, group, md5, listener, de.getErrCode(), de.getErrMsg());
                }
                catch (Throwable t) {
                    DiamondEnv.log.error(env.getName(), "DIAMOND-XXXX", "[notify-error] dataId={}, group={}, md5={}, listener={} tx={}", dataId, group, md5, listener, t.getCause());
                }
                finally {
                    Thread.currentThread().setContextClassLoader(diamondClassLoader);
                }
            }
        };
        long startNotify = System.currentTimeMillis();
        try {
            if (null != listener.getExecutor()) {
                listener.getExecutor().execute(job);
            } else {
                job.run();
            }
        }
        catch (Throwable t) {
            DiamondEnv.log.error(env.getName(), "DIAMOND-XXXX", "[notify-error] dataId={}, group={}, md5={}, listener={} throwable={}", dataId, group, md5, listener, t.getCause());
        }
        long finishNotify = System.currentTimeMillis();
        DiamondEnv.log.info(env.getName(), "[notify-listener] time cost={}ms in ClientWorker, dataId={}, group={}, md5={}, listener={} ", finishNotify - startNotify, dataId, group, md5, listener);
    }

    public static String getMd5String(String config) {
        return null == config ? "" : MD5.getInstance().getMD5String(config);
    }

    private String loadCacheContentFromDiskLocal(DiamondEnv env, String dataId, String group, String tenant) {
        String content = LocalConfigInfoProcessor.getFailover(env, dataId, group, tenant);
        content = null != content ? content : LocalConfigInfoProcessor.getSnapshot(env, dataId, group, tenant);
        return content;
    }

    public CacheData(DiamondEnv env, String dataId, String group) {
        if (null == dataId || null == group) {
            throw new IllegalArgumentException("dataId=" + dataId + ", group=" + group);
        }
        this.env = env;
        this.dataId = dataId;
        this.group = group;
        this.tenant = TenantUtil.getDefaultTenant();
        this.listeners = new CopyOnWriteArrayList();
        this.isInitializing = true;
        this.content = this.loadCacheContentFromDiskLocal(env, dataId, group, this.tenant);
        this.md5 = CacheData.getMd5String(this.content);
    }

    public CacheData(DiamondEnv env, String dataId, String group, String tenant) {
        if (null == dataId || null == group) {
            throw new IllegalArgumentException("dataId=" + dataId + ", group=" + group);
        }
        this.env = env;
        this.dataId = dataId;
        this.group = group;
        this.tenant = tenant;
        this.listeners = new CopyOnWriteArrayList();
        this.isInitializing = true;
        this.content = this.loadCacheContentFromDiskLocal(env, dataId, group, tenant);
        this.md5 = CacheData.getMd5String(this.content);
    }
}

