/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.acm.shaded.com.aliyuncs.regions;

import com.alibaba.acm.shaded.com.aliyuncs.auth.Credential;
import com.alibaba.acm.shaded.com.aliyuncs.exceptions.ClientException;
import com.alibaba.acm.shaded.com.aliyuncs.regions.Endpoint;
import com.alibaba.acm.shaded.com.aliyuncs.regions.IEndpointsProvider;
import com.alibaba.acm.shaded.com.aliyuncs.regions.LocationConfig;
import com.alibaba.acm.shaded.com.aliyuncs.regions.ProductDomain;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;

public class CustomizedEndpointsParser
implements IEndpointsProvider {
    private Endpoint endpoint;

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    @Override
    public Endpoint getEndpoint(String regionId, String product) throws ClientException {
        if (this.endpoint != null) {
            for (String region : this.endpoint.getRegionIds()) {
                if (!region.equals(regionId)) continue;
                for (ProductDomain productDomain : this.endpoint.getProductDomains()) {
                    if (!productDomain.getProductName().equals(product)) continue;
                    return this.endpoint;
                }
            }
        }
        return null;
    }

    @Override
    public Endpoint getEndpoint(String region, String product, String serviceCode, String endpointType, Credential credential, LocationConfig locationConfig) throws ClientException {
        throw new UnsupportedOperationException();
    }

    public static CustomizedEndpointsParser initParser(String regionId, Map<String, String> productDomainMap) {
        CustomizedEndpointsParser parser = new CustomizedEndpointsParser();
        if (regionId == null || regionId.length() == 0 || productDomainMap == null) {
            return null;
        }
        HashSet<String> regionIds = new HashSet<String>();
        regionIds.add(regionId);
        ArrayList<ProductDomain> productDomainList = new ArrayList<ProductDomain>();
        for (String productName : productDomainMap.keySet()) {
            productDomainList.add(new ProductDomain(productName, productDomainMap.get(productName)));
        }
        Endpoint endpoint = new Endpoint(regionId, regionIds, productDomainList);
        parser.setEndpoint(endpoint);
        return parser;
    }
}

