/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.write.executor;

import com.alibaba.excel.context.WriteContext;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.enums.WriteDirectionEnum;
import com.alibaba.excel.enums.WriteTemplateAnalysisCellTypeEnum;
import com.alibaba.excel.exception.ExcelGenerateException;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import com.alibaba.excel.util.CollectionUtils;
import com.alibaba.excel.util.StringUtils;
import com.alibaba.excel.util.WriteHandlerUtils;
import com.alibaba.excel.write.executor.AbstractExcelWriteExecutor;
import com.alibaba.excel.write.metadata.fill.AnalysisCell;
import com.alibaba.excel.write.metadata.fill.FillConfig;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.cglib.beans.BeanMap;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class ExcelWriteFillExecutor
extends AbstractExcelWriteExecutor {
    private static final String ESCAPE_FILL_PREFIX = "\\\\\\{";
    private static final String ESCAPE_FILL_SUFFIX = "\\\\\\}";
    private static final String FILL_PREFIX = "{";
    private static final String FILL_SUFFIX = "}";
    private static final char IGNORE_CHAR = '\\';
    private static final String COLLECTION_PREFIX = ".";
    private Map<Integer, List<AnalysisCell>> templateAnalysisCache = new HashMap<Integer, List<AnalysisCell>>(8);
    private Map<Integer, List<AnalysisCell>> templateCollectionAnalysisCache = new HashMap<Integer, List<AnalysisCell>>(8);
    private Map<Integer, Map<AnalysisCell, CellStyle>> collectionFieldStyleCache = new HashMap<Integer, Map<AnalysisCell, CellStyle>>(8);
    private Map<Integer, Short> collectionRowHeightCache = new HashMap<Integer, Short>(8);
    private Map<Integer, Map<AnalysisCell, Integer>> collectionLastIndexCache = new HashMap<Integer, Map<AnalysisCell, Integer>>(8);

    public ExcelWriteFillExecutor(WriteContext writeContext) {
        super(writeContext);
    }

    public void fill(Object data, FillConfig fillConfig) {
        if (fillConfig == null) {
            fillConfig = FillConfig.builder().build(true);
        }
        fillConfig.init();
        if (data instanceof Collection) {
            List<AnalysisCell> analysisCellList = this.readTemplateData(this.templateCollectionAnalysisCache);
            Collection collectionData = (Collection)data;
            if (CollectionUtils.isEmpty(collectionData)) {
                return;
            }
            Iterator iterator = collectionData.iterator();
            if (WriteDirectionEnum.VERTICAL.equals((Object)fillConfig.getDirection()) && fillConfig.getForceNewRow().booleanValue()) {
                this.shiftRows(collectionData.size(), analysisCellList);
            }
            while (iterator.hasNext()) {
                this.doFill(analysisCellList, iterator.next(), fillConfig);
            }
        } else {
            this.doFill(this.readTemplateData(this.templateAnalysisCache), data, fillConfig);
        }
    }

    private void shiftRows(int size, List<AnalysisCell> analysisCellList) {
        if (CollectionUtils.isEmpty(analysisCellList)) {
            return;
        }
        int maxRowIndex = 0;
        Integer sheetNo = this.writeContext.writeSheetHolder().getSheetNo();
        Map<AnalysisCell, Integer> collectionLastIndexMap = this.collectionLastIndexCache.get(sheetNo);
        for (AnalysisCell analysisCell : analysisCellList) {
            Integer lastRowIndex;
            if (collectionLastIndexMap != null && (lastRowIndex = collectionLastIndexMap.get(analysisCell)) != null) {
                if (lastRowIndex <= maxRowIndex) continue;
                maxRowIndex = lastRowIndex;
                continue;
            }
            if (analysisCell.getRowIndex() <= maxRowIndex) continue;
            maxRowIndex = analysisCell.getRowIndex();
        }
        Sheet cachedSheet = this.writeContext.writeSheetHolder().getCachedSheet();
        int lastRowIndex = cachedSheet.getLastRowNum();
        if (maxRowIndex >= lastRowIndex) {
            return;
        }
        Sheet sheet = this.writeContext.writeSheetHolder().getCachedSheet();
        int number = size;
        if (collectionLastIndexMap == null) {
            --number;
        }
        sheet.shiftRows(maxRowIndex + 1, lastRowIndex, number, true, false);
        for (AnalysisCell analysisCell : this.templateAnalysisCache.get(this.writeContext.writeSheetHolder().getSheetNo())) {
            if (analysisCell.getRowIndex() <= maxRowIndex) continue;
            analysisCell.setRowIndex(analysisCell.getRowIndex() + number);
        }
    }

    private void doFill(List<AnalysisCell> analysisCellList, Object oneRowData, FillConfig fillConfig) {
        Map dataMap = oneRowData instanceof Map ? (Map)oneRowData : BeanMap.create((Object)oneRowData);
        WriteSheetHolder writeSheetHolder = this.writeContext.writeSheetHolder();
        Map<String, ExcelContentProperty> fieldNameContentPropertyMap = this.writeContext.currentWriteHolder().excelWriteHeadProperty().getFieldNameContentPropertyMap();
        for (AnalysisCell analysisCell : analysisCellList) {
            Cell cell = this.getOneCell(analysisCell, fillConfig);
            if (analysisCell.getOnlyOneVariable().booleanValue()) {
                String variable = analysisCell.getVariableList().get(0);
                if (this.writeContext.currentWriteHolder().ignore(variable, analysisCell.getColumnIndex()) || !dataMap.containsKey(variable)) continue;
                Object value = dataMap.get(variable);
                CellData cellData = this.converterAndSet(writeSheetHolder, value == null ? null : value.getClass(), cell, value, fieldNameContentPropertyMap.get(variable));
                WriteHandlerUtils.afterCellDispose(this.writeContext, cellData, cell, null, null, Boolean.FALSE);
                continue;
            }
            StringBuilder cellValueBuild = new StringBuilder();
            int index = 0;
            ArrayList<CellData> cellDataList = new ArrayList<CellData>();
            for (String variable : analysisCell.getVariableList()) {
                cellValueBuild.append(analysisCell.getPrepareDataList().get(index++));
                if (this.writeContext.currentWriteHolder().ignore(variable, analysisCell.getColumnIndex()) || !dataMap.containsKey(variable)) continue;
                Object value = dataMap.get(variable);
                CellData cellData = this.convert(writeSheetHolder, value == null ? null : value.getClass(), cell, value, fieldNameContentPropertyMap.get(variable));
                cellDataList.add(cellData);
                CellDataTypeEnum type = cellData.getType();
                if (type == null) continue;
                switch (type) {
                    case STRING: {
                        cellValueBuild.append(cellData.getStringValue());
                        break;
                    }
                    case BOOLEAN: {
                        cellValueBuild.append(cellData.getBooleanValue());
                        break;
                    }
                    case NUMBER: {
                        cellValueBuild.append(cellData.getNumberValue());
                        break;
                    }
                }
            }
            cellValueBuild.append(analysisCell.getPrepareDataList().get(index));
            cell.setCellValue(cellValueBuild.toString());
            WriteHandlerUtils.afterCellDispose(this.writeContext, cellDataList, cell, null, null, Boolean.FALSE);
        }
    }

    private Cell getOneCell(AnalysisCell analysisCell, FillConfig fillConfig) {
        Map<AnalysisCell, CellStyle> collectionFieldStyleMap;
        Cell cell;
        Integer lastColumnIndex;
        Integer lastRowIndex;
        Sheet cachedSheet = this.writeContext.writeSheetHolder().getCachedSheet();
        if (WriteTemplateAnalysisCellTypeEnum.COMMON.equals((Object)analysisCell.getCellType())) {
            return cachedSheet.getRow(analysisCell.getRowIndex()).getCell(analysisCell.getColumnIndex());
        }
        Integer sheetNo = this.writeContext.writeSheetHolder().getSheetNo();
        Sheet sheet = this.writeContext.writeSheetHolder().getSheet();
        Map<AnalysisCell, Integer> collectionLastIndexMap = this.collectionLastIndexCache.get(sheetNo);
        if (collectionLastIndexMap == null) {
            collectionLastIndexMap = new HashMap<AnalysisCell, Integer>(16);
            this.collectionLastIndexCache.put(sheetNo, collectionLastIndexMap);
        }
        boolean isOriginalCell = false;
        switch (fillConfig.getDirection()) {
            case VERTICAL: {
                lastRowIndex = collectionLastIndexMap.get(analysisCell);
                if (lastRowIndex == null) {
                    lastRowIndex = analysisCell.getRowIndex();
                    collectionLastIndexMap.put(analysisCell, lastRowIndex);
                    isOriginalCell = true;
                } else {
                    lastRowIndex = lastRowIndex + 1;
                    collectionLastIndexMap.put(analysisCell, lastRowIndex);
                }
                lastColumnIndex = analysisCell.getColumnIndex();
                break;
            }
            case HORIZONTAL: {
                lastRowIndex = analysisCell.getRowIndex();
                lastColumnIndex = collectionLastIndexMap.get(analysisCell);
                if (lastColumnIndex == null) {
                    lastColumnIndex = analysisCell.getColumnIndex();
                    collectionLastIndexMap.put(analysisCell, lastColumnIndex);
                    isOriginalCell = true;
                    break;
                }
                lastColumnIndex = lastColumnIndex + 1;
                collectionLastIndexMap.put(analysisCell, lastColumnIndex);
                break;
            }
            default: {
                throw new ExcelGenerateException("The wrong direction.");
            }
        }
        Row row = sheet.getRow(lastRowIndex.intValue());
        if (row == null) {
            row = cachedSheet.getRow(lastRowIndex.intValue());
            if (row == null) {
                WriteHandlerUtils.beforeRowCreate(this.writeContext, lastRowIndex, null, Boolean.FALSE);
                row = fillConfig.getForceNewRow() != false ? cachedSheet.createRow(lastRowIndex.intValue()) : sheet.createRow(lastRowIndex.intValue());
                this.checkRowHeight(analysisCell, fillConfig, isOriginalCell, row, sheetNo);
                WriteHandlerUtils.afterRowCreate(this.writeContext, row, null, Boolean.FALSE);
            } else {
                this.checkRowHeight(analysisCell, fillConfig, isOriginalCell, row, sheetNo);
            }
        }
        if ((cell = row.getCell(lastColumnIndex.intValue())) == null) {
            WriteHandlerUtils.beforeCellCreate(this.writeContext, row, null, lastColumnIndex, null, Boolean.FALSE);
            cell = row.createCell(lastColumnIndex.intValue());
            WriteHandlerUtils.afterCellCreate(this.writeContext, cell, null, null, Boolean.FALSE);
        }
        if ((collectionFieldStyleMap = this.collectionFieldStyleCache.get(sheetNo)) == null) {
            collectionFieldStyleMap = new HashMap<AnalysisCell, CellStyle>(16);
            this.collectionFieldStyleCache.put(sheetNo, collectionFieldStyleMap);
        }
        if (isOriginalCell) {
            collectionFieldStyleMap.put(analysisCell, cell.getCellStyle());
        } else {
            CellStyle cellStyle = collectionFieldStyleMap.get(analysisCell);
            if (cellStyle != null) {
                cell.setCellStyle(cellStyle);
            }
        }
        return cell;
    }

    private void checkRowHeight(AnalysisCell analysisCell, FillConfig fillConfig, boolean isOriginalCell, Row row, Integer sheetNo) {
        if (!analysisCell.getFirstColumn().booleanValue() || !WriteDirectionEnum.VERTICAL.equals((Object)fillConfig.getDirection())) {
            return;
        }
        if (isOriginalCell) {
            this.collectionRowHeightCache.put(sheetNo, row.getHeight());
            return;
        }
        Short rowHeight = this.collectionRowHeightCache.get(sheetNo);
        if (rowHeight != null) {
            row.setHeight(rowHeight.shortValue());
        }
    }

    private List<AnalysisCell> readTemplateData(Map<Integer, List<AnalysisCell>> analysisCache) {
        Integer sheetNo = this.writeContext.writeSheetHolder().getSheetNo();
        List<AnalysisCell> analysisCellList = analysisCache.get(sheetNo);
        if (analysisCellList != null) {
            return analysisCellList;
        }
        Sheet sheet = this.writeContext.writeSheetHolder().getCachedSheet();
        analysisCellList = new ArrayList<AnalysisCell>();
        ArrayList<AnalysisCell> collectionAnalysisCellList = new ArrayList<AnalysisCell>();
        HashSet<Integer> firstColumnCache = new HashSet<Integer>();
        for (int i = 0; i <= sheet.getLastRowNum(); ++i) {
            Row row = sheet.getRow(i);
            if (row == null) continue;
            for (int j = 0; j < row.getLastCellNum(); ++j) {
                String preparedData;
                Cell cell = row.getCell(j);
                if (cell == null || (preparedData = this.prepareData(cell, analysisCellList, collectionAnalysisCellList, i, j, firstColumnCache)) == null) continue;
                cell.setCellValue(preparedData);
            }
        }
        this.templateAnalysisCache.put(sheetNo, analysisCellList);
        this.templateCollectionAnalysisCache.put(sheetNo, collectionAnalysisCellList);
        return analysisCache.get(sheetNo);
    }

    private String prepareData(Cell cell, List<AnalysisCell> analysisCellList, List<AnalysisCell> collectionAnalysisCellList, int rowIndex, int columnIndex, Set<Integer> firstColumnCache) {
        int prefixIndex;
        if (!CellType.STRING.equals((Object)cell.getCellTypeEnum())) {
            return null;
        }
        String value = cell.getStringCellValue();
        if (StringUtils.isEmpty(value)) {
            return null;
        }
        StringBuilder preparedData = new StringBuilder();
        AnalysisCell analysisCell = null;
        int startIndex = 0;
        int length = value.length();
        int lastPrepareDataIndex = 0;
        block0: while (startIndex < length && (prefixIndex = value.indexOf(FILL_PREFIX, startIndex)) >= 0) {
            String variable;
            char prefixPrefixChar;
            if (prefixIndex != 0 && (prefixPrefixChar = value.charAt(prefixIndex - 1)) == '\\') {
                startIndex = prefixIndex + 1;
                continue;
            }
            int suffixIndex = -1;
            while (suffixIndex == -1 && startIndex < length) {
                suffixIndex = value.indexOf(FILL_SUFFIX, startIndex + 1);
                if (suffixIndex < 0) break block0;
                startIndex = suffixIndex + 1;
                char prefixSuffixChar = value.charAt(suffixIndex - 1);
                if (prefixSuffixChar != '\\') continue;
                suffixIndex = -1;
            }
            if (analysisCell == null) {
                analysisCell = this.initAnalysisCell(rowIndex, columnIndex);
            }
            if (StringUtils.isEmpty(variable = value.substring(prefixIndex + 1, suffixIndex))) continue;
            if (variable.startsWith(COLLECTION_PREFIX)) {
                if (StringUtils.isEmpty(variable = variable.substring(1))) continue;
                analysisCell.setCellType(WriteTemplateAnalysisCellTypeEnum.COLLECTION);
            }
            analysisCell.getVariableList().add(variable);
            if (lastPrepareDataIndex == prefixIndex) {
                analysisCell.getPrepareDataList().add("");
            } else {
                String data = this.convertPrepareData(value.substring(lastPrepareDataIndex, prefixIndex));
                preparedData.append(data);
                analysisCell.getPrepareDataList().add(data);
                analysisCell.setOnlyOneVariable(Boolean.FALSE);
            }
            lastPrepareDataIndex = suffixIndex + 1;
        }
        return this.dealAnalysisCell(analysisCell, value, rowIndex, lastPrepareDataIndex, length, analysisCellList, collectionAnalysisCellList, firstColumnCache, preparedData);
    }

    private String dealAnalysisCell(AnalysisCell analysisCell, String value, int rowIndex, int lastPrepareDataIndex, int length, List<AnalysisCell> analysisCellList, List<AnalysisCell> collectionAnalysisCellList, Set<Integer> firstColumnCache, StringBuilder preparedData) {
        if (analysisCell != null) {
            if (lastPrepareDataIndex == length) {
                analysisCell.getPrepareDataList().add("");
            } else {
                analysisCell.getPrepareDataList().add(this.convertPrepareData(value.substring(lastPrepareDataIndex)));
                analysisCell.setOnlyOneVariable(Boolean.FALSE);
            }
            if (WriteTemplateAnalysisCellTypeEnum.COMMON.equals((Object)analysisCell.getCellType())) {
                analysisCellList.add(analysisCell);
            } else {
                if (!firstColumnCache.contains(rowIndex)) {
                    analysisCell.setFirstColumn(Boolean.TRUE);
                    firstColumnCache.add(rowIndex);
                }
                collectionAnalysisCellList.add(analysisCell);
            }
            return preparedData.toString();
        }
        return null;
    }

    private AnalysisCell initAnalysisCell(Integer rowIndex, Integer columnIndex) {
        AnalysisCell analysisCell = new AnalysisCell();
        analysisCell.setRowIndex(rowIndex);
        analysisCell.setColumnIndex(columnIndex);
        analysisCell.setOnlyOneVariable(Boolean.TRUE);
        ArrayList<String> variableList = new ArrayList<String>();
        analysisCell.setVariableList(variableList);
        ArrayList<String> prepareDataList = new ArrayList<String>();
        analysisCell.setPrepareDataList(prepareDataList);
        analysisCell.setCellType(WriteTemplateAnalysisCellTypeEnum.COMMON);
        analysisCell.setFirstColumn(Boolean.FALSE);
        return analysisCell;
    }

    private String convertPrepareData(String prepareData) {
        prepareData = prepareData.replaceAll(ESCAPE_FILL_PREFIX, FILL_PREFIX);
        prepareData = prepareData.replaceAll(ESCAPE_FILL_SUFFIX, FILL_SUFFIX);
        return prepareData;
    }
}

