/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.qos.server.handler;

import com.alibaba.dubbo.common.logger.Logger;
import com.alibaba.dubbo.common.logger.LoggerFactory;
import com.alibaba.dubbo.qos.command.CommandContext;
import com.alibaba.dubbo.qos.command.CommandExecutor;
import com.alibaba.dubbo.qos.command.DefaultCommandExecutor;
import com.alibaba.dubbo.qos.command.NoSuchCommandException;
import com.alibaba.dubbo.qos.command.decoder.TelnetCommandDecoder;
import com.alibaba.dubbo.qos.server.handler.QosProcessHandler;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.concurrent.GenericFutureListener;
import org.apache.commons.lang3.StringUtils;

public class TelnetProcessHandler
extends SimpleChannelInboundHandler<String> {
    private static final Logger log = LoggerFactory.getLogger(TelnetProcessHandler.class);
    private static CommandExecutor commandExecutor = new DefaultCommandExecutor();

    protected void channelRead0(ChannelHandlerContext ctx, String msg) throws Exception {
        if (StringUtils.isBlank((CharSequence)msg)) {
            ctx.writeAndFlush((Object)QosProcessHandler.prompt);
        } else {
            CommandContext commandContext = TelnetCommandDecoder.decode(msg);
            commandContext.setRemote(ctx.channel());
            try {
                String result = commandExecutor.execute(commandContext);
                if (StringUtils.equals((CharSequence)"close!", (CharSequence)result)) {
                    ctx.writeAndFlush((Object)this.getByeLabel()).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                } else {
                    ctx.writeAndFlush((Object)(result + "\r\n" + QosProcessHandler.prompt));
                }
            }
            catch (NoSuchCommandException ex) {
                ctx.writeAndFlush((Object)(msg + " :no such command"));
                ctx.writeAndFlush((Object)("\r\n" + QosProcessHandler.prompt));
                log.error("can not found command " + commandContext, (Throwable)ex);
            }
            catch (Exception ex) {
                ctx.writeAndFlush((Object)(msg + " :fail to execute commandContext by " + ex.getMessage()));
                ctx.writeAndFlush((Object)("\r\n" + QosProcessHandler.prompt));
                log.error("execute commandContext got exception " + commandContext, (Throwable)ex);
            }
        }
    }

    private String getByeLabel() {
        return "BYE!\n";
    }
}

