package com.taobao.spas.sdk.common.utils;

import com.taobao.spas.sdk.common.config.ConfigConstants;
import com.taobao.spas.sdk.common.config.SpasConfigLoader;

import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;

/**
 * Created by shaopeng.csp on 2015/3/12.
 */
public class SpasHttpClient {
    public static class HttpResult {
        final public int code;
        final public String content;

        public HttpResult(int code, String content) {
            this.code = code;
            this.content = content;
        }
    }

    private static int CONN_TIMEOUT_DEFAULT = 3000; // ms
    private static int READ_TIMEOUT_DEFAULT = 10000; // ms

    private static int connTimeout = CONN_TIMEOUT_DEFAULT;
    private static int readTimeout = READ_TIMEOUT_DEFAULT;

    static {
        connTimeout = Integer.valueOf(SpasConfigLoader.getProperty(ConfigConstants.ENV_HTTP_CONN_TIMEOUT, String.valueOf(CONN_TIMEOUT_DEFAULT)));
        readTimeout = Integer.valueOf(SpasConfigLoader.getProperty(ConfigConstants.ENV_HTTP_READ_TIMEOUT, String.valueOf(READ_TIMEOUT_DEFAULT)));
    }

    public static HttpResult httpPostJson(String url, Map<String, String> properties, String content, String charset) throws IOException {

        HttpURLConnection conn = null;
        BufferedReader reader = null;
        try {
            conn = (HttpURLConnection) new URL(url).openConnection();
            conn.setRequestMethod("POST");
            conn.setConnectTimeout(connTimeout);
            conn.setReadTimeout(readTimeout);
            conn.setDoOutput(true);
            conn.setDoInput(true);

            conn.setUseCaches(false);
            conn.setInstanceFollowRedirects(true);

            conn.setRequestProperty("Content-Type","application/json");
            conn.setRequestProperty("Accept","application/json");

            if (properties != null) {
                for (Map.Entry<String, String> entry : properties.entrySet()) {
                    conn.setRequestProperty(entry.getKey(), entry.getValue());
                }
            }

            OutputStream out = conn.getOutputStream();
            out.write(content.getBytes());
            out.flush();

            int respCode = conn.getResponseCode();
            InputStream in;
            if (respCode >= HttpURLConnection.HTTP_OK && respCode < HttpURLConnection.HTTP_OK + 100) {
                in = conn.getInputStream();
            }
            else{
                in = conn.getErrorStream();
            }
            StringBuilder sb = new StringBuilder("");
            if (in != null) {
                reader = new BufferedReader(new InputStreamReader(in, charset));
                String line;
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                }
            }
            return new HttpResult(respCode, sb.toString());
        } finally {
            if (null != reader) {
                try {
                    reader.close();
                } catch (IOException e) {
                }
            }
            if (null != conn) {
                conn.disconnect();
            }
        }
    }

}
