package com.taobao.spas.sdk.common.sec;

import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

import org.apache.commons.codec.binary.Base64;

public class RSAUtils {

	public static final int ENCRYPT_MODE = Cipher.ENCRYPT_MODE;
	public static final int DECRYPT_MODE = Cipher.DECRYPT_MODE;

	private static final String ALGORITHM = "RSA";
    private static final Charset UTF8 = Charset.forName("UTF-8");
	
	private Cipher cipher = null;
	private int opmode = 0;
	
	public synchronized boolean init(int mode, String key) {
		if (opmode != 0) {
			return true;
		}
		
		if (mode != ENCRYPT_MODE && mode != DECRYPT_MODE) {
			return false;
		}
		
		if (key == null || key.isEmpty()) {
			return false;
		}
		
		try {
			cipher = Cipher.getInstance(ALGORITHM);
		} catch (NoSuchAlgorithmException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (NoSuchPaddingException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		finally {
			if (cipher == null) {
				return false;
			}
		}
		Key secKey = null;
		if (mode == ENCRYPT_MODE) {
			secKey = getEncKey(key);
		}
		else if (mode == DECRYPT_MODE) {
			secKey = getDecKey(key);
		}
		if (secKey == null) {
			return false;
		}
		try {
			cipher.init(mode, secKey);
		} catch (InvalidKeyException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return false;
		}
		opmode = mode;
		return true;
	}
	
	private static Key getEncKey(String encKey) {
		X509EncodedKeySpec keySpec = new X509EncodedKeySpec(Base64.decodeBase64(encKey.getBytes(UTF8)));
		PublicKey publicKey = null;
		try {
			KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
			publicKey = keyFactory.generatePublic(keySpec);
		} catch (NoSuchAlgorithmException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (InvalidKeySpecException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return publicKey;
	}
	
	private static Key getDecKey(String decKey) {
		PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(Base64.decodeBase64(decKey.getBytes(UTF8)));
		PrivateKey privateKey = null;
		try {
			KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
			privateKey = keyFactory.generatePrivate(keySpec);
		} catch (NoSuchAlgorithmException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (InvalidKeySpecException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return privateKey;
	}
	
	public synchronized String encrypt(String data) {
		if (opmode != ENCRYPT_MODE) {
			return null;
		}
		if (data == null) {
			return null;
		}
		byte[] encData = null;
		try {
			encData = cipher.doFinal(data.getBytes(UTF8));
		} catch (IllegalBlockSizeException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (BadPaddingException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		if (encData == null) {
			return null;
		}
		return new String(Base64.encodeBase64(encData), UTF8);
	}

	public synchronized String decrypt(String data) {
		if (opmode != DECRYPT_MODE) {
			return null;
		}
		if (data == null) {
			return null;
		}
		byte[] decData = null;
		try {
			decData = cipher.doFinal(Base64.decodeBase64(data.getBytes(UTF8)));
		} catch (IllegalBlockSizeException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (BadPaddingException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		if (decData == null) {
			return null;
		}
		return new String(decData, UTF8);
	}
}
