package com.taobao.spas.sdk.common.log;


import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Created by shaopeng.csp on 2015/1/5.
 */
public class SpasLogger {

    private static Logger logger = LoggerFactory.getLogger(SpasLogger.class);

    public static void info(String s) {
        logger.info(s);
    }

    public static void info(String appName, String s) {
        logger.info(formatAppName(appName), s);
    }

    public static void warn(String s) {
        logger.warn(s);
    }

    public static void warn(String appName, String s) {
        logger.warn(formatAppName(appName), s);
    }

    public static void error(String s) {
        logger.error("", s);
    }

    public static void error(String appName, String s) {
        logger.error(formatAppName(appName), "", s);
    }

    public static void error(String s, Throwable throwable) {
        logger.error("", s, throwable);
    }

    public static void error(String appName, String s, Throwable throwable) {
        logger.error(formatAppName(appName), "", s, throwable);
    }

    public static void info(SpasLogCode code, String s) {
        logger.info(formatLogMessage(code, s));
    }

    public static void info(SpasLogCode code, String appName, String s) {
        logger.info(formatAppName(appName), formatLogMessage(code, s));
    }

    public static void warn(SpasLogCode code, String s) {
        logger.warn(formatLogMessage(code, s));
    }

    public static void warn(SpasLogCode code, String appName, String s) {
        logger.warn(formatAppName(appName), formatLogMessage(code, s));
    }

    public static void error(SpasLogCode code, String s) {
        logger.error("", formatLogMessage(code, s));
    }

    public static void error(SpasLogCode code, String appName, String s) {
        logger.error(formatAppName(appName), "", formatLogMessage(code, s));
    }

    public static void error(SpasLogCode code, String s, Throwable throwable) {
        logger.error("", formatLogMessage(code, s), throwable);
    }

    public static void error(SpasLogCode code, String appName, String s, Throwable throwable) {
        logger.error(formatAppName(appName), "", formatLogMessage(code, s), throwable);
    }

    private static String formatAppName(String appName) {
        return appName == null ? "" : appName;
    }

    private static String formatLogMessage(SpasLogCode code, String s) {
        return String.format("[SPAS-%04d] %s", code.getValue(), s);
    }
}
