package com.taobao.spas.sdk.common.config;


import com.taobao.spas.sdk.common.log.SpasLogCode;
import com.taobao.spas.sdk.common.log.SpasLogger;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

/**
 * Created by shaopeng.csp on 2015/3/6.
 */
public class SpasConfigLoader {
    private static final String CONFIG_PATH = "/home/admin/spas_conf/global";
    private static final String APP_CONFIG_FORMAT = "spas_app_config_%s.%s";

    private static Map<String, String> properties = new ConcurrentHashMap<String, String>();
    private static ConcurrentHashMap<String, Map<String, String>> appProperties = new ConcurrentHashMap<String, Map<String, String>>();

    static {
        boolean disabled = "Y".equalsIgnoreCase(System.getProperty(ConfigConstants.ENV_CONFIG_DISABLE));
        if (!disabled) {
            Properties properties = new Properties();
            FileInputStream globalConfigIS = null;
            try {
                globalConfigIS = new FileInputStream(CONFIG_PATH);
            } catch (FileNotFoundException e) {
            }
            if (globalConfigIS != null) {
                try {
                    properties.load(globalConfigIS);
                } catch (IOException e) {
                    SpasLogger.error(SpasLogCode.SPAS0105, "Unable to load properties from " + CONFIG_PATH + ":" + e.getMessage());
                } finally {
                    try {
                        globalConfigIS.close();
                    } catch (IOException e) {
                    }
                }
            }

            for (Map.Entry<Object, Object> property : properties.entrySet()) {
                Properties currentProperties = System.getProperties();
                Object old = currentProperties.get(property.getKey());
                if (old == null) {
                    System.setProperty(property.getKey().toString(), property.getValue().toString());
                    SpasLogger.info("Set property " + property.getKey() + "=" + property.getValue());
                }
            }
        }
    }

    public static void init() {
        // just trigger static init
    }

    public static String getProperty(String key) {
        String value = properties.get(key);
        if (value == null) {
            value = System.getProperty(key);
            if (value != null) {
                properties.put(key, value);
            }
        }
        return value;
    }

    public static String getProperty(String key, String def) {
        String value = getProperty(key);
        return value != null ? value : def;
    }

    public static String getAppProperty(String appName, String key) {
        if (appName == null) {
            return getProperty(key);
        }
        Map<String, String> props = appProperties.get(appName);
        String value = props != null ? props.get(key) : null;
        if (value == null) {
            value = System.getProperty(String.format(APP_CONFIG_FORMAT, appName, key));
            if (value != null) {
                setAppProperty(appName, key, value);
            }
            else {
                value = getProperty(key);
            }
        }
        return value;
    }

    public static String getAppProperty(String appName, String key, String def) {
        String value = getAppProperty(appName, key);
        return value != null ? value : def;
    }

    public static void setProperty(String key, String value) {
        properties.put(key, value);
    }

    public static void setAppProperty(String appName, String key, String value) {
        Map<String, String> props = appProperties.get(appName);
        if (props == null) {
            props = new ConcurrentHashMap<String, String>();
            Map<String, String> old = appProperties.putIfAbsent(appName, props);
            if (old != null) {
                props = old;
            }
        }
        props.put(key, value);
    }
}
