package com.taobao.spas.sdk.client.identity;


import com.taobao.spas.sdk.client.Constants;
import com.taobao.spas.sdk.client.CredentialListener;
import com.taobao.spas.sdk.common.config.ConfigConstants;
import com.taobao.spas.sdk.common.config.SpasConfigLoader;
import com.taobao.spas.sdk.common.identity.SpasCredentialLoader;

import java.util.concurrent.ConcurrentHashMap;

public final class CredentialService implements SpasCredentialLoader {

    private static ConcurrentHashMap<String, CredentialService> instances = new ConcurrentHashMap<String, CredentialService>();

	private Credentials credentials = new Credentials();
    private CredentialWatcher watcher;
    private CredentialListener listener;
	
	private CredentialService(String appName) {
        if (appName == null) {
            appName = SpasConfigLoader.getProperty(ConfigConstants.ENV_APP_NAME);
        }
        watcher = new CredentialWatcher(appName, this);
	}
	
	public static CredentialService getInstance() {
        return getInstance(null);
	}

    public static CredentialService getInstance(String appName) {
        String key = appName != null ? appName : Constants.NO_APP_NAME;
        CredentialService instance = instances.get(key);
        if (instance == null) {
            instance = new CredentialService(appName);
            CredentialService previous = instances.putIfAbsent(key, instance);
            if (previous != null) {
                instance = previous;
            }
        }
        return instance;
    }
	
	public Credentials getCredential() {
        Credentials localCredential = credentials;
        if (localCredential.valid()) {
            return localCredential;
        }
		return credentials;
	}

    public void setCredential(Credentials credential) {
        boolean changed = !(credentials == credential || (credentials != null && credentials.identical(credential)));
        credentials = credential;
        if (changed && listener != null) {
            listener.onUpdateCredential();
        }
    }

    public void registerCredentialListener(CredentialListener listener) {
        this.listener = listener;
    }

    @Deprecated
	public void setAccessKey(String accessKey) {
		credentials.setAccessKey(accessKey);
	}

    @Deprecated
	public void setSecretKey(String secretKey) {
		credentials.setSecretKey(secretKey);
	}

    @Deprecated
	public String getAccessKey() {
		return credentials.getAccessKey();
	}

    @Deprecated
	public String getSecretKey() {
		return credentials.getSecretKey();
	}

}
