package com.taobao.spas.sdk.client;

import com.taobao.spas.sdk.client.identity.CredentialService;
import com.taobao.spas.sdk.client.identity.Credentials;
import com.taobao.spas.sdk.common.config.SpasConfigLoader;
import com.taobao.spas.sdk.common.identity.SpasCredentialLoader;


/***
 * Facade for spas sdk client
 *
 */
public class SpasSdkClientFacade {

	/***
	 * get accessKey
     * NOTE: during dynamic updating, accessKey may be not paired with secretKey returned by getSecretKey(), not recommended
	 * @return
	 */
    @Deprecated
	public static String getAccessKey() {
		return CredentialService.getInstance().getAccessKey();
	}
	
	
	/***
	 * get secretKey
     * NOTE: during dynamic updating, secretKey may be not paired with accessKey returned by getAccessKey(), not recommended
	 * @return
	 */
    @Deprecated
	public static String getSecretKey() {
		return CredentialService.getInstance().getSecretKey();
	}
	
	/***
	 * get credential
	 * @return
	 */
	public static Credentials getCredential() {
		return CredentialService.getInstance().getCredential();
	}

    /***
     * get credential loader
     * @return
     */
    public static SpasCredentialLoader getCredentialLoader() {
        return CredentialService.getInstance();
    }

    /***
     * get credential
     * @param appName
     * @return
     */
    public static Credentials getCredential(String appName) {
        return CredentialService.getInstance(appName).getCredential();
    }

    /***
     * get credential loader
     * @param appName
     * @return
     */
    public static SpasCredentialLoader getCredentialLoader(String appName) {
        return CredentialService.getInstance(appName);
    }

    /***
     * register credential update listener
     * @param listener
     */
    public static void registerCredentialListener(CredentialListener listener) {
        CredentialService.getInstance().registerCredentialListener(listener);
    }

    /***
     * register credential update listener
     * @param appName
     * @param listener
     */
    public static void registerCredentialListener(String appName, CredentialListener listener) {
        CredentialService.getInstance(appName).registerCredentialListener(listener);
    }
	
	/***
	 * get version
	 * @return
	 */
	public static String getVersion() {
		return Constants.VERSION.toString();
	}

    /***
     * set system level property
     * @param key
     * @param value
     */
    public static void setProperty(String key, String value) {
        SpasConfigLoader.setProperty(key, value);
    }

    /***
     * set app level property
     * @param appName
     * @param key
     * @param value
     */
    public static void setAppProperty(String appName, String key, String value) {
        SpasConfigLoader.setAppProperty(appName, key, value);
    }
}
