/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.audio.asr.recognition;

import com.alibaba.dashscope.api.SynchronizeFullDuplexApi;
import com.alibaba.dashscope.audio.asr.recognition.RecognitionParam;
import com.alibaba.dashscope.audio.asr.recognition.RecognitionResult;
import com.alibaba.dashscope.audio.asr.recognition.RecognitionState;
import com.alibaba.dashscope.common.DashScopeResult;
import com.alibaba.dashscope.common.Function;
import com.alibaba.dashscope.common.OutputMode;
import com.alibaba.dashscope.common.ResultCallback;
import com.alibaba.dashscope.common.Task;
import com.alibaba.dashscope.common.TaskGroup;
import com.alibaba.dashscope.exception.ApiException;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.alibaba.dashscope.exception.NoApiKeyException;
import com.alibaba.dashscope.protocol.ApiServiceOption;
import com.alibaba.dashscope.protocol.ClientOptions;
import com.alibaba.dashscope.protocol.Protocol;
import com.alibaba.dashscope.protocol.StreamingMode;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Emitter;
import io.reactivex.Flowable;
import java.io.File;
import java.io.FileInputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Recognition {
    private static final Logger log = LoggerFactory.getLogger(Recognition.class);
    SynchronizeFullDuplexApi<RecognitionParamWithStream> duplexApi;
    private ApiServiceOption serviceOption;
    private Emitter<ByteBuffer> audioEmitter;
    private final Queue<AsyncCmdBuffer> cmdBuffer = new LinkedList<AsyncCmdBuffer>();
    private RecognitionState state = RecognitionState.IDLE;
    private AtomicReference<CountDownLatch> stopLatch = new AtomicReference<Object>(null);

    public Recognition() {
        this.serviceOption = ((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)ApiServiceOption.builder().protocol(Protocol.WEBSOCKET)).streamingMode(StreamingMode.DUPLEX)).outputMode(OutputMode.ACCUMULATE)).taskGroup(TaskGroup.AUDIO.getValue())).task(Task.ASR.getValue())).function(Function.RECOGNITION.getValue())).build();
        this.duplexApi = new SynchronizeFullDuplexApi((ClientOptions)((ClientOptions.ClientOptionsBuilder)ClientOptions.builder().protocol(Protocol.WEBSOCKET.getValue())).build(), this.serviceOption);
    }

    public Flowable<RecognitionResult> streamCall(RecognitionParam param, Flowable<ByteBuffer> audioFrame) throws ApiException, NoApiKeyException {
        RecognitionParam paramWithStream = ((RecognitionParamWithStream.RecognitionParamWithStreamBuilder)((RecognitionParamWithStream.RecognitionParamWithStreamBuilder)((RecognitionParamWithStream.RecognitionParamWithStreamBuilder)((RecognitionParamWithStream.RecognitionParamWithStreamBuilder)((RecognitionParam.RecognitionParamBuilder)((RecognitionParamWithStream.RecognitionParamWithStreamBuilder)RecognitionParamWithStream.builder().format(param.getFormat())).audioStream(audioFrame)).disfluencyRemovalEnabled(param.isDisfluencyRemovalEnabled())).model(param.getModel())).sampleRate(param.getSampleRate())).apiKey(param.getApiKey())).build();
        return this.duplexApi.duplexCall((RecognitionParamWithStream)paramWithStream).map(item -> RecognitionResult.fromDashScopeResult(item)).filter(item -> item != null && item.getSentence() != null && !item.isCompleteResult());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void call(RecognitionParam param, final ResultCallback<RecognitionResult> callback) {
        block7: {
            if (param == null) {
                throw new ApiException(new InputRequiredException("Parameter invalid: RecognitionParam is null"));
            }
            if (callback == null) {
                throw new ApiException(new InputRequiredException("Parameter invalid: ResultCallback is null"));
            }
            Flowable audioFrames = Flowable.create(emitter -> {
                Recognition recognition = this;
                synchronized (recognition) {
                    if (this.cmdBuffer.size() > 0) {
                        for (AsyncCmdBuffer buffer : this.cmdBuffer) {
                            if (buffer.isStop) {
                                emitter.onComplete();
                                return;
                            }
                            emitter.onNext((Object)buffer.audioFrame);
                        }
                        this.cmdBuffer.clear();
                    }
                    this.audioEmitter = emitter;
                }
            }, (BackpressureStrategy)BackpressureStrategy.BUFFER);
            Recognition recognition = this;
            synchronized (recognition) {
                this.state = RecognitionState.RECOGNITION_STARTED;
                this.cmdBuffer.clear();
            }
            this.stopLatch = new AtomicReference<CountDownLatch>(new CountDownLatch(1));
            RecognitionParam paramWithStream = ((RecognitionParamWithStream.RecognitionParamWithStreamBuilder)((RecognitionParamWithStream.RecognitionParamWithStreamBuilder)((RecognitionParamWithStream.RecognitionParamWithStreamBuilder)((RecognitionParamWithStream.RecognitionParamWithStreamBuilder)((RecognitionParam.RecognitionParamBuilder)((RecognitionParamWithStream.RecognitionParamWithStreamBuilder)RecognitionParamWithStream.builder().format(param.getFormat())).audioStream((Flowable<ByteBuffer>)audioFrames)).disfluencyRemovalEnabled(param.isDisfluencyRemovalEnabled())).model(param.getModel())).sampleRate(param.getSampleRate())).apiKey(param.getApiKey())).build();
            try {
                this.duplexApi.duplexCall((RecognitionParamWithStream)paramWithStream, new ResultCallback<DashScopeResult>(){

                    @Override
                    public void onEvent(DashScopeResult message) {
                        RecognitionResult recognitionResult = RecognitionResult.fromDashScopeResult(message);
                        if (!recognitionResult.isCompleteResult()) {
                            callback.onEvent(recognitionResult);
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onComplete() {
                        Recognition recognition = Recognition.this;
                        synchronized (recognition) {
                            Recognition.this.state = RecognitionState.IDLE;
                        }
                        callback.onComplete();
                        if (Recognition.this.stopLatch.get() != null) {
                            ((CountDownLatch)Recognition.this.stopLatch.get()).countDown();
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onError(Exception e) {
                        Recognition recognition = Recognition.this;
                        synchronized (recognition) {
                            Recognition.this.state = RecognitionState.IDLE;
                        }
                        ApiException apiException = new ApiException(e);
                        apiException.setStackTrace(e.getStackTrace());
                        callback.onError(apiException);
                        if (Recognition.this.stopLatch.get() != null) {
                            ((CountDownLatch)Recognition.this.stopLatch.get()).countDown();
                        }
                    }
                });
            }
            catch (NoApiKeyException e) {
                ApiException apiException = new ApiException(e);
                apiException.setStackTrace(e.getStackTrace());
                callback.onError(apiException);
                if (this.stopLatch.get() == null) break block7;
                this.stopLatch.get().countDown();
            }
        }
        log.info("Recognition started");
    }

    public String call(RecognitionParam param, File file) {
        if (param == null) {
            throw new ApiException(new InputRequiredException("Parameter invalid: RecognitionParam is null"));
        }
        if (file == null || !file.canRead()) {
            throw new ApiException(new InputRequiredException("Parameter invalid: Input file is null or not exists"));
        }
        AtomicBoolean cancel = new AtomicBoolean(false);
        AtomicReference<Object> finalResult = new AtomicReference<Object>(null);
        AtomicReference<Object> finalError = new AtomicReference<Object>(null);
        ArrayList sentenceList = new ArrayList();
        Flowable audioFrames = Flowable.create(emitter -> new Thread(() -> {
            try {
                try (FileChannel channel = new FileInputStream(file).getChannel();){
                    ByteBuffer buffer = ByteBuffer.allocate(16384);
                    while (channel.read(buffer) != -1 && !cancel.get()) {
                        buffer.flip();
                        emitter.onNext((Object)buffer);
                        buffer = ByteBuffer.allocate(16384);
                        Thread.sleep(100L);
                    }
                }
                emitter.onComplete();
            }
            catch (Exception e) {
                emitter.onError((Throwable)e);
            }
        }).start(), (BackpressureStrategy)BackpressureStrategy.BUFFER);
        RecognitionParam paramWithStream = ((RecognitionParamWithStream.RecognitionParamWithStreamBuilder)((RecognitionParamWithStream.RecognitionParamWithStreamBuilder)((RecognitionParamWithStream.RecognitionParamWithStreamBuilder)((RecognitionParamWithStream.RecognitionParamWithStreamBuilder)((RecognitionParam.RecognitionParamBuilder)((RecognitionParamWithStream.RecognitionParamWithStreamBuilder)RecognitionParamWithStream.builder().format(param.getFormat())).audioStream((Flowable<ByteBuffer>)audioFrames)).disfluencyRemovalEnabled(param.isDisfluencyRemovalEnabled())).model(param.getModel())).sampleRate(param.getSampleRate())).apiKey(param.getApiKey())).build();
        try {
            this.duplexApi.duplexCall((RecognitionParamWithStream)paramWithStream).blockingSubscribe(res -> {
                RecognitionResult recognitionResult = RecognitionResult.fromDashScopeResult(res);
                if (!recognitionResult.isCompleteResult() && recognitionResult.isSentenceEnd()) {
                    sentenceList.add(recognitionResult.getSentence());
                }
            }, e -> {
                finalError.set(e);
                cancel.set(true);
            }, () -> {
                JsonObject jsonObject = new JsonObject();
                jsonObject.add("sentences", (JsonElement)new Gson().toJsonTree((Object)sentenceList).getAsJsonArray());
                finalResult.set(jsonObject.toString());
            });
        }
        catch (NoApiKeyException e2) {
            throw new ApiException(e2);
        }
        if (finalError.get() != null) {
            ApiException apiException = new ApiException(finalError.get());
            apiException.setStackTrace(((Throwable)finalError.get()).getStackTrace());
            throw apiException;
        }
        return finalResult.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAudioFrame(ByteBuffer audioFrame) {
        if (audioFrame == null) {
            throw new ApiException(new InputRequiredException("Parameter invalid: audioFrame is null"));
        }
        Recognition recognition = this;
        synchronized (recognition) {
            if (this.state != RecognitionState.RECOGNITION_STARTED) {
                throw new ApiException(new InputRequiredException("State invalid: expect recognition state is started but " + this.state.getValue()));
            }
            if (this.audioEmitter == null) {
                this.cmdBuffer.add((AsyncCmdBuffer)((AsyncCmdBuffer.AsyncCmdBufferBuilder)AsyncCmdBuffer.builder().audioFrame(audioFrame)).build());
            } else {
                this.audioEmitter.onNext((Object)audioFrame);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Recognition recognition = this;
        synchronized (recognition) {
            if (this.state != RecognitionState.RECOGNITION_STARTED) {
                throw new ApiException(new RuntimeException("State invalid: expect recognition state is started but " + this.state.getValue()));
            }
            if (this.audioEmitter == null) {
                this.cmdBuffer.add((AsyncCmdBuffer)((AsyncCmdBuffer.AsyncCmdBufferBuilder)AsyncCmdBuffer.builder().isStop(true)).build());
            } else {
                this.audioEmitter.onComplete();
            }
        }
        if (this.stopLatch.get() != null) {
            try {
                this.stopLatch.get().await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static class RecognitionParamWithStream
    extends RecognitionParam {
        @NonNull
        private Flowable<ByteBuffer> audioStream;

        @Override
        public Flowable<Object> getStreamingData() {
            return this.audioStream.cast(Object.class);
        }

        protected RecognitionParamWithStream(RecognitionParamWithStreamBuilder<?, ?> b) {
            super((RecognitionParam.RecognitionParamBuilder<?, ?>)b);
            this.audioStream = ((RecognitionParamWithStreamBuilder)b).audioStream;
            if (this.audioStream == null) {
                throw new NullPointerException("audioStream is marked non-null but is null");
            }
        }

        public static RecognitionParamWithStreamBuilder<?, ?> builder() {
            return new RecognitionParamWithStreamBuilderImpl();
        }

        private static final class RecognitionParamWithStreamBuilderImpl
        extends RecognitionParamWithStreamBuilder<RecognitionParamWithStream, RecognitionParamWithStreamBuilderImpl> {
            private RecognitionParamWithStreamBuilderImpl() {
            }

            @Override
            protected RecognitionParamWithStreamBuilderImpl self() {
                return this;
            }

            @Override
            public RecognitionParamWithStream build() {
                return new RecognitionParamWithStream(this);
            }
        }

        public static abstract class RecognitionParamWithStreamBuilder<C extends RecognitionParamWithStream, B extends RecognitionParamWithStreamBuilder<C, B>>
        extends RecognitionParam.RecognitionParamBuilder<C, B> {
            private Flowable<ByteBuffer> audioStream;

            public B audioStream(@NonNull Flowable<ByteBuffer> audioStream) {
                if (audioStream == null) {
                    throw new NullPointerException("audioStream is marked non-null but is null");
                }
                this.audioStream = audioStream;
                return (B)this.self();
            }

            @Override
            protected abstract B self();

            @Override
            public abstract C build();

            @Override
            public String toString() {
                return "Recognition.RecognitionParamWithStream.RecognitionParamWithStreamBuilder(super=" + super.toString() + ", audioStream=" + this.audioStream + ")";
            }
        }
    }

    private static class AsyncCmdBuffer {
        private boolean isStop;
        private ByteBuffer audioFrame;

        private static boolean $default$isStop() {
            return false;
        }

        protected AsyncCmdBuffer(AsyncCmdBufferBuilder<?, ?> b) {
            this.isStop = ((AsyncCmdBufferBuilder)b).isStop$set ? ((AsyncCmdBufferBuilder)b).isStop$value : AsyncCmdBuffer.$default$isStop();
            this.audioFrame = ((AsyncCmdBufferBuilder)b).audioFrame;
        }

        public static AsyncCmdBufferBuilder<?, ?> builder() {
            return new AsyncCmdBufferBuilderImpl();
        }

        private static final class AsyncCmdBufferBuilderImpl
        extends AsyncCmdBufferBuilder<AsyncCmdBuffer, AsyncCmdBufferBuilderImpl> {
            private AsyncCmdBufferBuilderImpl() {
            }

            @Override
            protected AsyncCmdBufferBuilderImpl self() {
                return this;
            }

            @Override
            public AsyncCmdBuffer build() {
                return new AsyncCmdBuffer(this);
            }
        }

        public static abstract class AsyncCmdBufferBuilder<C extends AsyncCmdBuffer, B extends AsyncCmdBufferBuilder<C, B>> {
            private boolean isStop$set;
            private boolean isStop$value;
            private ByteBuffer audioFrame;

            public B isStop(boolean isStop) {
                this.isStop$value = isStop;
                this.isStop$set = true;
                return this.self();
            }

            public B audioFrame(ByteBuffer audioFrame) {
                this.audioFrame = audioFrame;
                return this.self();
            }

            protected abstract B self();

            public abstract C build();

            public String toString() {
                return "Recognition.AsyncCmdBuffer.AsyncCmdBufferBuilder(isStop$value=" + this.isStop$value + ", audioFrame=" + this.audioFrame + ")";
            }
        }
    }
}

