/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.utils;

import com.alibaba.dashscope.exception.NoApiKeyException;
import com.alibaba.dashscope.utils.Constants;
import java.io.BufferedReader;
import java.io.FileReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApiKey {
    private static final Logger log = LoggerFactory.getLogger(ApiKey.class);

    public static String getApiKey(String apiKey) throws NoApiKeyException {
        if (apiKey != null) {
            return apiKey;
        }
        if (Constants.apiKey != null) {
            return Constants.apiKey;
        }
        String value = System.getenv("DASHSCOPE_API_KEY");
        if (value != null) {
            return value;
        }
        String apiKeyFilePath = System.getenv("DASHSCOPE_API_KEY_FILE_PATH");
        if (apiKeyFilePath == null || Files.notExists(Paths.get(apiKeyFilePath, new String[0]), new LinkOption[0])) {
            Path homePath = Paths.get(System.getProperty("user.home"), new String[0]);
            Path defaultApiKeyPath = homePath.resolve(".dashscope").resolve("api_key");
            if (Files.notExists(defaultApiKeyPath, new LinkOption[0])) {
                apiKeyFilePath = null;
            } else {
                try {
                    BufferedReader reader = new BufferedReader(new FileReader(defaultApiKeyPath.toString()));
                    apiKey = reader.readLine().trim();
                    reader.close();
                    return apiKey;
                }
                catch (Exception e) {
                    throw new NoApiKeyException();
                }
            }
        }
        if (apiKeyFilePath != null) {
            try {
                BufferedReader reader = new BufferedReader(new FileReader(apiKeyFilePath));
                apiKey = reader.readLine().trim();
                reader.close();
                return apiKey;
            }
            catch (Exception e) {
                throw new NoApiKeyException();
            }
        }
        throw new NoApiKeyException();
    }
}

