/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.audio.tts;

import com.alibaba.dashscope.audio.tts.SpeechSynthesisUsage;
import com.alibaba.dashscope.audio.tts.timestamp.Sentence;
import com.alibaba.dashscope.common.DashScopeResult;
import com.alibaba.dashscope.utils.JsonUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpeechSynthesisResult {
    private static final Logger log = LoggerFactory.getLogger(SpeechSynthesisResult.class);
    @SerializedName(value="request_id")
    private String requestId;
    private JsonObject output;
    private SpeechSynthesisUsage usage;
    private Sentence timestamp;
    private ByteBuffer audioFrame;

    private static ByteBuffer cloneBuffer(ByteBuffer original) {
        ByteBuffer clone = ByteBuffer.allocate(original.capacity());
        original.rewind();
        clone.put(original);
        original.rewind();
        clone.flip();
        return clone;
    }

    public static SpeechSynthesisResult fromDashScopeResult(DashScopeResult dashScopeResult) {
        SpeechSynthesisResult result = new SpeechSynthesisResult();
        if (dashScopeResult.getOutput() instanceof ByteBuffer) {
            result.audioFrame = SpeechSynthesisResult.cloneBuffer((ByteBuffer)dashScopeResult.getOutput());
        }
        try {
            if (dashScopeResult.getRequestId() != null) {
                result.setRequestId(dashScopeResult.getRequestId());
            }
            if (dashScopeResult.getUsage() != null) {
                result.setUsage(JsonUtils.fromJsonObject((JsonElement)dashScopeResult.getUsage().getAsJsonObject(), SpeechSynthesisUsage.class));
            }
            if (dashScopeResult.getOutput() != null) {
                result.timestamp = Sentence.from(((JsonObject)dashScopeResult.getOutput()).getAsJsonObject("sentence"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public JsonObject getOutput() {
        return this.output;
    }

    public SpeechSynthesisUsage getUsage() {
        return this.usage;
    }

    public Sentence getTimestamp() {
        return this.timestamp;
    }

    public ByteBuffer getAudioFrame() {
        return this.audioFrame;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public void setOutput(JsonObject output) {
        this.output = output;
    }

    public void setUsage(SpeechSynthesisUsage usage) {
        this.usage = usage;
    }

    public void setTimestamp(Sentence timestamp) {
        this.timestamp = timestamp;
    }

    public void setAudioFrame(ByteBuffer audioFrame) {
        this.audioFrame = audioFrame;
    }

    public String toString() {
        return "SpeechSynthesisResult(requestId=" + this.getRequestId() + ", output=" + this.getOutput() + ", usage=" + this.getUsage() + ", timestamp=" + this.getTimestamp() + ", audioFrame=" + this.getAudioFrame() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpeechSynthesisResult)) {
            return false;
        }
        SpeechSynthesisResult other = (SpeechSynthesisResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
            return false;
        }
        JsonObject this$output = this.getOutput();
        JsonObject other$output = other.getOutput();
        if (this$output == null ? other$output != null : !this$output.equals(other$output)) {
            return false;
        }
        SpeechSynthesisUsage this$usage = this.getUsage();
        SpeechSynthesisUsage other$usage = other.getUsage();
        if (this$usage == null ? other$usage != null : !((Object)this$usage).equals(other$usage)) {
            return false;
        }
        Sentence this$timestamp = this.getTimestamp();
        Sentence other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        ByteBuffer this$audioFrame = this.getAudioFrame();
        ByteBuffer other$audioFrame = other.getAudioFrame();
        return !(this$audioFrame == null ? other$audioFrame != null : !((Object)this$audioFrame).equals(other$audioFrame));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SpeechSynthesisResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        JsonObject $output = this.getOutput();
        result = result * 59 + ($output == null ? 43 : $output.hashCode());
        SpeechSynthesisUsage $usage = this.getUsage();
        result = result * 59 + ($usage == null ? 43 : ((Object)$usage).hashCode());
        Sentence $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        ByteBuffer $audioFrame = this.getAudioFrame();
        result = result * 59 + ($audioFrame == null ? 43 : ((Object)$audioFrame).hashCode());
        return result;
    }
}

