/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.aigc.multimodalconversation;

import com.alibaba.dashscope.aigc.multimodalconversation.AudioParameters;
import com.alibaba.dashscope.aigc.multimodalconversation.OcrOptions;
import com.alibaba.dashscope.base.HalfDuplexServiceParam;
import com.alibaba.dashscope.common.ResponseFormat;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.alibaba.dashscope.tools.ToolBase;
import com.alibaba.dashscope.utils.JsonUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MultiModalConversationParam
extends HalfDuplexServiceParam {
    private List<Object> messages;
    @Deprecated
    private Integer maxLength;
    private Double topP;
    private Integer topK;
    private Float repetitionPenalty;
    private Float presencePenalty;
    private Boolean enableSearch;
    private Integer seed;
    private Float temperature;
    private Integer maxTokens;
    private Boolean incrementalOutput;
    private List<String> modalities;
    private AudioParameters audio;
    private OcrOptions ocrOptions;
    private String text;
    private AudioParameters.Voice voice;
    private List<ToolBase> tools;
    protected Object toolChoice;
    protected Boolean parallelToolCalls;
    protected Boolean vlHighResolutionImages;
    protected Boolean vlEnableImageHwOutput;
    private ResponseFormat responseFormat;
    private String negativePrompt;
    private Boolean promptExtend;
    private Boolean watermark;
    private String size;
    private Integer n;
    private String languageType;
    private Boolean enableThinking;
    private Integer thinkingBudget;

    @Override
    public JsonObject getHttpBody() {
        JsonObject requestObject = new JsonObject();
        requestObject.addProperty("model", this.getModel());
        requestObject.add("input", (JsonElement)this.getInput());
        Map<String, Object> params = this.getParameters();
        if (params != null && !params.isEmpty()) {
            requestObject.add("parameters", (JsonElement)JsonUtils.parametersToJsonObject(params));
        }
        return requestObject;
    }

    public JsonObject getInput() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("messages", (JsonElement)JsonUtils.toJsonArray(this.messages));
        if (this.text != null) {
            jsonObject.addProperty("text", this.text);
        }
        if (this.voice != null) {
            jsonObject.addProperty("voice", this.voice.getValue());
        }
        if (this.languageType != null) {
            jsonObject.addProperty("language_type", this.languageType);
        }
        return jsonObject;
    }

    @Override
    public Map<String, Object> getParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (this.maxLength != null) {
            params.put("max_length", this.maxLength);
        }
        if (this.maxTokens != null) {
            params.put("max_tokens", this.maxTokens);
        }
        if (this.topP != null) {
            params.put("top_p", this.topP);
        }
        if (this.topK != null) {
            params.put("top_k", this.topK);
        }
        params.put("enable_search", this.enableSearch);
        if (this.seed != null) {
            params.put("seed", this.seed);
        }
        if (this.temperature != null) {
            params.put("temperature", this.temperature);
        }
        if (this.repetitionPenalty != null) {
            params.put("repetition_penalty", this.repetitionPenalty);
        }
        if (this.presencePenalty != null) {
            params.put("presence_penalty", this.presencePenalty);
        }
        if (this.incrementalOutput.booleanValue()) {
            params.put("incremental_output", this.incrementalOutput);
        }
        if (this.modalities != null) {
            params.put("modalities", this.modalities);
        }
        if (this.audio != null) {
            params.put("audio", this.audio);
        }
        if (this.ocrOptions != null) {
            params.put("ocr_options", this.ocrOptions);
        }
        if (this.tools != null && !this.tools.isEmpty()) {
            params.put("tools", this.tools);
        }
        if (this.toolChoice != null) {
            if (this.toolChoice instanceof String) {
                params.put("tool_choice", (String)this.toolChoice);
            } else {
                params.put("tool_choice", JsonUtils.toJsonObject(this.toolChoice));
            }
        }
        if (this.parallelToolCalls != null) {
            params.put("parallel_tool_calls", this.parallelToolCalls);
        }
        if (this.vlHighResolutionImages != null) {
            params.put("vl_high_resolution_images", this.vlHighResolutionImages);
        }
        if (this.vlEnableImageHwOutput != null) {
            params.put("vl_enable_image_hw_output", this.vlEnableImageHwOutput);
        }
        if (this.responseFormat != null) {
            params.put("response_format", this.responseFormat);
        }
        if (this.negativePrompt != null) {
            params.put("negative_prompt", this.negativePrompt);
        }
        if (this.promptExtend != null) {
            params.put("prompt_extend", this.promptExtend);
        }
        if (this.watermark != null) {
            params.put("watermark", this.watermark);
        }
        if (this.size != null) {
            params.put("size", this.size);
        }
        if (this.n != null) {
            params.put("n", this.n);
        }
        if (this.enableThinking != null) {
            params.put("enable_thinking", this.enableThinking);
        }
        if (this.thinkingBudget != null) {
            params.put("thinking_budget", this.thinkingBudget);
        }
        params.putAll(this.parameters);
        return params;
    }

    @Override
    public ByteBuffer getBinaryData() {
        return null;
    }

    @Override
    public void validate() throws InputRequiredException {
        if (this.messages == null || this.messages.isEmpty() && (this.text == null || this.text.isEmpty())) {
            throw new InputRequiredException("Message or text must not null or empty!");
        }
    }

    private static Boolean $default$enableSearch() {
        return false;
    }

    private static Boolean $default$incrementalOutput() {
        return false;
    }

    protected MultiModalConversationParam(MultiModalConversationParamBuilder<?, ?> b) {
        super((HalfDuplexServiceParam.HalfDuplexServiceParamBuilder<?, ?>)b);
        List<Object> messages;
        switch (((MultiModalConversationParamBuilder)b).messages == null ? 0 : ((MultiModalConversationParamBuilder)b).messages.size()) {
            case 0: {
                messages = Collections.emptyList();
                break;
            }
            case 1: {
                messages = Collections.singletonList(((MultiModalConversationParamBuilder)b).messages.get(0));
                break;
            }
            default: {
                messages = Collections.unmodifiableList(new ArrayList(((MultiModalConversationParamBuilder)b).messages));
            }
        }
        this.messages = messages;
        this.maxLength = ((MultiModalConversationParamBuilder)b).maxLength;
        this.topP = ((MultiModalConversationParamBuilder)b).topP;
        this.topK = ((MultiModalConversationParamBuilder)b).topK;
        this.repetitionPenalty = ((MultiModalConversationParamBuilder)b).repetitionPenalty;
        this.presencePenalty = ((MultiModalConversationParamBuilder)b).presencePenalty;
        this.enableSearch = ((MultiModalConversationParamBuilder)b).enableSearch$set ? ((MultiModalConversationParamBuilder)b).enableSearch$value : MultiModalConversationParam.$default$enableSearch();
        this.seed = ((MultiModalConversationParamBuilder)b).seed;
        this.temperature = ((MultiModalConversationParamBuilder)b).temperature;
        this.maxTokens = ((MultiModalConversationParamBuilder)b).maxTokens;
        this.incrementalOutput = ((MultiModalConversationParamBuilder)b).incrementalOutput$set ? ((MultiModalConversationParamBuilder)b).incrementalOutput$value : MultiModalConversationParam.$default$incrementalOutput();
        this.modalities = ((MultiModalConversationParamBuilder)b).modalities;
        this.audio = ((MultiModalConversationParamBuilder)b).audio;
        this.ocrOptions = ((MultiModalConversationParamBuilder)b).ocrOptions;
        this.text = ((MultiModalConversationParamBuilder)b).text;
        this.voice = ((MultiModalConversationParamBuilder)b).voice;
        this.tools = ((MultiModalConversationParamBuilder)b).tools;
        this.toolChoice = ((MultiModalConversationParamBuilder)b).toolChoice;
        this.parallelToolCalls = ((MultiModalConversationParamBuilder)b).parallelToolCalls;
        this.vlHighResolutionImages = ((MultiModalConversationParamBuilder)b).vlHighResolutionImages;
        this.vlEnableImageHwOutput = ((MultiModalConversationParamBuilder)b).vlEnableImageHwOutput;
        this.responseFormat = ((MultiModalConversationParamBuilder)b).responseFormat;
        this.negativePrompt = ((MultiModalConversationParamBuilder)b).negativePrompt;
        this.promptExtend = ((MultiModalConversationParamBuilder)b).promptExtend;
        this.watermark = ((MultiModalConversationParamBuilder)b).watermark;
        this.size = ((MultiModalConversationParamBuilder)b).size;
        this.n = ((MultiModalConversationParamBuilder)b).n;
        this.languageType = ((MultiModalConversationParamBuilder)b).languageType;
        this.enableThinking = ((MultiModalConversationParamBuilder)b).enableThinking;
        this.thinkingBudget = ((MultiModalConversationParamBuilder)b).thinkingBudget;
    }

    public static MultiModalConversationParamBuilder<?, ?> builder() {
        return new MultiModalConversationParamBuilderImpl();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultiModalConversationParam)) {
            return false;
        }
        MultiModalConversationParam other = (MultiModalConversationParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$maxLength = this.getMaxLength();
        Integer other$maxLength = other.getMaxLength();
        if (this$maxLength == null ? other$maxLength != null : !((Object)this$maxLength).equals(other$maxLength)) {
            return false;
        }
        Double this$topP = this.getTopP();
        Double other$topP = other.getTopP();
        if (this$topP == null ? other$topP != null : !((Object)this$topP).equals(other$topP)) {
            return false;
        }
        Integer this$topK = this.getTopK();
        Integer other$topK = other.getTopK();
        if (this$topK == null ? other$topK != null : !((Object)this$topK).equals(other$topK)) {
            return false;
        }
        Float this$repetitionPenalty = this.getRepetitionPenalty();
        Float other$repetitionPenalty = other.getRepetitionPenalty();
        if (this$repetitionPenalty == null ? other$repetitionPenalty != null : !((Object)this$repetitionPenalty).equals(other$repetitionPenalty)) {
            return false;
        }
        Float this$presencePenalty = this.getPresencePenalty();
        Float other$presencePenalty = other.getPresencePenalty();
        if (this$presencePenalty == null ? other$presencePenalty != null : !((Object)this$presencePenalty).equals(other$presencePenalty)) {
            return false;
        }
        Boolean this$enableSearch = this.getEnableSearch();
        Boolean other$enableSearch = other.getEnableSearch();
        if (this$enableSearch == null ? other$enableSearch != null : !((Object)this$enableSearch).equals(other$enableSearch)) {
            return false;
        }
        Integer this$seed = this.getSeed();
        Integer other$seed = other.getSeed();
        if (this$seed == null ? other$seed != null : !((Object)this$seed).equals(other$seed)) {
            return false;
        }
        Float this$temperature = this.getTemperature();
        Float other$temperature = other.getTemperature();
        if (this$temperature == null ? other$temperature != null : !((Object)this$temperature).equals(other$temperature)) {
            return false;
        }
        Integer this$maxTokens = this.getMaxTokens();
        Integer other$maxTokens = other.getMaxTokens();
        if (this$maxTokens == null ? other$maxTokens != null : !((Object)this$maxTokens).equals(other$maxTokens)) {
            return false;
        }
        Boolean this$incrementalOutput = this.getIncrementalOutput();
        Boolean other$incrementalOutput = other.getIncrementalOutput();
        if (this$incrementalOutput == null ? other$incrementalOutput != null : !((Object)this$incrementalOutput).equals(other$incrementalOutput)) {
            return false;
        }
        Boolean this$parallelToolCalls = this.getParallelToolCalls();
        Boolean other$parallelToolCalls = other.getParallelToolCalls();
        if (this$parallelToolCalls == null ? other$parallelToolCalls != null : !((Object)this$parallelToolCalls).equals(other$parallelToolCalls)) {
            return false;
        }
        Boolean this$vlHighResolutionImages = this.getVlHighResolutionImages();
        Boolean other$vlHighResolutionImages = other.getVlHighResolutionImages();
        if (this$vlHighResolutionImages == null ? other$vlHighResolutionImages != null : !((Object)this$vlHighResolutionImages).equals(other$vlHighResolutionImages)) {
            return false;
        }
        Boolean this$vlEnableImageHwOutput = this.getVlEnableImageHwOutput();
        Boolean other$vlEnableImageHwOutput = other.getVlEnableImageHwOutput();
        if (this$vlEnableImageHwOutput == null ? other$vlEnableImageHwOutput != null : !((Object)this$vlEnableImageHwOutput).equals(other$vlEnableImageHwOutput)) {
            return false;
        }
        Boolean this$promptExtend = this.getPromptExtend();
        Boolean other$promptExtend = other.getPromptExtend();
        if (this$promptExtend == null ? other$promptExtend != null : !((Object)this$promptExtend).equals(other$promptExtend)) {
            return false;
        }
        Boolean this$watermark = this.getWatermark();
        Boolean other$watermark = other.getWatermark();
        if (this$watermark == null ? other$watermark != null : !((Object)this$watermark).equals(other$watermark)) {
            return false;
        }
        Integer this$n = this.getN();
        Integer other$n = other.getN();
        if (this$n == null ? other$n != null : !((Object)this$n).equals(other$n)) {
            return false;
        }
        Boolean this$enableThinking = this.getEnableThinking();
        Boolean other$enableThinking = other.getEnableThinking();
        if (this$enableThinking == null ? other$enableThinking != null : !((Object)this$enableThinking).equals(other$enableThinking)) {
            return false;
        }
        Integer this$thinkingBudget = this.getThinkingBudget();
        Integer other$thinkingBudget = other.getThinkingBudget();
        if (this$thinkingBudget == null ? other$thinkingBudget != null : !((Object)this$thinkingBudget).equals(other$thinkingBudget)) {
            return false;
        }
        List<Object> this$messages = this.getMessages();
        List<Object> other$messages = other.getMessages();
        if (this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages)) {
            return false;
        }
        List<String> this$modalities = this.getModalities();
        List<String> other$modalities = other.getModalities();
        if (this$modalities == null ? other$modalities != null : !((Object)this$modalities).equals(other$modalities)) {
            return false;
        }
        AudioParameters this$audio = this.getAudio();
        AudioParameters other$audio = other.getAudio();
        if (this$audio == null ? other$audio != null : !((Object)this$audio).equals(other$audio)) {
            return false;
        }
        OcrOptions this$ocrOptions = this.getOcrOptions();
        OcrOptions other$ocrOptions = other.getOcrOptions();
        if (this$ocrOptions == null ? other$ocrOptions != null : !((Object)this$ocrOptions).equals(other$ocrOptions)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        AudioParameters.Voice this$voice = this.getVoice();
        AudioParameters.Voice other$voice = other.getVoice();
        if (this$voice == null ? other$voice != null : !((Object)((Object)this$voice)).equals((Object)other$voice)) {
            return false;
        }
        List<ToolBase> this$tools = this.getTools();
        List<ToolBase> other$tools = other.getTools();
        if (this$tools == null ? other$tools != null : !((Object)this$tools).equals(other$tools)) {
            return false;
        }
        Object this$toolChoice = this.getToolChoice();
        Object other$toolChoice = other.getToolChoice();
        if (this$toolChoice == null ? other$toolChoice != null : !this$toolChoice.equals(other$toolChoice)) {
            return false;
        }
        ResponseFormat this$responseFormat = this.getResponseFormat();
        ResponseFormat other$responseFormat = other.getResponseFormat();
        if (this$responseFormat == null ? other$responseFormat != null : !((Object)this$responseFormat).equals(other$responseFormat)) {
            return false;
        }
        String this$negativePrompt = this.getNegativePrompt();
        String other$negativePrompt = other.getNegativePrompt();
        if (this$negativePrompt == null ? other$negativePrompt != null : !this$negativePrompt.equals(other$negativePrompt)) {
            return false;
        }
        String this$size = this.getSize();
        String other$size = other.getSize();
        if (this$size == null ? other$size != null : !this$size.equals(other$size)) {
            return false;
        }
        String this$languageType = this.getLanguageType();
        String other$languageType = other.getLanguageType();
        return !(this$languageType == null ? other$languageType != null : !this$languageType.equals(other$languageType));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MultiModalConversationParam;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $maxLength = this.getMaxLength();
        result = result * 59 + ($maxLength == null ? 43 : ((Object)$maxLength).hashCode());
        Double $topP = this.getTopP();
        result = result * 59 + ($topP == null ? 43 : ((Object)$topP).hashCode());
        Integer $topK = this.getTopK();
        result = result * 59 + ($topK == null ? 43 : ((Object)$topK).hashCode());
        Float $repetitionPenalty = this.getRepetitionPenalty();
        result = result * 59 + ($repetitionPenalty == null ? 43 : ((Object)$repetitionPenalty).hashCode());
        Float $presencePenalty = this.getPresencePenalty();
        result = result * 59 + ($presencePenalty == null ? 43 : ((Object)$presencePenalty).hashCode());
        Boolean $enableSearch = this.getEnableSearch();
        result = result * 59 + ($enableSearch == null ? 43 : ((Object)$enableSearch).hashCode());
        Integer $seed = this.getSeed();
        result = result * 59 + ($seed == null ? 43 : ((Object)$seed).hashCode());
        Float $temperature = this.getTemperature();
        result = result * 59 + ($temperature == null ? 43 : ((Object)$temperature).hashCode());
        Integer $maxTokens = this.getMaxTokens();
        result = result * 59 + ($maxTokens == null ? 43 : ((Object)$maxTokens).hashCode());
        Boolean $incrementalOutput = this.getIncrementalOutput();
        result = result * 59 + ($incrementalOutput == null ? 43 : ((Object)$incrementalOutput).hashCode());
        Boolean $parallelToolCalls = this.getParallelToolCalls();
        result = result * 59 + ($parallelToolCalls == null ? 43 : ((Object)$parallelToolCalls).hashCode());
        Boolean $vlHighResolutionImages = this.getVlHighResolutionImages();
        result = result * 59 + ($vlHighResolutionImages == null ? 43 : ((Object)$vlHighResolutionImages).hashCode());
        Boolean $vlEnableImageHwOutput = this.getVlEnableImageHwOutput();
        result = result * 59 + ($vlEnableImageHwOutput == null ? 43 : ((Object)$vlEnableImageHwOutput).hashCode());
        Boolean $promptExtend = this.getPromptExtend();
        result = result * 59 + ($promptExtend == null ? 43 : ((Object)$promptExtend).hashCode());
        Boolean $watermark = this.getWatermark();
        result = result * 59 + ($watermark == null ? 43 : ((Object)$watermark).hashCode());
        Integer $n = this.getN();
        result = result * 59 + ($n == null ? 43 : ((Object)$n).hashCode());
        Boolean $enableThinking = this.getEnableThinking();
        result = result * 59 + ($enableThinking == null ? 43 : ((Object)$enableThinking).hashCode());
        Integer $thinkingBudget = this.getThinkingBudget();
        result = result * 59 + ($thinkingBudget == null ? 43 : ((Object)$thinkingBudget).hashCode());
        List<Object> $messages = this.getMessages();
        result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
        List<String> $modalities = this.getModalities();
        result = result * 59 + ($modalities == null ? 43 : ((Object)$modalities).hashCode());
        AudioParameters $audio = this.getAudio();
        result = result * 59 + ($audio == null ? 43 : ((Object)$audio).hashCode());
        OcrOptions $ocrOptions = this.getOcrOptions();
        result = result * 59 + ($ocrOptions == null ? 43 : ((Object)$ocrOptions).hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        AudioParameters.Voice $voice = this.getVoice();
        result = result * 59 + ($voice == null ? 43 : ((Object)((Object)$voice)).hashCode());
        List<ToolBase> $tools = this.getTools();
        result = result * 59 + ($tools == null ? 43 : ((Object)$tools).hashCode());
        Object $toolChoice = this.getToolChoice();
        result = result * 59 + ($toolChoice == null ? 43 : $toolChoice.hashCode());
        ResponseFormat $responseFormat = this.getResponseFormat();
        result = result * 59 + ($responseFormat == null ? 43 : ((Object)$responseFormat).hashCode());
        String $negativePrompt = this.getNegativePrompt();
        result = result * 59 + ($negativePrompt == null ? 43 : $negativePrompt.hashCode());
        String $size = this.getSize();
        result = result * 59 + ($size == null ? 43 : $size.hashCode());
        String $languageType = this.getLanguageType();
        result = result * 59 + ($languageType == null ? 43 : $languageType.hashCode());
        return result;
    }

    public List<Object> getMessages() {
        return this.messages;
    }

    @Deprecated
    public Integer getMaxLength() {
        return this.maxLength;
    }

    public Double getTopP() {
        return this.topP;
    }

    public Integer getTopK() {
        return this.topK;
    }

    public Float getRepetitionPenalty() {
        return this.repetitionPenalty;
    }

    public Float getPresencePenalty() {
        return this.presencePenalty;
    }

    public Boolean getEnableSearch() {
        return this.enableSearch;
    }

    public Integer getSeed() {
        return this.seed;
    }

    public Float getTemperature() {
        return this.temperature;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public Boolean getIncrementalOutput() {
        return this.incrementalOutput;
    }

    public List<String> getModalities() {
        return this.modalities;
    }

    public AudioParameters getAudio() {
        return this.audio;
    }

    public OcrOptions getOcrOptions() {
        return this.ocrOptions;
    }

    public String getText() {
        return this.text;
    }

    public AudioParameters.Voice getVoice() {
        return this.voice;
    }

    public List<ToolBase> getTools() {
        return this.tools;
    }

    public Object getToolChoice() {
        return this.toolChoice;
    }

    public Boolean getParallelToolCalls() {
        return this.parallelToolCalls;
    }

    public Boolean getVlHighResolutionImages() {
        return this.vlHighResolutionImages;
    }

    public Boolean getVlEnableImageHwOutput() {
        return this.vlEnableImageHwOutput;
    }

    public ResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    public String getNegativePrompt() {
        return this.negativePrompt;
    }

    public Boolean getPromptExtend() {
        return this.promptExtend;
    }

    public Boolean getWatermark() {
        return this.watermark;
    }

    public String getSize() {
        return this.size;
    }

    public Integer getN() {
        return this.n;
    }

    public String getLanguageType() {
        return this.languageType;
    }

    public Boolean getEnableThinking() {
        return this.enableThinking;
    }

    public Integer getThinkingBudget() {
        return this.thinkingBudget;
    }

    public void setMessages(List<Object> messages) {
        this.messages = messages;
    }

    @Deprecated
    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public void setTopP(Double topP) {
        this.topP = topP;
    }

    public void setTopK(Integer topK) {
        this.topK = topK;
    }

    public void setRepetitionPenalty(Float repetitionPenalty) {
        this.repetitionPenalty = repetitionPenalty;
    }

    public void setPresencePenalty(Float presencePenalty) {
        this.presencePenalty = presencePenalty;
    }

    public void setEnableSearch(Boolean enableSearch) {
        this.enableSearch = enableSearch;
    }

    public void setSeed(Integer seed) {
        this.seed = seed;
    }

    public void setTemperature(Float temperature) {
        this.temperature = temperature;
    }

    public void setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    public void setIncrementalOutput(Boolean incrementalOutput) {
        this.incrementalOutput = incrementalOutput;
    }

    public void setModalities(List<String> modalities) {
        this.modalities = modalities;
    }

    public void setAudio(AudioParameters audio) {
        this.audio = audio;
    }

    public void setOcrOptions(OcrOptions ocrOptions) {
        this.ocrOptions = ocrOptions;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setVoice(AudioParameters.Voice voice) {
        this.voice = voice;
    }

    public void setTools(List<ToolBase> tools) {
        this.tools = tools;
    }

    public void setToolChoice(Object toolChoice) {
        this.toolChoice = toolChoice;
    }

    public void setParallelToolCalls(Boolean parallelToolCalls) {
        this.parallelToolCalls = parallelToolCalls;
    }

    public void setVlHighResolutionImages(Boolean vlHighResolutionImages) {
        this.vlHighResolutionImages = vlHighResolutionImages;
    }

    public void setVlEnableImageHwOutput(Boolean vlEnableImageHwOutput) {
        this.vlEnableImageHwOutput = vlEnableImageHwOutput;
    }

    public void setResponseFormat(ResponseFormat responseFormat) {
        this.responseFormat = responseFormat;
    }

    public void setNegativePrompt(String negativePrompt) {
        this.negativePrompt = negativePrompt;
    }

    public void setPromptExtend(Boolean promptExtend) {
        this.promptExtend = promptExtend;
    }

    public void setWatermark(Boolean watermark) {
        this.watermark = watermark;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public void setN(Integer n) {
        this.n = n;
    }

    public void setLanguageType(String languageType) {
        this.languageType = languageType;
    }

    public void setEnableThinking(Boolean enableThinking) {
        this.enableThinking = enableThinking;
    }

    public void setThinkingBudget(Integer thinkingBudget) {
        this.thinkingBudget = thinkingBudget;
    }

    @Override
    public String toString() {
        return "MultiModalConversationParam(messages=" + this.getMessages() + ", maxLength=" + this.getMaxLength() + ", topP=" + this.getTopP() + ", topK=" + this.getTopK() + ", repetitionPenalty=" + this.getRepetitionPenalty() + ", presencePenalty=" + this.getPresencePenalty() + ", enableSearch=" + this.getEnableSearch() + ", seed=" + this.getSeed() + ", temperature=" + this.getTemperature() + ", maxTokens=" + this.getMaxTokens() + ", incrementalOutput=" + this.getIncrementalOutput() + ", modalities=" + this.getModalities() + ", audio=" + this.getAudio() + ", ocrOptions=" + this.getOcrOptions() + ", text=" + this.getText() + ", voice=" + (Object)((Object)this.getVoice()) + ", tools=" + this.getTools() + ", toolChoice=" + this.getToolChoice() + ", parallelToolCalls=" + this.getParallelToolCalls() + ", vlHighResolutionImages=" + this.getVlHighResolutionImages() + ", vlEnableImageHwOutput=" + this.getVlEnableImageHwOutput() + ", responseFormat=" + this.getResponseFormat() + ", negativePrompt=" + this.getNegativePrompt() + ", promptExtend=" + this.getPromptExtend() + ", watermark=" + this.getWatermark() + ", size=" + this.getSize() + ", n=" + this.getN() + ", languageType=" + this.getLanguageType() + ", enableThinking=" + this.getEnableThinking() + ", thinkingBudget=" + this.getThinkingBudget() + ")";
    }

    private static final class MultiModalConversationParamBuilderImpl
    extends MultiModalConversationParamBuilder<MultiModalConversationParam, MultiModalConversationParamBuilderImpl> {
        private MultiModalConversationParamBuilderImpl() {
        }

        @Override
        protected MultiModalConversationParamBuilderImpl self() {
            return this;
        }

        @Override
        public MultiModalConversationParam build() {
            return new MultiModalConversationParam(this);
        }
    }

    public static abstract class MultiModalConversationParamBuilder<C extends MultiModalConversationParam, B extends MultiModalConversationParamBuilder<C, B>>
    extends HalfDuplexServiceParam.HalfDuplexServiceParamBuilder<C, B> {
        private ArrayList<Object> messages;
        private Integer maxLength;
        private Double topP;
        private Integer topK;
        private Float repetitionPenalty;
        private Float presencePenalty;
        private boolean enableSearch$set;
        private Boolean enableSearch$value;
        private Integer seed;
        private Float temperature;
        private Integer maxTokens;
        private boolean incrementalOutput$set;
        private Boolean incrementalOutput$value;
        private List<String> modalities;
        private AudioParameters audio;
        private OcrOptions ocrOptions;
        private String text;
        private AudioParameters.Voice voice;
        private List<ToolBase> tools;
        private Object toolChoice;
        private Boolean parallelToolCalls;
        private Boolean vlHighResolutionImages;
        private Boolean vlEnableImageHwOutput;
        private ResponseFormat responseFormat;
        private String negativePrompt;
        private Boolean promptExtend;
        private Boolean watermark;
        private String size;
        private Integer n;
        private String languageType;
        private Boolean enableThinking;
        private Integer thinkingBudget;

        public B message(Object message) {
            if (this.messages == null) {
                this.messages = new ArrayList();
            }
            this.messages.add(message);
            return (B)this.self();
        }

        public B messages(Collection<? extends Object> messages) {
            if (messages == null) {
                throw new NullPointerException("messages cannot be null");
            }
            if (this.messages == null) {
                this.messages = new ArrayList();
            }
            this.messages.addAll(messages);
            return (B)this.self();
        }

        public B clearMessages() {
            if (this.messages != null) {
                this.messages.clear();
            }
            return (B)this.self();
        }

        @Deprecated
        public B maxLength(Integer maxLength) {
            this.maxLength = maxLength;
            return (B)this.self();
        }

        public B topP(Double topP) {
            this.topP = topP;
            return (B)this.self();
        }

        public B topK(Integer topK) {
            this.topK = topK;
            return (B)this.self();
        }

        public B repetitionPenalty(Float repetitionPenalty) {
            this.repetitionPenalty = repetitionPenalty;
            return (B)this.self();
        }

        public B presencePenalty(Float presencePenalty) {
            this.presencePenalty = presencePenalty;
            return (B)this.self();
        }

        public B enableSearch(Boolean enableSearch) {
            this.enableSearch$value = enableSearch;
            this.enableSearch$set = true;
            return (B)this.self();
        }

        public B seed(Integer seed) {
            this.seed = seed;
            return (B)this.self();
        }

        public B temperature(Float temperature) {
            this.temperature = temperature;
            return (B)this.self();
        }

        public B maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return (B)this.self();
        }

        public B incrementalOutput(Boolean incrementalOutput) {
            this.incrementalOutput$value = incrementalOutput;
            this.incrementalOutput$set = true;
            return (B)this.self();
        }

        public B modalities(List<String> modalities) {
            this.modalities = modalities;
            return (B)this.self();
        }

        public B audio(AudioParameters audio) {
            this.audio = audio;
            return (B)this.self();
        }

        public B ocrOptions(OcrOptions ocrOptions) {
            this.ocrOptions = ocrOptions;
            return (B)this.self();
        }

        public B text(String text) {
            this.text = text;
            return (B)this.self();
        }

        public B voice(AudioParameters.Voice voice) {
            this.voice = voice;
            return (B)this.self();
        }

        public B tools(List<ToolBase> tools) {
            this.tools = tools;
            return (B)this.self();
        }

        public B toolChoice(Object toolChoice) {
            this.toolChoice = toolChoice;
            return (B)this.self();
        }

        public B parallelToolCalls(Boolean parallelToolCalls) {
            this.parallelToolCalls = parallelToolCalls;
            return (B)this.self();
        }

        public B vlHighResolutionImages(Boolean vlHighResolutionImages) {
            this.vlHighResolutionImages = vlHighResolutionImages;
            return (B)this.self();
        }

        public B vlEnableImageHwOutput(Boolean vlEnableImageHwOutput) {
            this.vlEnableImageHwOutput = vlEnableImageHwOutput;
            return (B)this.self();
        }

        public B responseFormat(ResponseFormat responseFormat) {
            this.responseFormat = responseFormat;
            return (B)this.self();
        }

        public B negativePrompt(String negativePrompt) {
            this.negativePrompt = negativePrompt;
            return (B)this.self();
        }

        public B promptExtend(Boolean promptExtend) {
            this.promptExtend = promptExtend;
            return (B)this.self();
        }

        public B watermark(Boolean watermark) {
            this.watermark = watermark;
            return (B)this.self();
        }

        public B size(String size) {
            this.size = size;
            return (B)this.self();
        }

        public B n(Integer n) {
            this.n = n;
            return (B)this.self();
        }

        public B languageType(String languageType) {
            this.languageType = languageType;
            return (B)this.self();
        }

        public B enableThinking(Boolean enableThinking) {
            this.enableThinking = enableThinking;
            return (B)this.self();
        }

        public B thinkingBudget(Integer thinkingBudget) {
            this.thinkingBudget = thinkingBudget;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "MultiModalConversationParam.MultiModalConversationParamBuilder(super=" + super.toString() + ", messages=" + this.messages + ", maxLength=" + this.maxLength + ", topP=" + this.topP + ", topK=" + this.topK + ", repetitionPenalty=" + this.repetitionPenalty + ", presencePenalty=" + this.presencePenalty + ", enableSearch$value=" + this.enableSearch$value + ", seed=" + this.seed + ", temperature=" + this.temperature + ", maxTokens=" + this.maxTokens + ", incrementalOutput$value=" + this.incrementalOutput$value + ", modalities=" + this.modalities + ", audio=" + this.audio + ", ocrOptions=" + this.ocrOptions + ", text=" + this.text + ", voice=" + (Object)((Object)this.voice) + ", tools=" + this.tools + ", toolChoice=" + this.toolChoice + ", parallelToolCalls=" + this.parallelToolCalls + ", vlHighResolutionImages=" + this.vlHighResolutionImages + ", vlEnableImageHwOutput=" + this.vlEnableImageHwOutput + ", responseFormat=" + this.responseFormat + ", negativePrompt=" + this.negativePrompt + ", promptExtend=" + this.promptExtend + ", watermark=" + this.watermark + ", size=" + this.size + ", n=" + this.n + ", languageType=" + this.languageType + ", enableThinking=" + this.enableThinking + ", thinkingBudget=" + this.thinkingBudget + ")";
        }
    }
}

