/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.sentinel;

import com.alibaba.csp.ahas.sentinel.SentinelProperties;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnProperty(name={"spring.cloud.ahas.sentinel.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={SentinelProperties.class})
public class SentinelAutoConfiguration {
    @Value(value="${project.name:${spring.application.name:}}")
    private String projectName;
    @Autowired
    private SentinelProperties properties;

    @PostConstruct
    private void init() {
        if (StringUtils.isEmpty((Object)System.getProperty("project.name")) && StringUtils.hasText((String)this.projectName)) {
            System.setProperty("project.name", this.projectName);
        }
        if (this.properties.getAhas() != null) {
            if (StringUtils.isEmpty((Object)System.getProperty("ahas.license")) && StringUtils.hasText((String)this.properties.getAhas().getLicense())) {
                System.setProperty("ahas.license", this.properties.getAhas().getLicense());
            }
            if (StringUtils.isEmpty((Object)System.getProperty("ahas.namespace")) && StringUtils.hasText((String)this.properties.getAhas().getNamespace())) {
                System.setProperty("ahas.namespace", this.properties.getAhas().getNamespace());
            }
        }
    }
}

