/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.datasource;

import com.alibaba.csp.sentinel.datasource.Converter;
import com.alibaba.csp.sentinel.datasource.WritableDataSource;
import com.alibaba.csp.sentinel.log.RecordLog;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.charset.Charset;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class FileWritableDataSource<T>
implements WritableDataSource<T> {
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private final Converter<T, String> configEncoder;
    private final File file;
    private final Charset charset;
    private final Lock lock = new ReentrantLock(true);

    public FileWritableDataSource(String filePath, Converter<T, String> configEncoder) {
        this(new File(filePath), configEncoder);
    }

    public FileWritableDataSource(File file, Converter<T, String> configEncoder) {
        this(file, configEncoder, DEFAULT_CHARSET);
    }

    public FileWritableDataSource(File file, Converter<T, String> configEncoder, Charset charset) {
        if (file == null || file.isDirectory()) {
            throw new IllegalArgumentException("Bad file");
        }
        if (configEncoder == null) {
            throw new IllegalArgumentException("Config encoder cannot be null");
        }
        if (charset == null) {
            throw new IllegalArgumentException("Charset cannot be null");
        }
        this.configEncoder = configEncoder;
        this.file = file;
        this.charset = charset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(T value) throws Exception {
        this.lock.lock();
        try {
            String convertResult = this.configEncoder.convert(value);
            FileOutputStream outputStream = null;
            try {
                outputStream = new FileOutputStream(this.file);
                byte[] bytesArray = convertResult.getBytes(this.charset);
                RecordLog.info((String)String.format("[FileWritableDataSource] Writing to file %s: %s", this.file.toString(), convertResult));
                outputStream.write(bytesArray);
                outputStream.flush();
            }
            finally {
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void close() throws Exception {
    }
}

