/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.vectorstore.analyticdb;

import com.alibaba.cloud.ai.vectorstore.analyticdb.AdVectorFilterExpressionConverter;
import com.alibaba.cloud.ai.vectorstore.analyticdb.AnalyticDbConfig;
import com.aliyun.gpdb20160503.Client;
import com.aliyun.gpdb20160503.models.CreateCollectionRequest;
import com.aliyun.gpdb20160503.models.CreateNamespaceRequest;
import com.aliyun.gpdb20160503.models.DeleteCollectionDataRequest;
import com.aliyun.gpdb20160503.models.DeleteCollectionDataResponse;
import com.aliyun.gpdb20160503.models.DescribeCollectionRequest;
import com.aliyun.gpdb20160503.models.DescribeNamespaceRequest;
import com.aliyun.gpdb20160503.models.InitVectorDatabaseRequest;
import com.aliyun.gpdb20160503.models.InitVectorDatabaseResponse;
import com.aliyun.gpdb20160503.models.QueryCollectionDataRequest;
import com.aliyun.gpdb20160503.models.QueryCollectionDataResponse;
import com.aliyun.gpdb20160503.models.QueryCollectionDataResponseBody;
import com.aliyun.gpdb20160503.models.UpsertCollectionDataRequest;
import com.aliyun.tea.TeaException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.document.Document;
import org.springframework.ai.embedding.EmbeddingModel;
import org.springframework.ai.embedding.EmbeddingOptionsBuilder;
import org.springframework.ai.util.JacksonUtils;
import org.springframework.ai.vectorstore.AbstractVectorStoreBuilder;
import org.springframework.ai.vectorstore.SearchRequest;
import org.springframework.ai.vectorstore.filter.Filter;
import org.springframework.ai.vectorstore.filter.FilterExpressionConverter;
import org.springframework.ai.vectorstore.observation.AbstractObservationVectorStore;
import org.springframework.ai.vectorstore.observation.VectorStoreObservationContext;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class AnalyticDbVectorStore
extends AbstractObservationVectorStore
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(AnalyticDbVectorStore.class);
    private static final String DATA_BASE_SYSTEM = "analytic_db";
    private static final String REF_DOC_NAME = "refDocId";
    private static final String METADATA_FIELD_NAME = "metadata";
    private static final String CONTENT_FIELD_NAME = "content";
    private static final String DOC_NAME = "docId";
    private static final int DEFAULT_TOP_K = 4;
    private static final Double DEFAULT_SIMILARITY_THRESHOLD = 0.0;
    public final FilterExpressionConverter filterExpressionConverter = new AdVectorFilterExpressionConverter();
    private final String collectionName;
    private final AnalyticDbConfig config;
    private final Client client;
    private final ObjectMapper objectMapper;
    private final Integer defaultTopK;
    private final Double defaultSimilarityThreshold;

    protected AnalyticDbVectorStore(Builder builder) throws Exception {
        super((AbstractVectorStoreBuilder)builder);
        this.collectionName = builder.collectionName;
        this.config = builder.config;
        this.client = builder.client;
        this.objectMapper = ((JsonMapper.Builder)JsonMapper.builder().addModules((Iterable)JacksonUtils.instantiateAvailableModules())).build();
        this.defaultSimilarityThreshold = builder.defaultSimilarityThreshold;
        this.defaultTopK = builder.defaultTopK;
    }

    public static Builder builder(String collectionName, AnalyticDbConfig config, Client client, EmbeddingModel embeddingModel) {
        return new Builder(collectionName, config, client, embeddingModel);
    }

    private void initialize() throws Exception {
        this.initializeVectorDataBase();
        this.createNameSpaceIfNotExists();
        this.createCollectionIfNotExists(Long.valueOf(this.embeddingModel.dimensions()));
    }

    private void initializeVectorDataBase() throws Exception {
        InitVectorDatabaseRequest request = new InitVectorDatabaseRequest().setDBInstanceId(this.config.getDbInstanceId()).setRegionId(this.config.getRegionId()).setManagerAccount(this.config.getManagerAccount()).setManagerAccountPassword(this.config.getManagerAccountPassword());
        InitVectorDatabaseResponse initVectorDatabaseResponse = this.client.initVectorDatabase(request);
        logger.debug("successfully initialize vector database, response body:{}", (Object)initVectorDatabaseResponse.getBody());
    }

    private void createNameSpaceIfNotExists() throws Exception {
        try {
            DescribeNamespaceRequest request = new DescribeNamespaceRequest().setDBInstanceId(this.config.getDbInstanceId()).setRegionId(this.config.getRegionId()).setNamespace(this.config.getNamespace()).setManagerAccount(this.config.getManagerAccount()).setManagerAccountPassword(this.config.getManagerAccountPassword());
            this.client.describeNamespace(request);
        }
        catch (TeaException e) {
            if (Objects.equals(e.getStatusCode(), 404)) {
                CreateNamespaceRequest request = new CreateNamespaceRequest().setDBInstanceId(this.config.getDbInstanceId()).setRegionId(this.config.getRegionId()).setNamespace(this.config.getNamespace()).setManagerAccount(this.config.getManagerAccount()).setManagerAccountPassword(this.config.getManagerAccountPassword()).setNamespacePassword(this.config.getNamespacePassword());
                this.client.createNamespace(request);
            }
            throw new Exception("failed to create namespace:{}", e);
        }
    }

    private void createCollectionIfNotExists(Long embeddingDimension) throws Exception {
        try {
            DescribeCollectionRequest describeRequest = new DescribeCollectionRequest().setDBInstanceId(this.config.getDbInstanceId()).setRegionId(this.config.getRegionId()).setNamespace(this.config.getNamespace()).setNamespacePassword(this.config.getNamespacePassword()).setCollection(this.collectionName);
            this.client.describeCollection(describeRequest);
            logger.debug("collection{}already exists", (Object)this.collectionName);
        }
        catch (TeaException e) {
            if (Objects.equals(e.getStatusCode(), 404)) {
                ObjectNode metadataNode = this.objectMapper.createObjectNode();
                metadataNode.put(REF_DOC_NAME, "text");
                metadataNode.put(CONTENT_FIELD_NAME, "text");
                metadataNode.put(METADATA_FIELD_NAME, "jsonb");
                String metadata = this.objectMapper.writeValueAsString((Object)metadataNode);
                CreateCollectionRequest createRequest = new CreateCollectionRequest().setDBInstanceId(this.config.getDbInstanceId()).setRegionId(this.config.getRegionId()).setManagerAccount(this.config.getManagerAccount()).setManagerAccountPassword(this.config.getManagerAccountPassword()).setNamespace(this.config.getNamespace()).setCollection(this.collectionName).setDimension(embeddingDimension).setMetrics(this.config.getMetrics()).setMetadata(metadata).setFullTextRetrievalFields(CONTENT_FIELD_NAME);
                this.client.createCollection(createRequest);
                logger.debug("collection{}created", (Object)this.collectionName);
            }
            throw new RuntimeException("Failed to create collection " + this.collectionName + ": " + e.getMessage());
        }
    }

    public void doAdd(List<Document> documents) {
        Assert.notNull(documents, (String)"The document list should not be null.");
        if (CollectionUtils.isEmpty(documents)) {
            return;
        }
        List embeddings = this.embeddingModel.embed(documents, EmbeddingOptionsBuilder.builder().build(), this.batchingStrategy);
        ArrayList<UpsertCollectionDataRequest.UpsertCollectionDataRequestRows> rows = new ArrayList<UpsertCollectionDataRequest.UpsertCollectionDataRequestRows>(10);
        for (int i = 0; i < documents.size(); ++i) {
            Document doc = documents.get(i);
            logger.info("Processing document id = {}", (Object)doc.getId());
            HashMap<String, String> metadata = new HashMap<String, String>();
            Map docMetadata = doc.getMetadata();
            String docName = (String)docMetadata.get(DOC_NAME);
            String refDocId = docName != null && !docName.isEmpty() ? docName : doc.getId();
            metadata.put(REF_DOC_NAME, refDocId);
            metadata.put(CONTENT_FIELD_NAME, doc.getText());
            try {
                metadata.put(METADATA_FIELD_NAME, this.objectMapper.writeValueAsString((Object)doc.getMetadata()));
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException("Failed to serialize metadata for document id = " + doc.getId(), e);
            }
            float[] floatEmbeddings = (float[])embeddings.get(i);
            List<Double> embedding = IntStream.range(0, floatEmbeddings.length).mapToObj(j -> floatEmbeddings[j]).toList();
            rows.add(new UpsertCollectionDataRequest.UpsertCollectionDataRequestRows().setVector(embedding).setMetadata(metadata));
        }
        UpsertCollectionDataRequest request = new UpsertCollectionDataRequest().setDBInstanceId(this.config.getDbInstanceId()).setRegionId(this.config.getRegionId()).setNamespace(this.config.getNamespace()).setNamespacePassword(this.config.getNamespacePassword()).setCollection(this.collectionName).setRows(rows);
        try {
            this.client.upsertCollectionData(request);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to add collection data by IDs: " + e.getMessage(), e);
        }
    }

    public void doDelete(List<String> ids) {
        if (ids.isEmpty()) {
            return;
        }
        String idsStr = ids.stream().map(id -> "'" + id + "'").collect(Collectors.joining(", ", "(", ")"));
        DeleteCollectionDataRequest request = new DeleteCollectionDataRequest().setDBInstanceId(this.config.getDbInstanceId()).setRegionId(this.config.getRegionId()).setNamespace(this.config.getNamespace()).setNamespacePassword(this.config.getNamespacePassword()).setCollection(this.collectionName).setCollectionData(null).setCollectionDataFilter("refDocId IN " + idsStr);
        try {
            DeleteCollectionDataResponse deleteCollectionDataResponse = this.client.deleteCollectionData(request);
            logger.debug("delete collection data response:{}", (Object)deleteCollectionDataResponse.getBody());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to delete collection data by IDs: " + e.getMessage(), e);
        }
    }

    public void doDelete(Filter.Expression filterExpression) {
        String nativeFilterExpression = this.filterExpressionConverter.convertExpression(filterExpression);
        DeleteCollectionDataRequest request = new DeleteCollectionDataRequest().setDBInstanceId(this.config.getDbInstanceId()).setRegionId(this.config.getRegionId()).setNamespace(this.config.getNamespace()).setNamespacePassword(this.config.getNamespacePassword()).setCollection(this.collectionName).setCollectionData(null).setCollectionDataFilter(nativeFilterExpression);
        try {
            DeleteCollectionDataResponse deleteCollectionDataResponse = this.client.deleteCollectionData(request);
            logger.debug("delete collection data response:{}", (Object)deleteCollectionDataResponse.getBody());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to delete collection data by filterExpression: " + e.getMessage(), e);
        }
    }

    public List<Document> similaritySearch(String query) {
        return this.similaritySearch(SearchRequest.builder().query(query).topK(this.defaultTopK.intValue()).similarityThreshold(this.defaultSimilarityThreshold.doubleValue()).build());
    }

    public List<Document> doSimilaritySearch(SearchRequest searchRequest) {
        double scoreThreshold = searchRequest.getSimilarityThreshold();
        boolean includeValues = searchRequest.hasFilterExpression();
        int topK = searchRequest.getTopK();
        String filterExpress = null;
        if (includeValues) {
            filterExpress = searchRequest.getFilterExpression() != null ? this.filterExpressionConverter.convertExpression(searchRequest.getFilterExpression()) : "";
        }
        QueryCollectionDataRequest request = new QueryCollectionDataRequest().setDBInstanceId(this.config.getDbInstanceId()).setRegionId(this.config.getRegionId()).setNamespace(this.config.getNamespace()).setNamespacePassword(this.config.getNamespacePassword()).setCollection(this.collectionName).setIncludeValues(Boolean.valueOf(includeValues)).setMetrics(this.config.getMetrics()).setVector(null).setContent(searchRequest.getQuery()).setTopK(Long.valueOf(topK)).setFilter(filterExpress);
        try {
            QueryCollectionDataResponse response = this.client.queryCollectionData(request);
            ArrayList<Document> documents = new ArrayList<Document>();
            for (QueryCollectionDataResponseBody.QueryCollectionDataResponseBodyMatchesMatch match : response.getBody().getMatches().getMatch()) {
                if (match.getScore() == null || !(match.getScore() > scoreThreshold)) continue;
                Map metadata = match.getMetadata();
                String pageContent = (String)metadata.get(CONTENT_FIELD_NAME);
                Map metadataJson = (Map)this.objectMapper.readValue((String)metadata.get(METADATA_FIELD_NAME), (TypeReference)new TypeReference<HashMap<String, Object>>(){});
                Document doc = new Document(pageContent, metadataJson);
                documents.add(doc);
            }
            return documents;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to search by full text: " + e.getMessage(), e);
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.initialize();
        logger.debug("created AnalyticdbVector client success");
    }

    public VectorStoreObservationContext.Builder createObservationContextBuilder(String operationName) {
        return VectorStoreObservationContext.builder((String)DATA_BASE_SYSTEM, (String)operationName).collectionName(this.collectionName).dimensions(Integer.valueOf(this.embeddingModel.dimensions())).namespace(this.config.getNamespace()).similarityMetric(this.config.getMetrics());
    }

    public static class Builder
    extends AbstractVectorStoreBuilder<Builder> {
        private final String collectionName;
        private final AnalyticDbConfig config;
        private final Client client;
        private int defaultTopK = 4;
        private Double defaultSimilarityThreshold = DEFAULT_SIMILARITY_THRESHOLD;

        private Builder(String collectionName, AnalyticDbConfig config, Client client, EmbeddingModel embeddingModel) {
            super(embeddingModel);
            Assert.notNull((Object)client, (String)"Client must not be null");
            this.client = client;
            Assert.notNull((Object)collectionName, (String)"Collection name must not be null");
            this.collectionName = collectionName.toLowerCase();
            this.config = config;
        }

        public Builder defaultTopK(int defaultTopK) {
            Assert.isTrue((defaultTopK >= 0 ? 1 : 0) != 0, (String)"The topK should be positive value.");
            this.defaultTopK = defaultTopK;
            return this;
        }

        public Builder defaultSimilarityThreshold(Double defaultSimilarityThreshold) {
            Assert.isTrue((defaultSimilarityThreshold >= 0.0 && defaultSimilarityThreshold <= 1.0 ? 1 : 0) != 0, (String)"The similarity threshold must be in range [0.0:1.00].");
            this.defaultSimilarityThreshold = defaultSimilarityThreshold;
            return this;
        }

        public AnalyticDbVectorStore build() {
            try {
                return new AnalyticDbVectorStore(this);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

