/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.memory.redis.serializer;

import com.alibaba.cloud.ai.memory.redis.serializer.MessageFactory;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.messages.SystemMessage;
import org.springframework.ai.chat.messages.ToolResponseMessage;
import org.springframework.ai.chat.messages.UserMessage;
import org.springframework.util.CollectionUtils;

public class MessageDeserializer
extends JsonDeserializer<Message> {
    private static final Logger logger = LoggerFactory.getLogger(MessageDeserializer.class);
    private static final Map<String, MessageFactory> MESSAGE_FACTORIES = new ConcurrentHashMap<String, MessageFactory>();
    private static final ObjectMapper OBJECT_MAPPER = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().configure(MapperFeature.AUTO_DETECT_GETTERS, false)).configure(MapperFeature.AUTO_DETECT_IS_GETTERS, false)).visibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY)).build();

    public Message deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        logger.debug("Deserializing message: {}", (Object)node);
        if (node.isTextual()) {
            return new UserMessage(node.asText());
        }
        String type = this.extractMessageType(node);
        String content = this.extractContent(node);
        Map<String, Object> metadata = this.extractMetadata(node);
        List<AssistantMessage.ToolCall> toolCalls = this.extractToolCalls(node);
        List<ToolResponseMessage.ToolResponse> toolResponses = this.extractToolResponses(node);
        return Optional.ofNullable(type).map(String::toUpperCase).map(MESSAGE_FACTORIES::get).orElseGet(() -> {
            if (type == null) {
                logger.warn("Message type not found, defaulting to USER");
            } else {
                logger.warn("Unknown message type: {}, defaulting to USER", (Object)type);
            }
            return MESSAGE_FACTORIES.get("USER");
        }).create(content, metadata, toolCalls, toolResponses);
    }

    private String extractMessageType(JsonNode node) {
        return Optional.ofNullable(node.get("messageType")).map(JsonNode::asText).orElseGet(() -> Optional.ofNullable(node.get("type")).map(JsonNode::asText).orElseGet(() -> Optional.ofNullable(node.get("role")).map(n -> n.asText().toUpperCase()).orElse(null)));
    }

    private String extractContent(JsonNode node) {
        return Optional.ofNullable(node.get("content")).map(JsonNode::asText).orElseGet(() -> Optional.ofNullable(node.get("textContent")).map(JsonNode::asText).orElseGet(() -> ((JsonNode)node).toString()));
    }

    private Map<String, Object> extractMetadata(JsonNode node) {
        return Optional.ofNullable(node.get("metadata")).map(metadataNode -> {
            try {
                return (Map)OBJECT_MAPPER.convertValue(metadataNode, (TypeReference)new TypeReference<Map<String, Object>>(){});
            }
            catch (IllegalArgumentException e) {
                logger.warn("Failed to deserialize metadata: {}", (Object)e.getMessage());
                return Collections.emptyMap();
            }
        }).orElseGet(Collections::emptyMap);
    }

    private List<AssistantMessage.ToolCall> extractToolCalls(JsonNode node) {
        return Optional.ofNullable(node.get("toolCalls")).filter(JsonNode::isArray).map(toolCallNode -> {
            try {
                return (List)OBJECT_MAPPER.convertValue(toolCallNode, (TypeReference)new TypeReference<List<AssistantMessage.ToolCall>>(){});
            }
            catch (IllegalArgumentException e) {
                logger.warn("Failed to deserialize toolCalls: {}", (Object)e.getMessage());
                return Collections.emptyList();
            }
        }).orElseGet(Collections::emptyList);
    }

    private List<ToolResponseMessage.ToolResponse> extractToolResponses(JsonNode node) {
        return Optional.ofNullable(node.get("responses")).filter(JsonNode::isArray).map(toolResponsesNode -> {
            try {
                return (List)OBJECT_MAPPER.convertValue(toolResponsesNode, (TypeReference)new TypeReference<List<ToolResponseMessage.ToolResponse>>(){});
            }
            catch (IllegalArgumentException e) {
                logger.warn("Failed to deserialize toolResponses: {}", (Object)e.getMessage());
                return Collections.emptyList();
            }
        }).orElseGet(Collections::emptyList);
    }

    static {
        MESSAGE_FACTORIES.put("USER", (textContent, metadata, toolCalls, toolResponses) -> UserMessage.builder().text(textContent).metadata(CollectionUtils.isEmpty((Map)metadata) ? Map.of() : metadata).build());
        MESSAGE_FACTORIES.put("ASSISTANT", (textContent, metadata, toolCalls, toolResponses) -> AssistantMessage.builder().content(textContent).properties(CollectionUtils.isEmpty((Map)metadata) ? Map.of() : metadata).toolCalls(CollectionUtils.isEmpty((Collection)toolCalls) ? List.of() : toolCalls).build());
        MESSAGE_FACTORIES.put("SYSTEM", (textContent, metadata, toolCalls, toolResponses) -> SystemMessage.builder().text(textContent).metadata(CollectionUtils.isEmpty((Map)metadata) ? Map.of() : metadata).build());
        MESSAGE_FACTORIES.put("TOOL", (textContent, metadata, toolCalls, toolResponses) -> ToolResponseMessage.builder().responses(toolResponses).metadata(CollectionUtils.isEmpty((Map)metadata) ? Map.of() : metadata).build());
    }
}

