/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.memory.redis;

import com.alibaba.cloud.ai.memory.redis.BaseRedisChatMemoryRepository;
import com.alibaba.cloud.ai.memory.redis.builder.RedisChatMemoryBuilder;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.redisson.Redisson;
import org.redisson.api.RKeys;
import org.redisson.api.RList;
import org.redisson.api.RedissonClient;
import org.redisson.api.options.KeysScanOptions;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.messages.Message;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslManagerBundle;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RedissonRedisChatMemoryRepository
extends BaseRedisChatMemoryRepository {
    private static final Logger logger = LoggerFactory.getLogger(RedissonRedisChatMemoryRepository.class);
    private final RedissonClient redissonClient;

    private RedissonRedisChatMemoryRepository(RedissonClient redissonClient) {
        Assert.notNull((Object)redissonClient, (String)"redissonClient cannot be null");
        this.redissonClient = redissonClient;
    }

    public static RedissonBuilder builder() {
        return new RedissonBuilder();
    }

    public List<String> findConversationIds() {
        RKeys keys = this.redissonClient.getKeys();
        KeysScanOptions scanOptions = KeysScanOptions.defaults().pattern("spring_ai_alibaba_chat_memory:*");
        Iterable keysIter = keys.getKeys(scanOptions);
        return StreamSupport.stream(keysIter.spliterator(), false).map(key -> key.substring("spring_ai_alibaba_chat_memory:".length())).collect(Collectors.toList());
    }

    public List<Message> findByConversationId(String conversationId) {
        Assert.hasText((String)conversationId, (String)"conversationId cannot be null or empty");
        RList redisList = this.redissonClient.getList("spring_ai_alibaba_chat_memory:" + conversationId);
        return redisList.readAll().parallelStream().map(this::deserializeMessage).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public void saveAll(String conversationId, List<Message> messages) {
        Assert.hasText((String)conversationId, (String)"conversationId cannot be null or empty");
        Assert.notNull(messages, (String)"messages cannot be null");
        Assert.noNullElements(messages, (String)"messages cannot contain null elements");
        RList redisList = this.redissonClient.getList("spring_ai_alibaba_chat_memory:" + conversationId);
        redisList.delete();
        List<String> serializedMessages = messages.stream().map(this::serializeMessage).toList();
        redisList.addAll(serializedMessages);
    }

    public void deleteByConversationId(String conversationId) {
        Assert.hasText((String)conversationId, (String)"conversationId cannot be null or empty");
        RList redisList = this.redissonClient.getList("spring_ai_alibaba_chat_memory:" + conversationId);
        redisList.delete();
    }

    public void clearOverLimit(String conversationId, int maxLimit, int deleteSize) {
        Assert.hasText((String)conversationId, (String)"conversationId cannot be null or empty");
        String key = "spring_ai_alibaba_chat_memory:" + conversationId;
        RList list = this.redissonClient.getList(key);
        int size = list.size();
        if (size < maxLimit) {
            return;
        }
        list.trim(deleteSize, -1);
    }

    @Override
    public void close() {
        if (this.redissonClient != null && !this.redissonClient.isShutdown()) {
            try {
                int activeConnections = this.redissonClient.getConfig().getNettyThreads();
                logger.info("Shutting down Redisson with {} active connections", (Object)activeConnections);
                this.redissonClient.shutdown();
                logger.info("Redisson client shutdown completed");
            }
            catch (Exception e) {
                logger.error("Error shutting down Redisson client", (Throwable)e);
            }
        }
    }

    public static class RedissonBuilder
    extends RedisChatMemoryBuilder<RedissonBuilder> {
        private int poolSize = 32;
        private Config redissonConfig;

        @Override
        protected RedissonBuilder self() {
            return this;
        }

        public RedissonBuilder poolSize(int poolSize) {
            this.poolSize = poolSize;
            return this;
        }

        public RedissonBuilder redissonConfig(Config redissonConfig) {
            this.redissonConfig = redissonConfig;
            return this;
        }

        public RedissonRedisChatMemoryRepository build() {
            if (this.redissonConfig != null) {
                if (this.redissonConfig.getCodec() == null) {
                    this.redissonConfig.setCodec((Codec)new StringCodec());
                }
                return new RedissonRedisChatMemoryRepository(Redisson.create((Config)this.redissonConfig));
            }
            Config config = new Config();
            config.setCodec((Codec)new StringCodec());
            if (this.useCluster) {
                List<String> nodesUrl = this.nodes.stream().map(node -> "redis://" + node).toList();
                if (this.useSsl && StringUtils.hasText((String)this.bundle)) {
                    if (this.sslBundles == null) {
                        throw new IllegalStateException("spring.ssl configuration is required when use SSL in redis chat memory");
                    }
                    SslBundle sslBundle = this.sslBundles.getBundle(this.bundle);
                    SslManagerBundle managers = sslBundle.getManagers();
                    config.useClusterServers().setSslTrustManagerFactory(managers.getTrustManagerFactory());
                    nodesUrl = this.nodes.stream().map(node -> "rediss://" + node).toList();
                }
                ((ClusterServersConfig)((ClusterServersConfig)config.useClusterServers().addNodeAddress(nodesUrl.toArray(new String[0])).setConnectTimeout(this.timeout)).setSlaveConnectionPoolSize(this.poolSize)).setMasterConnectionPoolSize(this.poolSize);
                if (StringUtils.hasLength((String)this.username)) {
                    config.useClusterServers().setUsername(this.username);
                }
                if (StringUtils.hasLength((String)this.password)) {
                    config.useClusterServers().setPassword(this.password);
                }
            } else {
                String nodeUrl = "redis://" + this.host + ":" + this.port;
                if (this.useSsl && StringUtils.hasText((String)this.bundle)) {
                    if (this.sslBundles == null) {
                        throw new IllegalStateException("spring.ssl configuration is required when use SSL in redis chat memory");
                    }
                    SslBundle sslBundle = this.sslBundles.getBundle(this.bundle);
                    SslManagerBundle managers = sslBundle.getManagers();
                    config.useSingleServer().setSslTrustManagerFactory(managers.getTrustManagerFactory());
                    nodeUrl = "rediss://" + this.host + ":" + this.port;
                }
                config.useSingleServer().setAddress(nodeUrl).setConnectionPoolSize(this.poolSize).setConnectTimeout(this.timeout);
                if (StringUtils.hasLength((String)this.username)) {
                    config.useSingleServer().setUsername(this.username);
                }
                if (StringUtils.hasLength((String)this.password)) {
                    config.useSingleServer().setPassword(this.password);
                }
            }
            return new RedissonRedisChatMemoryRepository(Redisson.create((Config)config));
        }
    }
}

