/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.memory.jdbc;

import com.alibaba.cloud.ai.memory.jdbc.JdbcChatMemoryRepository;
import org.springframework.jdbc.core.JdbcTemplate;

public class SqlServerChatMemoryRepository
extends JdbcChatMemoryRepository {
    private SqlServerChatMemoryRepository(JdbcTemplate jdbcTemplate) {
        super(jdbcTemplate);
    }

    public static SqlServerBuilder sqlServerBuilder() {
        return new SqlServerBuilder();
    }

    @Override
    protected String hasTableSql(String tableName) {
        return String.format("SELECT name FROM sys.tables WHERE name LIKE '%s';", tableName);
    }

    @Override
    protected String createTableSql(String tableName) {
        return String.format("CREATE TABLE %s ( conversation_id NVARCHAR(256) NOT NULL,    content NVARCHAR(MAX) NOT NULL, type VARCHAR(100) NOT NULL, timestamp DATETIME2 NOT NULL,    CHECK (type IN ('USER', 'ASSISTANT', 'SYSTEM', 'TOOL')));", tableName);
    }

    public static class SqlServerBuilder {
        private JdbcTemplate jdbcTemplate;

        public SqlServerBuilder jdbcTemplate(JdbcTemplate jdbcTemplate) {
            this.jdbcTemplate = jdbcTemplate;
            return this;
        }

        public SqlServerChatMemoryRepository build() {
            return new SqlServerChatMemoryRepository(this.jdbcTemplate);
        }
    }
}

