/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.mcp.register;

import com.alibaba.nacos.api.utils.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.env.Environment;

@ConfigurationProperties(prefix="spring.ai.alibaba.mcp.nacos.register")
public class NacosMcpRegisterProperties {
    private static final Logger log = LoggerFactory.getLogger(NacosMcpRegisterProperties.class);
    public static final String CONFIG_PREFIX = "spring.ai.alibaba.mcp.nacos.register";
    String host;
    int port = -1;
    String serviceGroup;
    String serviceName;
    String sseExportContextPath;
    boolean serviceRegister = true;
    boolean serviceEphemeral = true;
    @Autowired
    @JsonIgnore
    private Environment environment;

    public boolean isServiceRegister() {
        return this.serviceRegister;
    }

    public void setServiceRegister(boolean serviceRegister) {
        this.serviceRegister = serviceRegister;
    }

    public boolean isServiceEphemeral() {
        return this.serviceEphemeral;
    }

    public void setServiceEphemeral(boolean serviceEphemeral) {
        this.serviceEphemeral = serviceEphemeral;
    }

    public String getSseExportContextPath() {
        return this.sseExportContextPath;
    }

    public void setSseExportContextPath(String sseExportContextPath) {
        this.sseExportContextPath = sseExportContextPath;
    }

    public String getServiceGroup() {
        return this.serviceGroup;
    }

    public void setServiceGroup(String serviceGroup) {
        this.serviceGroup = serviceGroup;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @PostConstruct
    public void init() throws Exception {
        String portFromEnv;
        String ipFromEnv;
        String path;
        if (StringUtils.isBlank((CharSequence)this.sseExportContextPath) && !StringUtils.isBlank((CharSequence)(path = this.environment.getProperty("server.servlet.context-path")))) {
            this.sseExportContextPath = path;
        }
        if (!StringUtils.isEmpty((CharSequence)(ipFromEnv = this.environment.getProperty("NACOS_MCP_SERVER_HOST", "")))) {
            this.host = ipFromEnv;
        }
        if (!StringUtils.isEmpty((CharSequence)(portFromEnv = this.environment.getProperty("NACOS_MCP_SERVER_PORT", "")))) {
            try {
                this.port = Integer.parseInt(portFromEnv);
            }
            catch (NumberFormatException e) {
                log.warn("Invalid port value from NACOS_MCP_SERVER_PORT: {}", (Object)portFromEnv);
            }
        }
    }
}

