/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.connector.postgre;

import com.alibaba.cloud.ai.connector.AbstractDBConnectionPool;
import com.alibaba.cloud.ai.enums.DatabaseDialectEnum;
import com.alibaba.cloud.ai.enums.ErrorCodeEnum;
import org.springframework.stereotype.Service;

@Service(value="postgreSqlJdbcConnectionPool")
public class PostgreSqlJdbcConnectionPool
extends AbstractDBConnectionPool {
    @Override
    public DatabaseDialectEnum getDialect() {
        return DatabaseDialectEnum.POSTGRESQL;
    }

    @Override
    public String getDriver() {
        return "org.postgresql.Driver";
    }

    @Override
    public ErrorCodeEnum errorMapping(String sqlState) {
        ErrorCodeEnum ret = ErrorCodeEnum.fromCode(sqlState);
        if (ret != null) {
            return ret;
        }
        return switch (sqlState) {
            case "08S01" -> ErrorCodeEnum.DATASOURCE_CONNECTION_FAILURE_08S01;
            case "28000" -> ErrorCodeEnum.PASSWORD_ERROR_28000;
            case "42000" -> ErrorCodeEnum.DATABASE_NOT_EXIST_42000;
            default -> ErrorCodeEnum.OTHERS;
        };
    }
}

