/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.connector;

import com.alibaba.cloud.ai.connector.DBConnectionPool;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

@Component
public class DBConnectionPoolContext {
    private final Map<String, DBConnectionPool> poolMap = new HashMap<String, DBConnectionPool>();

    @Autowired
    public DBConnectionPoolContext(List<DBConnectionPool> pools) {
        for (DBConnectionPool pool : pools) {
            String beanName = pool.getClass().getAnnotation(Service.class).value();
            this.poolMap.put(beanName, pool);
        }
    }

    public DBConnectionPool getPoolByType(String type) {
        if (type == null || type.trim().isEmpty()) {
            return null;
        }
        return switch (type.toLowerCase()) {
            case "mysql", "mysqljdbcconnectionpool" -> this.poolMap.get("mysqlJdbcConnectionPool");
            case "postgresql", "postgres", "postgresqljdbcconnectionpool" -> this.poolMap.get("postgreSqlJdbcConnectionPool");
            case "h2", "h2jdbcconnectionpool" -> this.poolMap.get("h2JdbcConnectionPool");
            default -> null;
        };
    }
}

