/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.dashscope.rerank;

import com.alibaba.cloud.ai.dashscope.api.DashScopeApi;
import com.alibaba.cloud.ai.dashscope.metadata.DashScopeAiUsage;
import com.alibaba.cloud.ai.dashscope.rerank.DashScopeRerankOptions;
import com.alibaba.cloud.ai.dashscope.spec.DashScopeApiSpec;
import com.alibaba.cloud.ai.document.DocumentWithScore;
import com.alibaba.cloud.ai.model.RerankModel;
import com.alibaba.cloud.ai.model.RerankOptions;
import com.alibaba.cloud.ai.model.RerankRequest;
import com.alibaba.cloud.ai.model.RerankResponse;
import com.alibaba.cloud.ai.model.RerankResponseMetadata;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.document.Document;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;

public class DashScopeRerankModel
implements RerankModel {
    private static final Logger logger = LoggerFactory.getLogger(DashScopeRerankModel.class);
    private final DashScopeApi dashscopeApi;
    private final RetryTemplate retryTemplate;
    private final DashScopeRerankOptions defaultOptions;

    public DashScopeRerankModel(DashScopeApi dashscopeApi) {
        this(dashscopeApi, DashScopeRerankOptions.builder().build());
    }

    public DashScopeRerankModel(DashScopeApi dashscopeApi, DashScopeRerankOptions defaultOptions) {
        this(dashscopeApi, defaultOptions, RetryUtils.DEFAULT_RETRY_TEMPLATE);
    }

    public DashScopeRerankModel(DashScopeApi dashscopeApi, DashScopeRerankOptions defaultOptions, RetryTemplate retryTemplate) {
        Assert.notNull((Object)dashscopeApi, (String)"DashScopeApi must not be null");
        Assert.notNull((Object)defaultOptions, (String)"Options must not be null");
        Assert.notNull((Object)retryTemplate, (String)"RetryTemplate must not be null");
        this.dashscopeApi = dashscopeApi;
        this.defaultOptions = defaultOptions;
        this.retryTemplate = retryTemplate;
    }

    @Override
    public RerankResponse call(RerankRequest request) {
        Assert.notNull((Object)request.getQuery(), (String)"query must not be null");
        Assert.notNull((Object)request.getInstructions(), (String)"documents must not be null");
        DashScopeRerankOptions requestOptions = this.mergeOptions(request.getOptions(), this.defaultOptions);
        DashScopeApiSpec.RerankRequest rerankRequest = this.createRequest(request, requestOptions);
        ResponseEntity responseEntity = (ResponseEntity)this.retryTemplate.execute(ctx -> this.dashscopeApi.rerankEntity(rerankRequest));
        DashScopeApiSpec.RerankResponse response = (DashScopeApiSpec.RerankResponse)responseEntity.getBody();
        if (response == null) {
            logger.warn("No rerank returned for query: {}", (Object)request.getQuery());
            return new RerankResponse(Collections.emptyList());
        }
        List<DocumentWithScore> documentWithScores = response.output().results().stream().map(data -> DocumentWithScore.builder().withScore(data.relevanceScore()).withDocument((Document)request.getInstructions().get(data.index())).build()).toList();
        RerankResponseMetadata metadata = new RerankResponseMetadata(DashScopeAiUsage.from(response.usage()));
        return new RerankResponse(documentWithScores, metadata);
    }

    private DashScopeApiSpec.RerankRequest createRequest(RerankRequest request, DashScopeRerankOptions requestOptions) {
        List<String> docs = request.getInstructions().stream().map(Document::getText).toList();
        DashScopeApiSpec.RerankRequestParameter parameter = new DashScopeApiSpec.RerankRequestParameter(requestOptions.getTopN(), requestOptions.getReturnDocuments());
        DashScopeApiSpec.RerankRequestInput input = new DashScopeApiSpec.RerankRequestInput(request.getQuery(), docs);
        return new DashScopeApiSpec.RerankRequest(requestOptions.getModel(), input, parameter);
    }

    private DashScopeRerankOptions mergeOptions(@Nullable RerankOptions runtimeOptions, DashScopeRerankOptions defaultOptions) {
        DashScopeRerankOptions runtimeOptionsForProvider = (DashScopeRerankOptions)ModelOptionsUtils.copyToTarget((Object)runtimeOptions, RerankOptions.class, DashScopeRerankOptions.class);
        if (runtimeOptionsForProvider == null) {
            return defaultOptions;
        }
        return DashScopeRerankOptions.builder().model((String)ModelOptionsUtils.mergeOption((Object)runtimeOptionsForProvider.getModel(), (Object)defaultOptions.getModel())).topN((Integer)ModelOptionsUtils.mergeOption((Object)runtimeOptionsForProvider.getTopN(), (Object)defaultOptions.getTopN())).returnDocuments((Boolean)ModelOptionsUtils.mergeOption((Object)runtimeOptionsForProvider.getReturnDocuments(), (Object)defaultOptions.getReturnDocuments())).build();
    }
}

