/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.dashscope.image.observation;

import com.alibaba.cloud.ai.dashscope.image.DashScopeImageOptions;
import io.micrometer.common.KeyValues;
import org.springframework.ai.image.ImageOptions;
import org.springframework.ai.image.ImagePrompt;
import org.springframework.ai.image.observation.DefaultImageModelObservationConvention;
import org.springframework.ai.image.observation.ImageModelObservationContext;

public class DashScopeImageModelObservationConvention
extends DefaultImageModelObservationConvention {
    public KeyValues getHighCardinalityKeyValues(ImageModelObservationContext context) {
        KeyValues keyValues = super.getHighCardinalityKeyValues(context);
        ImageOptions options = ((ImagePrompt)context.getRequest()).getOptions();
        if (options instanceof DashScopeImageOptions) {
            DashScopeImageOptions dashOptions = (DashScopeImageOptions)options;
            if (dashOptions.getRefImg() != null) {
                keyValues = keyValues.and("gen_ai.dashscope.ref_img", dashOptions.getRefImg());
            }
            if (dashOptions.getFunction() != null) {
                keyValues = keyValues.and("gen_ai.dashscope.function", dashOptions.getFunction());
            }
            if (dashOptions.getWatermark() != null) {
                keyValues = keyValues.and("gen_ai.dashscope.watermark", dashOptions.getWatermark().toString());
            }
        }
        return keyValues;
    }

    public String getName() {
        return "dashscope.image.model.operation";
    }
}

