/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.dashscope.image;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import org.springframework.ai.image.ImageOptions;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DashScopeImageOptions
implements ImageOptions {
    @JsonProperty(value="model")
    private String model;
    @JsonProperty(value="n")
    private Integer n;
    @JsonProperty(value="width")
    private Integer width;
    @JsonProperty(value="height")
    private Integer height;
    @JsonProperty(value="size")
    private String size;
    @JsonProperty(value="style")
    private String style;
    @JsonProperty(value="seed")
    private Integer seed;
    @JsonProperty(value="ref_img")
    private String refImg;
    @JsonProperty(value="ref_strength")
    private Float refStrength;
    @JsonProperty(value="response_format")
    private String responseFormat;
    @JsonProperty(value="ref_mode")
    private String refMode;
    @JsonProperty(value="negative_prompt")
    private String negativePrompt;
    @JsonProperty(value="prompt_extend")
    private Boolean promptExtend;
    @JsonProperty(value="watermark")
    private Boolean watermark;
    @JsonProperty(value="function")
    private String function;
    @JsonProperty(value="base_image_url")
    private String baseImageUrl;
    @JsonProperty(value="mask_image_url")
    private String maskImageUrl;
    @JsonProperty(value="sketch_image_url")
    private String sketchImageUrl;
    @JsonProperty(value="sketch_weight")
    private Integer sketchWeight;
    @JsonProperty(value="sketch_extraction")
    private Boolean sketchExtraction;
    @JsonProperty(value="sketch_color")
    private Integer[][] sketchColor;
    @JsonProperty(value="mask_color")
    private Integer[][] maskColor;

    public Boolean getPromptExtend() {
        return this.promptExtend;
    }

    public void setPromptExtend(Boolean promptExtend) {
        this.promptExtend = promptExtend;
    }

    public Boolean getWatermark() {
        return this.watermark;
    }

    public void setWatermark(Boolean watermark) {
        this.watermark = watermark;
    }

    public String getFunction() {
        return this.function;
    }

    public void setFunction(String function) {
        this.function = function;
    }

    public String getBaseImageUrl() {
        return this.baseImageUrl;
    }

    public void setBaseImageUrl(String baseImageUrl) {
        this.baseImageUrl = baseImageUrl;
    }

    public String getMaskImageUrl() {
        return this.maskImageUrl;
    }

    public void setMaskImageUrl(String maskImageUrl) {
        this.maskImageUrl = maskImageUrl;
    }

    public String getSketchImageUrl() {
        return this.sketchImageUrl;
    }

    public void setSketchImageUrl(String sketchImageUrl) {
        this.sketchImageUrl = sketchImageUrl;
    }

    public Integer getSketchWeight() {
        return this.sketchWeight;
    }

    public void setSketchWeight(Integer sketchWeight) {
        this.sketchWeight = sketchWeight;
    }

    public Boolean getSketchExtraction() {
        return this.sketchExtraction;
    }

    public void setSketchExtraction(Boolean sketchExtraction) {
        this.sketchExtraction = sketchExtraction;
    }

    public Integer[][] getSketchColor() {
        return this.sketchColor;
    }

    public void setSketchColor(Integer[][] sketchColor) {
        this.sketchColor = sketchColor;
    }

    public Integer[][] getMaskColor() {
        return this.maskColor;
    }

    public void setMaskColor(Integer[][] maskColor) {
        this.maskColor = maskColor;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Integer getN() {
        return this.n;
    }

    public void setN(Integer n) {
        this.n = n;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
        this.size = this.width + "*" + this.height;
    }

    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
        this.size = this.width + "*" + this.height;
    }

    public String getResponseFormat() {
        return this.responseFormat;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getSize() {
        if (this.size != null) {
            return this.size;
        }
        return this.width != null && this.height != null ? this.width + "*" + this.height : null;
    }

    @Deprecated
    public void setSize(String size) {
        this.size = size;
    }

    public Integer getSeed() {
        return this.seed;
    }

    public void setSeed(Integer seed) {
        this.seed = seed;
    }

    public String getRefImg() {
        return this.refImg;
    }

    public void setRefImg(String refImg) {
        this.refImg = refImg;
    }

    public Float getRefStrength() {
        return this.refStrength;
    }

    public void setRefStrength(Float refStrength) {
        this.refStrength = refStrength;
    }

    public String getRefMode() {
        return this.refMode;
    }

    public void setRefMode(String refMode) {
        this.refMode = refMode;
    }

    public String getNegativePrompt() {
        return this.negativePrompt;
    }

    public void setNegativePrompt(String negativePrompt) {
        this.negativePrompt = negativePrompt;
    }

    public String toString() {
        return "DashScopeImageOptions{model='" + this.model + "', n=" + this.n + ", width=" + this.width + ", height=" + this.height + ", size='" + this.size + "', style='" + this.style + "', seed=" + this.seed + ", refImg='" + this.refImg + "', refStrength=" + this.refStrength + ", responseFormat='" + this.responseFormat + "', refMode='" + this.refMode + "', negativePrompt='" + this.negativePrompt + "', promptExtend=" + this.promptExtend + ", watermark=" + this.watermark + ", function='" + this.function + "', baseImageUrl='" + this.baseImageUrl + "', maskImageUrl='" + this.maskImageUrl + "', sketchImageUrl='" + this.sketchImageUrl + "', sketchWeight=" + this.sketchWeight + ", sketchExtraction=" + this.sketchExtraction + ", sketchColor=" + Arrays.toString((Object[])this.sketchColor) + ", maskColor=" + Arrays.toString((Object[])this.maskColor) + "}";
    }

    public static class Builder {
        private final DashScopeImageOptions options = new DashScopeImageOptions();

        private Builder() {
        }

        public Builder n(Integer n) {
            this.options.setN(n);
            return this;
        }

        @Deprecated
        public Builder withN(Integer n) {
            return this.n(n);
        }

        public Builder model(String model) {
            this.options.setModel(model);
            return this;
        }

        @Deprecated
        public Builder withModel(String model) {
            return this.model(model);
        }

        public Builder width(Integer width) {
            this.options.setWidth(width);
            return this;
        }

        @Deprecated
        public Builder withWidth(Integer width) {
            return this.width(width);
        }

        public Builder height(Integer height) {
            this.options.setHeight(height);
            return this;
        }

        @Deprecated
        public Builder withHeight(Integer height) {
            return this.height(height);
        }

        public Builder style(String style) {
            this.options.setStyle(style);
            return this;
        }

        @Deprecated
        public Builder withStyle(String style) {
            return this.style(style);
        }

        public Builder seed(Integer seed) {
            this.options.setSeed(seed);
            return this;
        }

        @Deprecated
        public Builder withSeed(Integer seed) {
            this.options.setSeed(seed);
            return this;
        }

        public Builder refImg(String refImg) {
            this.options.setRefImg(refImg);
            return this;
        }

        @Deprecated
        public Builder withRefImg(String refImg) {
            return this.refImg(refImg);
        }

        public Builder refStrength(Float refStrength) {
            this.options.setRefStrength(refStrength);
            return this;
        }

        @Deprecated
        public Builder withRefStrength(Float refStrength) {
            return this.refStrength(refStrength);
        }

        public Builder refMode(String refMode) {
            this.options.setRefMode(refMode);
            return this;
        }

        @Deprecated
        public Builder withRefMode(String refMode) {
            return this.refMode(refMode);
        }

        @Deprecated
        public Builder withSize(String size) {
            this.options.setSize(size);
            return this;
        }

        public Builder negativePrompt(String negativePrompt) {
            this.options.setNegativePrompt(negativePrompt);
            return this;
        }

        @Deprecated
        public Builder withNegativePrompt(String negativePrompt) {
            return this.negativePrompt(negativePrompt);
        }

        public Builder promptExtend(Boolean promptExtend) {
            this.options.promptExtend = promptExtend;
            return this;
        }

        @Deprecated
        public Builder withPromptExtend(Boolean promptExtend) {
            return this.promptExtend(promptExtend);
        }

        public Builder watermark(Boolean watermark) {
            this.options.watermark = watermark;
            return this;
        }

        @Deprecated
        public Builder withWatermark(Boolean watermark) {
            return this.watermark(watermark);
        }

        public Builder function(String function) {
            this.options.function = function;
            return this;
        }

        @Deprecated
        public Builder withFunction(String function) {
            return this.function(function);
        }

        public Builder baseImageUrl(String baseImageUrl) {
            this.options.baseImageUrl = baseImageUrl;
            return this;
        }

        @Deprecated
        public Builder withBaseImageUrl(String baseImageUrl) {
            return this.baseImageUrl(baseImageUrl);
        }

        public Builder maskImageUrl(String maskImageUrl) {
            this.options.maskImageUrl = maskImageUrl;
            return this;
        }

        @Deprecated
        public Builder withMaskImageUrl(String maskImageUrl) {
            return this.maskImageUrl(maskImageUrl);
        }

        public Builder sketchImageUrl(String sketchImageUrl) {
            this.options.sketchImageUrl = sketchImageUrl;
            return this;
        }

        @Deprecated
        public Builder withSketchImageUrl(String sketchImageUrl) {
            return this.sketchImageUrl(sketchImageUrl);
        }

        public Builder sketchWeight(Integer sketchWeight) {
            this.options.sketchWeight = sketchWeight;
            return this;
        }

        @Deprecated
        public Builder withSketchWeight(Integer sketchWeight) {
            return this.sketchWeight(sketchWeight);
        }

        public Builder sketchExtraction(Boolean sketchExtraction) {
            this.options.sketchExtraction = sketchExtraction;
            return this;
        }

        @Deprecated
        public Builder withSketchExtraction(Boolean sketchExtraction) {
            return this.sketchExtraction(sketchExtraction);
        }

        public Builder sketchColor(Integer[][] sketchColor) {
            this.options.sketchColor = sketchColor;
            return this;
        }

        @Deprecated
        public Builder withSketchColor(Integer[][] sketchColor) {
            return this.sketchColor(sketchColor);
        }

        public Builder maskColor(Integer[][] maskColor) {
            this.options.maskColor = maskColor;
            return this;
        }

        @Deprecated
        public Builder withMaskColor(Integer[][] maskColor) {
            return this.maskColor(maskColor);
        }

        public Builder responseFormat(String responseFormat) {
            this.options.responseFormat = responseFormat;
            return this;
        }

        @Deprecated
        public Builder withResponseFormat(String responseFormat) {
            return this.responseFormat(responseFormat);
        }

        public DashScopeImageOptions build() {
            return this.options;
        }
    }
}

