/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.dashscope.api;

import com.alibaba.cloud.ai.dashscope.protocol.DashScopeWebSocketClient;
import com.alibaba.cloud.ai.dashscope.protocol.DashScopeWebSocketClientOptions;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.nio.ByteBuffer;
import java.util.List;
import org.springframework.ai.util.JacksonUtils;
import reactor.core.publisher.Flux;

public class DashScopeAudioSpeechApi {
    private final DashScopeWebSocketClient webSocketClient;
    private final ObjectMapper objectMapper;

    public DashScopeAudioSpeechApi(String apiKey) {
        this(apiKey, null);
    }

    public DashScopeAudioSpeechApi(String apiKey, String workSpaceId) {
        this(apiKey, workSpaceId, "wss://dashscope.aliyuncs.com/api-ws/v1/inference");
    }

    public DashScopeAudioSpeechApi(String apiKey, String workSpaceId, String websocketUrl) {
        this.webSocketClient = new DashScopeWebSocketClient(DashScopeWebSocketClientOptions.builder().apiKey(apiKey).workSpaceId(workSpaceId).url(websocketUrl).build());
        this.objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES})).disable(new SerializationFeature[]{SerializationFeature.FAIL_ON_EMPTY_BEANS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).serializationInclusion(JsonInclude.Include.NON_NULL)).addModules((Iterable)JacksonUtils.instantiateAvailableModules())).build();
    }

    public Flux<ByteBuffer> streamBinaryOut(Request request) {
        try {
            String message = this.objectMapper.writeValueAsString((Object)request);
            return this.webSocketClient.streamBinaryOut(message);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static enum ResponseFormat {
        PCM("pcm"),
        WAV("wav"),
        MP3("mp3");

        public final String formatType;

        private ResponseFormat(String value) {
            this.formatType = value;
        }

        public String getValue() {
            return this.formatType;
        }
    }

    public static enum RequestTextType {
        PLAIN_TEXT("PlainText"),
        SSML("SSML");

        private final String value;

        private RequestTextType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class Response {
        ByteBuffer audio;

        public ByteBuffer getAudio() {
            return this.audio;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record Request(@JsonProperty(value="header") RequestHeader header, @JsonProperty(value="payload") RequestPayload payload) {

        public record RequestHeader(@JsonProperty(value="action") DashScopeWebSocketClient.EventType action, @JsonProperty(value="task_id") String taskId, @JsonProperty(value="streaming") String streaming) {
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record RequestPayload(@JsonProperty(value="model") String model, @JsonProperty(value="task_group") String taskGroup, @JsonProperty(value="task") String task, @JsonProperty(value="function") String function, @JsonProperty(value="input") RequestPayloadInput input, @JsonProperty(value="parameters") RequestPayloadParameters parameters) {

            @JsonInclude(value=JsonInclude.Include.NON_NULL)
            public record RequestPayloadInput(@JsonProperty(value="text") String text) {
            }

            @JsonInclude(value=JsonInclude.Include.NON_NULL)
            public record RequestPayloadParameters(@JsonProperty(value="volume") Integer volume, @JsonProperty(value="text_type") RequestTextType textType, @JsonProperty(value="voice") String voice, @JsonProperty(value="sample_rate") Integer sampleRate, @JsonProperty(value="rate") Double rate, @JsonProperty(value="format") ResponseFormat format, @JsonProperty(value="pitch") Double pitch, @JsonProperty(value="enable_ssml") Boolean enableSsml, @JsonProperty(value="bit_rate") Integer bitRate, @JsonProperty(value="seed") Integer seed, @JsonProperty(value="language_hints") List<String> languageHints, @JsonProperty(value="instruction") String instruction, @JsonProperty(value="phoneme_timestamp_enabled") Boolean phonemeTimestampEnabled, @JsonProperty(value="word_timestamp_enabled") Boolean wordTimestampEnabled) {
            }
        }
    }
}

