/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.dashscope.api;

import com.alibaba.cloud.ai.dashscope.api.DashScopeAiStreamFunctionCallingHelper;
import com.alibaba.cloud.ai.dashscope.common.DashScopeException;
import com.alibaba.cloud.ai.dashscope.common.ErrorCodeEnum;
import com.alibaba.cloud.ai.dashscope.rag.DashScopeDocumentRetrieverOptions;
import com.alibaba.cloud.ai.dashscope.rag.DashScopeDocumentTransformerOptions;
import com.alibaba.cloud.ai.dashscope.rag.DashScopeStoreOptions;
import com.alibaba.cloud.ai.dashscope.spec.DashScopeApiSpec;
import com.alibaba.cloud.ai.dashscope.spec.DashScopeModel;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.reactivestreams.Publisher;
import org.springframework.ai.document.Document;
import org.springframework.ai.model.ApiKey;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.model.NoopApiKey;
import org.springframework.ai.model.SimpleApiKey;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClient;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DashScopeApi {
    private static final Predicate<String> SSE_DONE_PREDICATE = "[DONE]"::equals;
    private final String baseUrl;
    private final ApiKey apiKey;
    private final String completionsPath;
    private final String embeddingsPath;
    private final MultiValueMap<String, String> headers;
    public static final String DEFAULT_CHAT_MODEL = DashScopeModel.ChatModel.QWEN_PLUS.getValue();
    public static final String DEFAULT_EMBEDDING_MODEL = DashScopeModel.EmbeddingModel.EMBEDDING_V2.getValue();
    public static final String DEFAULT_EMBEDDING_TEXT_TYPE = DashScopeModel.EmbeddingTextType.DOCUMENT.getValue();
    private final RestClient restClient;
    private final WebClient webClient;
    private final ResponseErrorHandler responseErrorHandler;

    public Builder mutate() {
        return new Builder(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public DashScopeApi(String baseUrl, ApiKey apiKey, MultiValueMap<String, String> header, String completionsPath, String embeddingsPath, String workSpaceId, RestClient.Builder restClientBuilder, WebClient.Builder webClientBuilder, ResponseErrorHandler responseErrorHandler) {
        this.baseUrl = baseUrl;
        this.apiKey = apiKey;
        this.headers = header;
        this.completionsPath = completionsPath;
        this.embeddingsPath = embeddingsPath;
        this.responseErrorHandler = responseErrorHandler;
        if (StringUtils.hasText((String)workSpaceId)) {
            this.headers.add((Object)"X-DashScope-WorkSpace", (Object)workSpaceId);
        }
        Consumer<HttpHeaders> finalHeaders = h -> {
            if (!(apiKey instanceof NoopApiKey)) {
                h.setBearerAuth(apiKey.getValue());
            }
            h.setContentType(MediaType.APPLICATION_JSON);
            h.addAll(this.headers);
        };
        this.restClient = restClientBuilder.clone().baseUrl(baseUrl).defaultHeaders(finalHeaders).defaultStatusHandler(responseErrorHandler).build();
        this.webClient = webClientBuilder.baseUrl(baseUrl).defaultHeaders(finalHeaders).build();
    }

    public ResponseEntity<DashScopeApiSpec.EmbeddingList> embeddings(DashScopeApiSpec.EmbeddingRequest embeddingRequest) {
        Assert.notNull((Object)embeddingRequest, (String)"The request body can not be null.");
        Assert.notNull((Object)embeddingRequest.input(), (String)"The input can not be null.");
        Assert.isTrue((!CollectionUtils.isEmpty(embeddingRequest.input().texts()) ? 1 : 0) != 0, (String)"The input texts can not be empty.");
        Assert.isTrue((embeddingRequest.input().texts().size() <= 25 ? 1 : 0) != 0, (String)"The input texts limit 25.");
        return ((RestClient.RequestBodySpec)((RestClient.RequestBodySpec)this.restClient.post().uri(this.embeddingsPath, new Object[0])).headers(this::addDefaultHeadersIfMissing)).body((Object)embeddingRequest).retrieve().toEntity(DashScopeApiSpec.EmbeddingList.class);
    }

    public String upload(File file, DashScopeApiSpec.UploadRequest request) {
        ResponseEntity<DashScopeApiSpec.UploadLeaseResponse> responseEntity = this.uploadLease(request);
        DashScopeApiSpec.UploadLeaseResponse uploadLeaseResponse = (DashScopeApiSpec.UploadLeaseResponse)responseEntity.getBody();
        if (uploadLeaseResponse == null) {
            throw new DashScopeException(ErrorCodeEnum.READER_APPLY_LEASE_ERROR);
        }
        if (!"SUCCESS".equalsIgnoreCase(uploadLeaseResponse.code())) {
            throw new DashScopeException("ApplyLease Failed,code:%s,message:%s".formatted(uploadLeaseResponse.code(), uploadLeaseResponse.message()));
        }
        this.uploadFile(file, uploadLeaseResponse);
        return this.addFile(uploadLeaseResponse.data().leaseId(), request);
    }

    public ResponseEntity<DashScopeApiSpec.CommonResponse<DashScopeApiSpec.QueryFileResponseData>> queryFileInfo(String categoryId, DashScopeApiSpec.UploadRequest.QueryFileRequest request) {
        return ((RestClient.RequestBodySpec)this.restClient.post().uri("/api/v1/datacenter/category/{category}/file/{file_id}/query", new Object[]{categoryId, request.fileId()})).body((Object)request).retrieve().toEntity((ParameterizedTypeReference)new ParameterizedTypeReference<DashScopeApiSpec.CommonResponse<DashScopeApiSpec.QueryFileResponseData>>(){});
    }

    public String getFileParseResult(String categoryId, DashScopeApiSpec.UploadRequest.QueryFileRequest request) {
        ResponseEntity fileParseResponse = ((RestClient.RequestBodySpec)this.restClient.post().uri("/api/v1/datacenter/category/{category_id}/file/{file_id}/download_lease", new Object[]{categoryId, request.fileId()})).body((Object)request).retrieve().toEntity((ParameterizedTypeReference)new ParameterizedTypeReference<DashScopeApiSpec.CommonResponse<DashScopeApiSpec.QueryFileParseResultData>>(){});
        if (fileParseResponse == null || fileParseResponse.getBody() == null) {
            throw new DashScopeException("GetDocumentParseResultError");
        }
        DashScopeApiSpec.CommonResponse commonResponse = (DashScopeApiSpec.CommonResponse)fileParseResponse.getBody();
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        for (String key : ((DashScopeApiSpec.QueryFileParseResultData)commonResponse.data()).param().headers().keySet()) {
            headers.set(key, ((DashScopeApiSpec.QueryFileParseResultData)commonResponse.data()).param().headers().get(key));
        }
        try {
            HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)headers);
            ResponseEntity response = restTemplate.exchange(new URI(((DashScopeApiSpec.QueryFileParseResultData)commonResponse.data()).param().url()), HttpMethod.GET, requestEntity, String.class);
            return (String)response.getBody();
        }
        catch (Exception ex) {
            throw new DashScopeException("GetDocumentParseResultError");
        }
    }

    private String addFile(String leaseId, DashScopeApiSpec.UploadRequest request) {
        try {
            DashScopeApiSpec.UploadRequest.AddFileRequest addFileRequest = new DashScopeApiSpec.UploadRequest.AddFileRequest(leaseId, "DASHSCOPE_DOCMIND");
            ResponseEntity response = ((RestClient.RequestBodySpec)this.restClient.post().uri("/api/v1/datacenter/category/{category_id}/add_file", new Object[]{request.categoryId()})).body((Object)addFileRequest).retrieve().toEntity((ParameterizedTypeReference)new ParameterizedTypeReference<DashScopeApiSpec.CommonResponse<DashScopeApiSpec.AddFileResponseData>>(){});
            DashScopeApiSpec.CommonResponse addFileResponse = (DashScopeApiSpec.CommonResponse)response.getBody();
            if (addFileResponse == null || !"SUCCESS".equals(addFileResponse.code().toUpperCase())) {
                throw new DashScopeException(ErrorCodeEnum.READER_ADD_FILE_ERROR);
            }
            DashScopeApiSpec.AddFileResponseData addFileResult = (DashScopeApiSpec.AddFileResponseData)addFileResponse.data();
            return addFileResult.fileId();
        }
        catch (Exception ex) {
            throw new DashScopeException(ErrorCodeEnum.READER_ADD_FILE_ERROR);
        }
    }

    private void uploadFile(File file, DashScopeApiSpec.UploadLeaseResponse uploadLeaseResponse) {
        try {
            RequestBody requestBody;
            DashScopeApiSpec.UploadLeaseParamData uploadParam = uploadLeaseResponse.data().param();
            OkHttpClient client = new OkHttpClient.Builder().connectTimeout(60L, TimeUnit.SECONDS).writeTimeout(60L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).build();
            Headers.Builder headersBuilder = new Headers.Builder();
            String contentType = uploadParam.header().remove("Content-Type");
            for (String key : uploadParam.header().keySet()) {
                headersBuilder.add(key, uploadParam.header().get(key));
            }
            if (StringUtils.hasLength((String)contentType)) {
                requestBody = RequestBody.create((File)file, (okhttp3.MediaType)okhttp3.MediaType.parse((String)contentType));
            } else {
                requestBody = RequestBody.create((File)file, null);
                headersBuilder.add("Content-Type", "");
            }
            Request request = new Request.Builder().url(uploadParam.url()).headers(headersBuilder.build()).put(requestBody).build();
            try (Response response = client.newCall(request).execute();){
                if (!response.isSuccessful()) {
                    throw new Exception("Unexpected response code: " + response.code());
                }
            }
        }
        catch (Exception ex) {
            throw new DashScopeException("Upload File Failed", ex);
        }
    }

    private ResponseEntity<DashScopeApiSpec.UploadLeaseResponse> uploadLease(DashScopeApiSpec.UploadRequest request) {
        return ((RestClient.RequestBodySpec)this.restClient.post().uri("/api/v1/datacenter/category/{category_id}/upload_lease", new Object[]{request.categoryId()})).body((Object)request).retrieve().toEntity(DashScopeApiSpec.UploadLeaseResponse.class);
    }

    public ResponseEntity<DashScopeApiSpec.DocumentSplitResponse> documentSplit(Document document, DashScopeDocumentTransformerOptions options) {
        DashScopeApiSpec.DocumentSplitRequest request = new DashScopeApiSpec.DocumentSplitRequest(document.getText(), options.getChunkSize(), options.getOverlapSize(), options.getFileType(), options.getLanguage(), options.getSeparator());
        return ((RestClient.RequestBodySpec)this.restClient.post().uri("/api/v1/indices/component/configed_transformations/spliter", new Object[0])).body((Object)request).retrieve().toEntity((ParameterizedTypeReference)new ParameterizedTypeReference<DashScopeApiSpec.DocumentSplitResponse>(){});
    }

    public String getPipelineIdByName(String pipelineName) {
        ResponseEntity startPipelineResponse = this.restClient.get().uri(ub -> ub.path("/api/v1/indices/pipeline_simple").queryParam("pipeline_name", new Object[]{pipelineName}).build(new Object[0])).retrieve().toEntity(DashScopeApiSpec.QueryPipelineResponse.class);
        if (startPipelineResponse == null || startPipelineResponse.getBody() == null || ((DashScopeApiSpec.QueryPipelineResponse)startPipelineResponse.getBody()).pipelineId() == null) {
            return null;
        }
        return ((DashScopeApiSpec.QueryPipelineResponse)startPipelineResponse.getBody()).pipelineId();
    }

    public void upsertPipeline(List<Document> documents, DashScopeStoreOptions storeOptions) {
        String embeddingModelName = storeOptions.getEmbeddingOptions() == null ? DEFAULT_EMBEDDING_MODEL : storeOptions.getEmbeddingOptions().getModel();
        DashScopeApiSpec.EmbeddingConfiguredTransformations embeddingConfig = new DashScopeApiSpec.EmbeddingConfiguredTransformations("DASHSCOPE_EMBEDDING", new DashScopeApiSpec.EmbeddingConfiguredTransformations.EmbeddingComponent(embeddingModelName));
        DashScopeDocumentTransformerOptions transformerOptions = storeOptions.getTransformerOptions();
        if (transformerOptions == null) {
            transformerOptions = new DashScopeDocumentTransformerOptions();
        }
        DashScopeApiSpec.ParserConfiguredTransformations parserConfig = new DashScopeApiSpec.ParserConfiguredTransformations("DASHSCOPE_JSON_NODE_PARSER", new DashScopeApiSpec.ParserConfiguredTransformations.ParserComponent(transformerOptions.getChunkSize(), transformerOptions.getOverlapSize(), "idp", transformerOptions.getSeparator(), transformerOptions.getLanguage()));
        DashScopeDocumentRetrieverOptions retrieverOptions = storeOptions.getRetrieverOptions();
        if (retrieverOptions == null) {
            retrieverOptions = new DashScopeDocumentRetrieverOptions();
        }
        DashScopeApiSpec.RetrieverConfiguredTransformations retrieverConfig = new DashScopeApiSpec.RetrieverConfiguredTransformations("DASHSCOPE_RETRIEVER", new DashScopeApiSpec.RetrieverConfiguredTransformations.RetrieverComponent(retrieverOptions.isEnableRewrite(), List.of(new DashScopeApiSpec.RetrieverConfiguredTransformations.CommonModelComponent(retrieverOptions.getRewriteModelName())), retrieverOptions.getSparseSimilarityTopK(), retrieverOptions.getDenseSimilarityTopK(), retrieverOptions.isEnableReranking(), List.of(new DashScopeApiSpec.RetrieverConfiguredTransformations.CommonModelComponent(retrieverOptions.getRerankModelName())), retrieverOptions.getRerankMinScore(), retrieverOptions.getRerankTopN(), retrieverOptions.getSearchFilters()));
        List<String> documentIdList = documents.stream().map(Document::getId).filter(Objects::nonNull).collect(Collectors.toList());
        DashScopeApiSpec.UpsertPipelineRequest upsertPipelineRequest = new DashScopeApiSpec.UpsertPipelineRequest(storeOptions.getIndexName(), "MANAGED_SHARED", null, "unstructured", "recommend", Arrays.asList(embeddingConfig, parserConfig, retrieverConfig), List.of(new DashScopeApiSpec.DataSourcesConfig("DATA_CENTER_FILE", new DashScopeApiSpec.DataSourcesConfig.DataSourcesComponent(documentIdList))), List.of(new DashScopeApiSpec.DataSinksConfig("BUILT_IN", null)));
        ResponseEntity upsertPipelineResponse = ((RestClient.RequestBodySpec)this.restClient.put().uri("/api/v1/indices/pipeline", new Object[0])).body((Object)upsertPipelineRequest).retrieve().toEntity(DashScopeApiSpec.UpsertPipelineResponse.class);
        if (upsertPipelineResponse.getBody() == null || !"SUCCESS".equalsIgnoreCase(((DashScopeApiSpec.UpsertPipelineResponse)upsertPipelineResponse.getBody()).status())) {
            throw new DashScopeException(ErrorCodeEnum.CREATE_INDEX_ERROR);
        }
        String pipelineId = ((DashScopeApiSpec.UpsertPipelineResponse)upsertPipelineResponse.getBody()).id();
        ResponseEntity startPipelineResponse = ((RestClient.RequestBodySpec)this.restClient.post().uri("/api/v1/indices/pipeline/{pipeline_id}/managed_ingest", new Object[]{pipelineId})).body((Object)upsertPipelineRequest).retrieve().toEntity(DashScopeApiSpec.StartPipelineResponse.class);
        if (startPipelineResponse.getBody() == null || !"SUCCESS".equalsIgnoreCase(((DashScopeApiSpec.StartPipelineResponse)startPipelineResponse.getBody()).code()) || ((DashScopeApiSpec.StartPipelineResponse)startPipelineResponse.getBody()).ingestionId() == null) {
            throw new DashScopeException(ErrorCodeEnum.INDEX_ADD_DOCUMENT_ERROR);
        }
    }

    public boolean deletePipelineDocument(String pipelineId, List<String> idList) {
        DashScopeApiSpec.DelePipelineDocumentRequest request = new DashScopeApiSpec.DelePipelineDocumentRequest(Arrays.asList(new DashScopeApiSpec.DelePipelineDocumentRequest.DelePipelineDocumentDataSource("DATA_CENTER_FILE", Arrays.asList(new DashScopeApiSpec.DelePipelineDocumentRequest.DelePipelineDocumentDataSourceComponent(idList)))));
        ResponseEntity deleDocumentResponse = ((RestClient.RequestBodySpec)this.restClient.post().uri("/api/v1/indices/pipeline/{pipeline_id}/delete", new Object[]{pipelineId})).body((Object)request).retrieve().toEntity(DashScopeApiSpec.DelePipelineDocumentResponse.class);
        return deleDocumentResponse != null && deleDocumentResponse.getBody() != null && "SUCCESS".equalsIgnoreCase(((DashScopeApiSpec.DelePipelineDocumentResponse)deleDocumentResponse.getBody()).code());
    }

    public List<Document> retriever(String pipelineId, String query, DashScopeDocumentRetrieverOptions searchOption) {
        DashScopeApiSpec.DocumentRetrieveRequest request = new DashScopeApiSpec.DocumentRetrieveRequest(query, searchOption.getDenseSimilarityTopK(), searchOption.getDenseSimilarityTopK(), searchOption.isEnableRewrite(), List.of(new DashScopeApiSpec.DocumentRetrieveRequest.DocumentRetrieveModelConfig(searchOption.getRewriteModelName(), "DashScopeTextRewrite")), searchOption.isEnableReranking(), List.of(new DashScopeApiSpec.DocumentRetrieveRequest.DocumentRetrieveModelConfig(searchOption.getRerankModelName(), null)), searchOption.getRerankMinScore(), searchOption.getRerankTopN(), searchOption.getSearchFilters());
        ResponseEntity deleDocumentResponse = ((RestClient.RequestBodySpec)this.restClient.post().uri("/api/v1/indices/pipeline/{pipeline_id}/retrieve", new Object[]{pipelineId})).body((Object)request).retrieve().toEntity(DashScopeApiSpec.DocumentRetrieveResponse.class);
        if (deleDocumentResponse == null || deleDocumentResponse.getBody() == null || !"SUCCESS".equalsIgnoreCase(((DashScopeApiSpec.DocumentRetrieveResponse)deleDocumentResponse.getBody()).code())) {
            throw new DashScopeException(ErrorCodeEnum.RETRIEVER_DOCUMENT_ERROR);
        }
        List<DashScopeApiSpec.DocumentRetrieveResponse.DocumentRetrieveResponseNode> nodeList = ((DashScopeApiSpec.DocumentRetrieveResponse)deleDocumentResponse.getBody()).nodes();
        if (nodeList == null || nodeList.isEmpty()) {
            return new ArrayList<Document>();
        }
        ArrayList<Document> documents = new ArrayList<Document>();
        nodeList.forEach(e -> {
            DashScopeApiSpec.DocumentRetrieveResponse.DocumentRetrieveResponseNodeData nodeData = e.node();
            Document toDocument = new Document(nodeData.id(), nodeData.text(), nodeData.metadata());
            documents.add(toDocument);
        });
        return documents;
    }

    public static String getTextContent(List<DashScopeApiSpec.ChatCompletionMessage.MediaContent> content) {
        return content.stream().filter(c -> "text".equals(c.type())).map(DashScopeApiSpec.ChatCompletionMessage.MediaContent::text).reduce("", (a, b) -> a + b);
    }

    public ResponseEntity<DashScopeApiSpec.ChatCompletion> chatCompletionEntity(DashScopeApiSpec.ChatCompletionRequest chatRequest) {
        return this.chatCompletionEntity(chatRequest, (MultiValueMap<String, String>)new LinkedMultiValueMap());
    }

    public ResponseEntity<DashScopeApiSpec.ChatCompletion> chatCompletionEntity(DashScopeApiSpec.ChatCompletionRequest chatRequest, MultiValueMap<String, String> additionalHttpHeader) {
        Assert.notNull((Object)chatRequest, (String)"The request body can not be null.");
        Assert.isTrue((chatRequest.stream() == false ? 1 : 0) != 0, (String)"Request must set the stream property to false.");
        Assert.notNull(additionalHttpHeader, (String)"The additional HTTP headers can not be null.");
        String chatCompletionUri = this.completionsPath;
        if (chatRequest.multiModel().booleanValue()) {
            chatCompletionUri = "/api/v1/services/aigc/multimodal-generation/generation";
        }
        return ((RestClient.RequestBodySpec)((RestClient.RequestBodySpec)this.restClient.post().uri(chatCompletionUri, new Object[0])).headers(headers -> {
            headers.addAll(additionalHttpHeader);
            this.addDefaultHeadersIfMissing((HttpHeaders)headers);
        })).body((Object)chatRequest).retrieve().toEntity(DashScopeApiSpec.ChatCompletion.class);
    }

    private void addDefaultHeadersIfMissing(HttpHeaders headers) {
        if (!headers.containsKey((Object)"Authorization") && !(this.apiKey instanceof NoopApiKey)) {
            headers.setBearerAuth(this.apiKey.getValue());
        }
    }

    public Flux<DashScopeApiSpec.ChatCompletionChunk> chatCompletionStream(DashScopeApiSpec.ChatCompletionRequest chatRequest) {
        return this.chatCompletionStream(chatRequest, null);
    }

    public Flux<DashScopeApiSpec.ChatCompletionChunk> chatCompletionStream(DashScopeApiSpec.ChatCompletionRequest chatRequest, MultiValueMap<String, String> additionalHttpHeader) {
        Assert.notNull((Object)chatRequest, (String)"The request body can not be null.");
        Assert.isTrue((boolean)chatRequest.stream(), (String)"Request must set the stream property to true.");
        AtomicBoolean isInsideTool = new AtomicBoolean(false);
        boolean incrementalOutput = chatRequest.parameters() != null && chatRequest.parameters().incrementalOutput() != null && chatRequest.parameters().incrementalOutput() != false;
        DashScopeAiStreamFunctionCallingHelper chunkMerger = new DashScopeAiStreamFunctionCallingHelper(incrementalOutput);
        String chatCompletionUri = this.completionsPath;
        if (chatRequest.multiModel().booleanValue()) {
            chatCompletionUri = "/api/v1/services/aigc/multimodal-generation/generation";
        }
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri(chatCompletionUri, new Object[0])).headers(headers -> {
            headers.addAll(additionalHttpHeader);
            headers.add("X-DashScope-SSE", "enable");
            this.addDefaultHeadersIfMissing((HttpHeaders)headers);
        })).body((Publisher)Mono.just((Object)chatRequest), DashScopeApiSpec.ChatCompletionRequest.class).retrieve().bodyToFlux(String.class).takeUntil(SSE_DONE_PREDICATE).filter(SSE_DONE_PREDICATE.negate()).map(content -> {
            DashScopeApiSpec.DashScopeErrorResponse error = (DashScopeApiSpec.DashScopeErrorResponse)ModelOptionsUtils.jsonToObject((String)content, DashScopeApiSpec.DashScopeErrorResponse.class);
            if (error != null && error.code() != null) {
                throw new DashScopeException(String.format("[%s] %s (requestId: %s)", error.code(), error.message(), error.requestId()));
            }
            DashScopeApiSpec.ChatCompletionChunk chunk = (DashScopeApiSpec.ChatCompletionChunk)ModelOptionsUtils.jsonToObject((String)content, DashScopeApiSpec.ChatCompletionChunk.class);
            if (chunk == null) {
                throw new DashScopeException("Failed to parse response content: " + content);
            }
            return chunk;
        }).map(chunk -> {
            if (chunkMerger.isStreamingToolFunctionCall((DashScopeApiSpec.ChatCompletionChunk)chunk)) {
                isInsideTool.set(true);
            }
            return chunk;
        }).windowUntil(chunk -> {
            if (isInsideTool.get() && chunkMerger.isStreamingToolFunctionCallFinish((DashScopeApiSpec.ChatCompletionChunk)chunk)) {
                isInsideTool.set(false);
                return true;
            }
            return !isInsideTool.get();
        }).concatMapIterable(window -> {
            Mono monoChunk = window.reduce((Object)new DashScopeApiSpec.ChatCompletionChunk(null, null, null, null), chunkMerger::merge);
            return List.of(monoChunk);
        }).flatMap(mono -> mono);
    }

    public ResponseEntity<DashScopeApiSpec.RerankResponse> rerankEntity(DashScopeApiSpec.RerankRequest rerankRequest) {
        Assert.notNull((Object)rerankRequest, (String)"The request body can not be null.");
        return ((RestClient.RequestBodySpec)this.restClient.post().uri("/api/v1/services/rerank/text-rerank/text-rerank", new Object[0])).body((Object)rerankRequest).retrieve().toEntity(DashScopeApiSpec.RerankResponse.class);
    }

    String getBaseUrl() {
        return this.baseUrl;
    }

    ApiKey getApiKey() {
        return this.apiKey;
    }

    MultiValueMap<String, String> getHeaders() {
        return this.headers;
    }

    ResponseErrorHandler getResponseErrorHandler() {
        return this.responseErrorHandler;
    }

    public static class Builder {
        private String baseUrl = "https://dashscope.aliyuncs.com";
        private ApiKey apiKey;
        private String workSpaceId;
        private MultiValueMap<String, String> headers = new LinkedMultiValueMap();
        private String completionsPath = "/api/v1/services/aigc/text-generation/generation";
        private String embeddingsPath = "/api/v1/services/embeddings/text-embedding/text-embedding";
        private RestClient.Builder restClientBuilder = RestClient.builder();
        private WebClient.Builder webClientBuilder = WebClient.builder();
        private ResponseErrorHandler responseErrorHandler = RetryUtils.DEFAULT_RESPONSE_ERROR_HANDLER;

        public Builder() {
        }

        public Builder(DashScopeApi api) {
            this.baseUrl = api.getBaseUrl();
            this.apiKey = api.getApiKey();
            this.headers = new LinkedMultiValueMap(api.getHeaders());
            this.restClientBuilder = api.restClient != null ? api.restClient.mutate() : RestClient.builder();
            this.webClientBuilder = api.webClient != null ? api.webClient.mutate() : WebClient.builder();
            this.responseErrorHandler = api.getResponseErrorHandler();
        }

        public Builder baseUrl(String baseUrl) {
            Assert.notNull((Object)baseUrl, (String)"Base URL cannot be null");
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder workSpaceId(String workSpaceId) {
            if (StringUtils.hasText((String)workSpaceId)) {
                Assert.notNull((Object)workSpaceId, (String)"Workspace ID cannot be null");
            }
            this.workSpaceId = workSpaceId;
            return this;
        }

        public Builder apiKey(String simpleApiKey) {
            Assert.notNull((Object)simpleApiKey, (String)"Simple api key cannot be null");
            this.apiKey = new SimpleApiKey(simpleApiKey);
            return this;
        }

        public Builder headers(MultiValueMap<String, String> headers) {
            Assert.notNull(headers, (String)"Headers cannot be null");
            this.headers = headers;
            return this;
        }

        public Builder restClientBuilder(RestClient.Builder restClientBuilder) {
            Assert.notNull((Object)restClientBuilder, (String)"Rest client builder cannot be null");
            this.restClientBuilder = restClientBuilder;
            return this;
        }

        public Builder completionsPath(String completionsPath) {
            Assert.notNull((Object)completionsPath, (String)"Completions path cannot be null");
            this.completionsPath = completionsPath;
            return this;
        }

        public Builder embeddingsPath(String embeddingsPath) {
            Assert.notNull((Object)embeddingsPath, (String)"Embeddings path cannot be null");
            this.embeddingsPath = embeddingsPath;
            return this;
        }

        public Builder webClientBuilder(WebClient.Builder webClientBuilder) {
            Assert.notNull((Object)webClientBuilder, (String)"Web client builder cannot be null");
            this.webClientBuilder = webClientBuilder;
            return this;
        }

        public Builder responseErrorHandler(ResponseErrorHandler responseErrorHandler) {
            Assert.notNull((Object)responseErrorHandler, (String)"Response error handler cannot be null");
            this.responseErrorHandler = responseErrorHandler;
            return this;
        }

        public DashScopeApi build() {
            Assert.notNull((Object)this.apiKey, (String)"API key cannot be null");
            return new DashScopeApi(this.baseUrl, this.apiKey, this.headers, this.completionsPath, this.embeddingsPath, this.workSpaceId, this.restClientBuilder, this.webClientBuilder, this.responseErrorHandler);
        }
    }
}

