/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.dashscope.api;

import com.alibaba.cloud.ai.dashscope.spec.DashScopeApiSpec;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class DashScopeAiStreamFunctionCallingHelper {
    private Boolean incrementalOutput = false;

    public DashScopeAiStreamFunctionCallingHelper() {
    }

    public DashScopeAiStreamFunctionCallingHelper(Boolean incrementalOutput) {
        this.incrementalOutput = incrementalOutput;
    }

    public DashScopeApiSpec.ChatCompletionChunk merge(DashScopeApiSpec.ChatCompletionChunk previous, DashScopeApiSpec.ChatCompletionChunk current) {
        DashScopeApiSpec.ChatCompletionOutput.Choice currentChoice0;
        DashScopeApiSpec.ChatCompletionOutput.Choice previousChoice0;
        DashScopeApiSpec.TokenUsage usage;
        if (previous == null) {
            return current;
        }
        String id = current.requestId() != null ? current.requestId() : previous.requestId();
        DashScopeApiSpec.TokenUsage tokenUsage = usage = current.usage() != null ? current.usage() : previous.usage();
        DashScopeApiSpec.ChatCompletionOutput.Choice choice = previous.output() == null ? null : (previousChoice0 = CollectionUtils.isEmpty(previous.output().choices()) ? null : previous.output().choices().get(0));
        DashScopeApiSpec.ChatCompletionOutput.Choice choice2 = current.output() == null ? null : (currentChoice0 = CollectionUtils.isEmpty(current.output().choices()) ? null : current.output().choices().get(0));
        if (!this.incrementalOutput.booleanValue() && this.isStreamingToolFunctionCall(current)) {
            if (!this.isStreamingToolFunctionCallFinish(current)) {
                return new DashScopeApiSpec.ChatCompletionChunk(id, new DashScopeApiSpec.ChatCompletionOutput(null, List.of(), null), usage, null);
            }
            List<DashScopeApiSpec.ChatCompletionOutput.Choice> choices = currentChoice0 == null ? List.of() : List.of(currentChoice0);
            return new DashScopeApiSpec.ChatCompletionChunk(id, new DashScopeApiSpec.ChatCompletionOutput(null, choices, null), usage, null);
        }
        DashScopeApiSpec.ChatCompletionOutput.Choice choice3 = this.merge(previousChoice0, currentChoice0);
        List<DashScopeApiSpec.ChatCompletionOutput.Choice> chunkChoices = choice3 == null ? List.of() : List.of(choice3);
        return new DashScopeApiSpec.ChatCompletionChunk(id, new DashScopeApiSpec.ChatCompletionOutput(null, chunkChoices, null), usage, null);
    }

    private DashScopeApiSpec.ChatCompletionOutput.Choice merge(DashScopeApiSpec.ChatCompletionOutput.Choice previous, DashScopeApiSpec.ChatCompletionOutput.Choice current) {
        if (previous == null) {
            return current;
        }
        if (current == null) {
            return null;
        }
        DashScopeApiSpec.ChatCompletionFinishReason finishReason = current.finishReason() != null ? current.finishReason() : previous.finishReason();
        DashScopeApiSpec.ChatCompletionMessage message = this.merge(previous.message(), current.message());
        DashScopeApiSpec.ChatCompletionLogprobs logprobs = current.logprobs() != null ? current.logprobs() : previous.logprobs();
        return new DashScopeApiSpec.ChatCompletionOutput.Choice(finishReason, message, logprobs);
    }

    private DashScopeApiSpec.ChatCompletionMessage merge(DashScopeApiSpec.ChatCompletionMessage previous, DashScopeApiSpec.ChatCompletionMessage current) {
        String content = current.content() != null ? current.content() : (previous.content() != null ? previous.content() : "");
        DashScopeApiSpec.ChatCompletionMessage.Role role = current.role() != null ? current.role() : previous.role();
        role = role != null ? role : DashScopeApiSpec.ChatCompletionMessage.Role.ASSISTANT;
        String name = StringUtils.hasText((String)current.name()) ? current.name() : previous.name();
        String toolCallId = StringUtils.hasText((String)current.toolCallId()) ? current.toolCallId() : previous.toolCallId();
        String reasoningContent = current.reasoningContent() != null ? current.reasoningContent() : previous.reasoningContent();
        Boolean partial = current.partial() != null ? current.partial() : previous.partial();
        List<DashScopeApiSpec.ChatCompletionAnnotations> annotations = current.annotations() != null ? current.annotations() : previous.annotations();
        String status = current.status() != null ? current.status() : previous.status();
        String phase = current.phase() != null ? current.phase() : previous.phase();
        ArrayList<DashScopeApiSpec.ChatCompletionMessage.ToolCall> toolCalls = new ArrayList<DashScopeApiSpec.ChatCompletionMessage.ToolCall>();
        DashScopeApiSpec.ChatCompletionMessage.ToolCall lastPreviousTooCall = null;
        if (previous.toolCalls() != null) {
            lastPreviousTooCall = previous.toolCalls().get(previous.toolCalls().size() - 1);
            if (previous.toolCalls().size() > 1) {
                toolCalls.addAll(previous.toolCalls().subList(0, previous.toolCalls().size() - 1));
            }
        }
        if (!CollectionUtils.isEmpty(current.toolCalls())) {
            if (current.toolCalls().size() > 1) {
                throw new IllegalStateException("Currently only one tool call is supported per message!");
            }
            DashScopeApiSpec.ChatCompletionMessage.ToolCall currentToolCall = current.toolCalls().iterator().next();
            if (StringUtils.hasText((String)currentToolCall.id())) {
                if (lastPreviousTooCall != null) {
                    toolCalls.add(lastPreviousTooCall);
                }
                toolCalls.add(currentToolCall);
            } else {
                toolCalls.add(this.merge(lastPreviousTooCall, currentToolCall));
            }
        } else if (lastPreviousTooCall != null) {
            toolCalls.add(lastPreviousTooCall);
        }
        return new DashScopeApiSpec.ChatCompletionMessage(content, role, name, toolCallId, toolCalls, reasoningContent, partial, phase, annotations, status);
    }

    private DashScopeApiSpec.ChatCompletionMessage.ToolCall merge(DashScopeApiSpec.ChatCompletionMessage.ToolCall previous, DashScopeApiSpec.ChatCompletionMessage.ToolCall current) {
        if (previous == null) {
            return current;
        }
        String id = StringUtils.hasText((String)current.id()) ? current.id() : previous.id();
        String type = StringUtils.hasText((String)current.type()) ? current.type() : previous.type();
        Integer index = current.index() != 0 ? current.index() : previous.index();
        DashScopeApiSpec.ChatCompletionMessage.ChatCompletionFunction function = this.merge(previous.function(), current.function());
        return new DashScopeApiSpec.ChatCompletionMessage.ToolCall(id, type, function, index);
    }

    private DashScopeApiSpec.ChatCompletionMessage.ChatCompletionFunction merge(DashScopeApiSpec.ChatCompletionMessage.ChatCompletionFunction previous, DashScopeApiSpec.ChatCompletionMessage.ChatCompletionFunction current) {
        if (previous == null) {
            return current;
        }
        String name = StringUtils.hasText((String)current.name()) ? current.name() : previous.name();
        StringBuilder arguments = new StringBuilder();
        if (previous.arguments() != null) {
            arguments.append(previous.arguments());
        }
        if (current.arguments() != null) {
            arguments.append(current.arguments());
        }
        return new DashScopeApiSpec.ChatCompletionMessage.ChatCompletionFunction(name, arguments.toString());
    }

    public boolean isStreamingToolFunctionCall(DashScopeApiSpec.ChatCompletionChunk chatCompletion) {
        DashScopeApiSpec.ChatCompletionOutput.Choice choice = this.checkChatCompletionChunk(chatCompletion);
        if (choice == null) {
            return false;
        }
        return !CollectionUtils.isEmpty(choice.message().toolCalls());
    }

    public boolean isStreamingToolFunctionCallFinish(DashScopeApiSpec.ChatCompletionChunk chatCompletion) {
        DashScopeApiSpec.ChatCompletionOutput.Choice choice = this.checkChatCompletionChunk(chatCompletion);
        if (choice == null) {
            return false;
        }
        return choice.finishReason() == DashScopeApiSpec.ChatCompletionFinishReason.TOOL_CALLS;
    }

    public DashScopeApiSpec.ChatCompletion chunkToChatCompletion(DashScopeApiSpec.ChatCompletionChunk chunk) {
        return new DashScopeApiSpec.ChatCompletion(chunk.requestId(), chunk.output(), chunk.usage());
    }

    private DashScopeApiSpec.ChatCompletionOutput.Choice checkChatCompletionChunk(DashScopeApiSpec.ChatCompletionChunk chatCompletion) {
        if (chatCompletion == null || chatCompletion.output() == null || CollectionUtils.isEmpty(chatCompletion.output().choices())) {
            return null;
        }
        DashScopeApiSpec.ChatCompletionOutput.Choice choice = chatCompletion.output().choices().get(0);
        if (choice == null || choice.message() == null) {
            return null;
        }
        return choice;
    }
}

