/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.dashscope.audio;

import com.alibaba.cloud.ai.dashscope.api.DashScopeAudioSpeechApi;
import com.alibaba.cloud.ai.dashscope.audio.DashScopeAudioSpeechOptions;
import com.alibaba.cloud.ai.dashscope.audio.synthesis.SpeechSynthesisMessage;
import com.alibaba.cloud.ai.dashscope.audio.synthesis.SpeechSynthesisModel;
import com.alibaba.cloud.ai.dashscope.audio.synthesis.SpeechSynthesisOptions;
import com.alibaba.cloud.ai.dashscope.audio.synthesis.SpeechSynthesisOutput;
import com.alibaba.cloud.ai.dashscope.audio.synthesis.SpeechSynthesisPrompt;
import com.alibaba.cloud.ai.dashscope.audio.synthesis.SpeechSynthesisResponse;
import com.alibaba.cloud.ai.dashscope.audio.synthesis.SpeechSynthesisResult;
import com.alibaba.cloud.ai.dashscope.spec.DashScopeModel;
import java.nio.ByteBuffer;
import java.util.UUID;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.retry.support.RetryTemplate;
import reactor.core.publisher.Flux;

public class DashScopeAudioSpeechModel
implements SpeechSynthesisModel {
    private final DashScopeAudioSpeechApi api;
    private final DashScopeAudioSpeechOptions options;
    private final RetryTemplate retryTemplate;

    public DashScopeAudioSpeechModel(DashScopeAudioSpeechApi api) {
        this(api, DashScopeAudioSpeechOptions.builder().model(DashScopeModel.AudioModel.COSYVOICE_V1.getValue()).voice("longhua").speed(Float.valueOf(1.0f)).responseFormat(DashScopeAudioSpeechApi.ResponseFormat.MP3).build());
    }

    public DashScopeAudioSpeechModel(DashScopeAudioSpeechApi api, DashScopeAudioSpeechOptions options) {
        this(api, options, RetryUtils.DEFAULT_RETRY_TEMPLATE);
    }

    public DashScopeAudioSpeechModel(DashScopeAudioSpeechApi api, DashScopeAudioSpeechOptions options, RetryTemplate retryTemplate) {
        this.api = api;
        this.options = options;
        this.retryTemplate = retryTemplate;
    }

    @Override
    public SpeechSynthesisResponse call(SpeechSynthesisPrompt prompt) {
        Flux<SpeechSynthesisResponse> flux = this.stream(prompt);
        return (SpeechSynthesisResponse)flux.reduce((resp1, resp2) -> {
            ByteBuffer combinedBuffer = ByteBuffer.allocate(resp1.getResult().getOutput().getAudio().remaining() + resp2.getResult().getOutput().getAudio().remaining());
            combinedBuffer.put(resp1.getResult().getOutput().getAudio());
            combinedBuffer.put(resp2.getResult().getOutput().getAudio());
            combinedBuffer.flip();
            return new SpeechSynthesisResponse(new SpeechSynthesisResult(new SpeechSynthesisOutput(combinedBuffer)));
        }).block();
    }

    @Override
    public Flux<SpeechSynthesisResponse> stream(SpeechSynthesisPrompt prompt) {
        return (Flux)this.retryTemplate.execute(ctx -> this.api.streamOut(this.createRequest(prompt)).map(SpeechSynthesisOutput::new).map(SpeechSynthesisResult::new).map(SpeechSynthesisResponse::new));
    }

    public DashScopeAudioSpeechApi.Request createRequest(SpeechSynthesisPrompt prompt) {
        DashScopeAudioSpeechOptions options = DashScopeAudioSpeechOptions.builder().build();
        if (prompt.getOptions() != null) {
            DashScopeAudioSpeechOptions runtimeOptions = (DashScopeAudioSpeechOptions)ModelOptionsUtils.copyToTarget((Object)prompt.getOptions(), SpeechSynthesisOptions.class, DashScopeAudioSpeechOptions.class);
            options = (DashScopeAudioSpeechOptions)ModelOptionsUtils.merge((Object)runtimeOptions, (Object)options, DashScopeAudioSpeechOptions.class);
        }
        options = (DashScopeAudioSpeechOptions)ModelOptionsUtils.merge((Object)options, (Object)this.options, DashScopeAudioSpeechOptions.class);
        return new DashScopeAudioSpeechApi.Request(new DashScopeAudioSpeechApi.Request.RequestHeader("run-task", UUID.randomUUID().toString(), "out"), new DashScopeAudioSpeechApi.Request.RequestPayload(options.getModel(), "audio", "tts", "SpeechSynthesizer", new DashScopeAudioSpeechApi.Request.RequestPayload.RequestPayloadInput(((SpeechSynthesisMessage)prompt.getInstructions().get(0)).getText()), new DashScopeAudioSpeechApi.Request.RequestPayload.RequestPayloadParameters(options.getVolume(), options.getRequestTextType().getValue(), options.getVoice(), options.getSampleRate(), options.getSpeed(), options.getResponseFormat().getValue(), options.getPitch(), options.getEnablePhonemeTimestamp(), options.getEnableWordTimestamp())));
    }

    private SpeechSynthesisResponse toResponse(DashScopeAudioSpeechApi.Response apiResponse) {
        SpeechSynthesisOutput output = new SpeechSynthesisOutput(apiResponse.getAudio());
        SpeechSynthesisResult result = new SpeechSynthesisResult(output);
        return new SpeechSynthesisResponse(result);
    }
}

