/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.autoconfigure.dashscope;

import com.alibaba.cloud.ai.autoconfigure.dashscope.ConditionalOnDashScopeEnabled;
import com.alibaba.cloud.ai.autoconfigure.dashscope.DashScopeAudioTranscriptionProperties;
import com.alibaba.cloud.ai.autoconfigure.dashscope.DashScopeConnectionProperties;
import com.alibaba.cloud.ai.autoconfigure.dashscope.DashScopeConnectionUtils;
import com.alibaba.cloud.ai.autoconfigure.dashscope.ResolvedConnectionProperties;
import com.alibaba.cloud.ai.dashscope.api.DashScopeAudioTranscriptionApi;
import com.alibaba.cloud.ai.dashscope.audio.DashScopeAudioTranscriptionModel;
import org.springframework.ai.model.ApiKey;
import org.springframework.ai.model.SimpleApiKey;
import org.springframework.ai.retry.autoconfigure.SpringAiRetryAutoConfiguration;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.client.RestClientAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClient;

@ConditionalOnClass(value={DashScopeAudioTranscriptionApi.class})
@ConditionalOnDashScopeEnabled
@AutoConfiguration(after={RestClientAutoConfiguration.class, SpringAiRetryAutoConfiguration.class})
@ConditionalOnProperty(name={"spring.ai.model.audio.transcription"}, havingValue="dashscope", matchIfMissing=true)
@EnableConfigurationProperties(value={DashScopeConnectionProperties.class, DashScopeAudioTranscriptionProperties.class})
@ImportAutoConfiguration(classes={SpringAiRetryAutoConfiguration.class, RestClientAutoConfiguration.class})
public class DashScopeAudioTranscriptionAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public DashScopeAudioTranscriptionModel dashScopeAudioTranscriptionModel(DashScopeConnectionProperties commonProperties, DashScopeAudioTranscriptionProperties audioTranscriptionProperties, ObjectProvider<RestClient.Builder> restClientBuilderProvider, RetryTemplate retryTemplate, ResponseErrorHandler responseErrorHandle) {
        ResolvedConnectionProperties resolved = DashScopeConnectionUtils.resolveConnectionProperties(commonProperties, audioTranscriptionProperties, "audio.transcription");
        DashScopeAudioTranscriptionApi dashScopeAudioTranscriptionApi = DashScopeAudioTranscriptionApi.builder().baseUrl(resolved.baseUrl()).apiKey((ApiKey)new SimpleApiKey(resolved.apiKey())).model(audioTranscriptionProperties.getOptions().getModel()).workSpaceId(resolved.workspaceId()).restClientBuilder((RestClient.Builder)restClientBuilderProvider.getIfAvailable(RestClient::builder)).headers(resolved.headers()).responseErrorHandler(responseErrorHandle).build();
        return new DashScopeAudioTranscriptionModel(dashScopeAudioTranscriptionApi, audioTranscriptionProperties.getOptions(), retryTemplate);
    }
}

