/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.interceptor;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.ai.chat.messages.ToolResponseMessage;

public class ToolCallResponse {
    private final String result;
    private final String toolName;
    private final String toolCallId;
    private final String status;
    private final Map<String, Object> metadata;

    public ToolCallResponse(String result, String toolName, String toolCallId) {
        this(result, toolName, toolCallId, null, null);
    }

    public ToolCallResponse(String result, String toolName, String toolCallId, String status, Map<String, Object> metadata) {
        this.result = result;
        this.toolName = toolName;
        this.toolCallId = toolCallId;
        this.status = status;
        this.metadata = metadata != null ? new HashMap<String, Object>(metadata) : Collections.emptyMap();
    }

    public static ToolCallResponse of(String toolCallId, String toolName, String result) {
        return new ToolCallResponse(result, toolName, toolCallId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getResult() {
        return this.result;
    }

    public String getToolName() {
        return this.toolName;
    }

    public String getToolCallId() {
        return this.toolCallId;
    }

    public String getStatus() {
        return this.status;
    }

    public Map<String, Object> getMetadata() {
        return Collections.unmodifiableMap(this.metadata);
    }

    public ToolResponseMessage.ToolResponse toToolResponse() {
        return new ToolResponseMessage.ToolResponse(this.toolCallId, this.toolName, this.result);
    }

    public static class Builder {
        private String content;
        private String toolName;
        private String toolCallId;
        private String status;
        private Map<String, Object> metadata;

        public Builder content(String content) {
            this.content = content;
            return this;
        }

        public Builder toolName(String toolName) {
            this.toolName = toolName;
            return this;
        }

        public Builder toolCallId(String toolCallId) {
            this.toolCallId = toolCallId;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public Builder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public ToolCallResponse build() {
            return new ToolCallResponse(this.content, this.toolName, this.toolCallId, this.status, this.metadata);
        }
    }
}

