/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.interceptor;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.messages.SystemMessage;
import org.springframework.ai.chat.prompt.ChatOptions;

public class ModelRequest {
    private final SystemMessage systemMessage;
    private final Map<String, Object> context;
    private final List<Message> messages;
    private final ChatOptions options;
    private final List<String> tools;

    public ModelRequest(SystemMessage systemMessage, List<Message> messages, ChatOptions options, List<String> tools, Map<String, Object> context) {
        this.systemMessage = systemMessage;
        this.messages = messages;
        this.options = options;
        this.tools = tools;
        this.context = context;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ModelRequest request) {
        return new Builder().messages(request.messages).options(request.options).tools(request.tools).context(request.context);
    }

    public List<Message> getMessages() {
        return this.messages;
    }

    public SystemMessage getSystemMessage() {
        return this.systemMessage;
    }

    public ChatOptions getOptions() {
        return this.options;
    }

    public List<String> getTools() {
        return this.tools;
    }

    public Map<String, Object> getContext() {
        return this.context;
    }

    public static class Builder {
        private SystemMessage systemMessage;
        private List<Message> messages;
        private ChatOptions options;
        private List<String> tools;
        private Map<String, Object> context;

        public Builder systemMessage(SystemMessage systemMessage) {
            this.systemMessage = systemMessage;
            return this;
        }

        public Builder messages(List<Message> messages) {
            this.messages = messages;
            return this;
        }

        public Builder options(ChatOptions options) {
            this.options = options;
            return this;
        }

        public Builder tools(List<String> tools) {
            this.tools = tools;
            return this;
        }

        public Builder context(Map<String, Object> context) {
            this.context = new HashMap<String, Object>(context);
            return this;
        }

        public ModelRequest build() {
            return new ModelRequest(this.systemMessage, this.messages, this.options, this.tools, this.context);
        }
    }
}

