/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.hook.modelcalllimit;

public class ModelCallLimitExceededException
extends RuntimeException {
    private final int threadCount;
    private final int runCount;
    private final Integer threadLimit;
    private final Integer runLimit;

    public ModelCallLimitExceededException(int threadCount, int runCount, Integer threadLimit, Integer runLimit) {
        super(ModelCallLimitExceededException.buildMessage(threadCount, runCount, threadLimit, runLimit));
        this.threadCount = threadCount;
        this.runCount = runCount;
        this.threadLimit = threadLimit;
        this.runLimit = runLimit;
    }

    private static String buildMessage(int threadCount, int runCount, Integer threadLimit, Integer runLimit) {
        StringBuilder sb = new StringBuilder("Model call limits exceeded: ");
        if (threadLimit != null && threadCount >= threadLimit) {
            sb.append(String.format("thread limit (%d/%d)", threadCount, threadLimit));
        }
        if (runLimit != null && runCount >= runLimit) {
            if (threadLimit != null && threadCount >= threadLimit) {
                sb.append(", ");
            }
            sb.append(String.format("run limit (%d/%d)", runCount, runLimit));
        }
        return sb.toString();
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public int getRunCount() {
        return this.runCount;
    }

    public Integer getThreadLimit() {
        return this.threadLimit;
    }

    public Integer getRunLimit() {
        return this.runLimit;
    }
}

