/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.hook.messages;

import com.alibaba.cloud.ai.graph.OverAllState;
import com.alibaba.cloud.ai.graph.RunnableConfig;
import com.alibaba.cloud.ai.graph.action.AsyncNodeActionWithConfig;
import com.alibaba.cloud.ai.graph.agent.hook.Hook;
import com.alibaba.cloud.ai.graph.agent.hook.messages.AgentCommand;
import com.alibaba.cloud.ai.graph.agent.hook.messages.UpdatePolicy;
import com.alibaba.cloud.ai.graph.state.ReplaceAllWith;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.springframework.ai.chat.messages.Message;

public abstract class MessagesAgentHook
implements Hook {
    private String agentName;

    public AgentCommand beforeAgent(List<Message> previousMessages, RunnableConfig config) {
        return new AgentCommand(previousMessages);
    }

    public AgentCommand afterAgent(List<Message> previousMessages, RunnableConfig config) {
        return new AgentCommand(previousMessages);
    }

    @Override
    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    @Override
    public String getAgentName() {
        return this.agentName;
    }

    public static BeforeAgentAction beforeAgentAction(MessagesAgentHook hook) {
        return new BeforeAgentAction(hook);
    }

    public static AfterAgentAction afterAgentAction(MessagesAgentHook hook) {
        return new AfterAgentAction(hook);
    }

    public static class BeforeAgentAction
    implements AsyncNodeActionWithConfig {
        private final MessagesAgentHook messagesAgentHook;

        public BeforeAgentAction(MessagesAgentHook messagesAgentHook) {
            this.messagesAgentHook = messagesAgentHook;
        }

        public CompletableFuture<Map<String, Object>> apply(OverAllState state, RunnableConfig config) {
            List<Message> messages = state.value("messages").orElse(List.of());
            AgentCommand command = this.messagesAgentHook.beforeAgent(messages, config);
            HashMap<String, Object> result = new HashMap<String, Object>();
            if (command.getMessages() != null) {
                if (UpdatePolicy.REPLACE == command.getUpdatePolicy()) {
                    result.put("messages", ReplaceAllWith.of(command.getMessages()));
                } else {
                    result.put("messages", command.getMessages());
                }
            }
            if (command.getJumpTo() != null) {
                result.put("jump_to", command.getJumpTo().name());
            }
            return CompletableFuture.completedFuture(result);
        }
    }

    public static class AfterAgentAction
    implements AsyncNodeActionWithConfig {
        private final MessagesAgentHook messagesAgentHook;

        public AfterAgentAction(MessagesAgentHook messagesAgentHook) {
            this.messagesAgentHook = messagesAgentHook;
        }

        public CompletableFuture<Map<String, Object>> apply(OverAllState state, RunnableConfig config) {
            List<Message> messages = state.value("messages").orElse(List.of());
            AgentCommand command = this.messagesAgentHook.afterAgent(messages, config);
            HashMap<String, Object> result = new HashMap<String, Object>();
            if (command.getMessages() != null) {
                if (UpdatePolicy.REPLACE == command.getUpdatePolicy()) {
                    result.put("messages", ReplaceAllWith.of(command.getMessages()));
                } else {
                    result.put("messages", command.getMessages());
                }
            }
            if (command.getJumpTo() != null) {
                result.put("jump_to", command.getJumpTo().name());
            }
            return CompletableFuture.completedFuture(result);
        }
    }
}

