/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.flow.strategy;

import com.alibaba.cloud.ai.graph.StateGraph;
import com.alibaba.cloud.ai.graph.action.AsyncEdgeAction;
import com.alibaba.cloud.ai.graph.action.AsyncNodeAction;
import com.alibaba.cloud.ai.graph.action.NodeAction;
import com.alibaba.cloud.ai.graph.agent.Agent;
import com.alibaba.cloud.ai.graph.agent.flow.agent.FlowAgent;
import com.alibaba.cloud.ai.graph.agent.flow.builder.FlowGraphBuilder;
import com.alibaba.cloud.ai.graph.agent.flow.enums.FlowAgentEnum;
import com.alibaba.cloud.ai.graph.agent.flow.node.RoutingEdgeAction;
import com.alibaba.cloud.ai.graph.agent.flow.node.TransparentNode;
import com.alibaba.cloud.ai.graph.agent.flow.strategy.FlowGraphBuildingStrategy;
import com.alibaba.cloud.ai.graph.exception.GraphStateException;
import java.util.HashMap;

public class RoutingGraphBuildingStrategy
implements FlowGraphBuildingStrategy {
    @Override
    public StateGraph buildGraph(FlowGraphBuilder.FlowGraphConfig config) throws GraphStateException {
        this.validateConfig(config);
        this.validateRoutingConfig(config);
        StateGraph graph = config.getStateSerializer() != null ? new StateGraph(config.getName(), config.getKeyStrategyFactory(), config.getStateSerializer()) : new StateGraph(config.getName(), config.getKeyStrategyFactory());
        Agent rootAgent = config.getRootAgent();
        graph.addNode(rootAgent.name(), AsyncNodeAction.node_async((NodeAction)new TransparentNode()));
        graph.addEdge("__START__", rootAgent.name());
        HashMap<String, String> edgeRoutingMap = new HashMap<String, String>();
        for (Agent subAgent : config.getSubAgents()) {
            FlowGraphBuildingStrategy.addSubAgentNode(subAgent, graph);
            edgeRoutingMap.put(subAgent.name(), subAgent.name());
            graph.addEdge(subAgent.name(), "__END__");
        }
        graph.addConditionalEdges(rootAgent.name(), (AsyncEdgeAction)new RoutingEdgeAction(config.getChatModel(), rootAgent, config.getSubAgents()), edgeRoutingMap);
        return graph;
    }

    @Override
    public String getStrategyType() {
        return FlowAgentEnum.ROUTING.getType();
    }

    @Override
    public void validateConfig(FlowGraphBuilder.FlowGraphConfig config) {
        FlowGraphBuildingStrategy.super.validateConfig(config);
        this.validateRoutingConfig(config);
    }

    private void validateRoutingConfig(FlowGraphBuilder.FlowGraphConfig config) {
        if (config.getSubAgents() == null || config.getSubAgents().isEmpty()) {
            throw new IllegalArgumentException("Routing flow requires at least one sub-agent");
        }
        if (config.getChatModel() == null) {
            throw new IllegalArgumentException("Routing flow requires a ChatModel for decision making");
        }
        if (!(config.getRootAgent() instanceof FlowAgent)) {
            throw new IllegalArgumentException("Routing flow requires root agent to be a FlowAgent");
        }
    }
}

