/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.flow.strategy;

import com.alibaba.cloud.ai.graph.StateGraph;
import com.alibaba.cloud.ai.graph.action.AsyncNodeAction;
import com.alibaba.cloud.ai.graph.action.NodeAction;
import com.alibaba.cloud.ai.graph.agent.Agent;
import com.alibaba.cloud.ai.graph.agent.BaseAgent;
import com.alibaba.cloud.ai.graph.agent.flow.agent.FlowAgent;
import com.alibaba.cloud.ai.graph.agent.flow.agent.ParallelAgent;
import com.alibaba.cloud.ai.graph.agent.flow.builder.FlowGraphBuilder;
import com.alibaba.cloud.ai.graph.agent.flow.enums.FlowAgentEnum;
import com.alibaba.cloud.ai.graph.agent.flow.node.EnhancedParallelResultAggregator;
import com.alibaba.cloud.ai.graph.agent.flow.node.TransparentNode;
import com.alibaba.cloud.ai.graph.agent.flow.strategy.FlowGraphBuildingStrategy;
import com.alibaba.cloud.ai.graph.exception.GraphStateException;
import java.util.ArrayList;

public class ParallelGraphBuildingStrategy
implements FlowGraphBuildingStrategy {
    @Override
    public StateGraph buildGraph(FlowGraphBuilder.FlowGraphConfig config) throws GraphStateException {
        this.validateConfig(config);
        this.validateParallelConfig(config);
        StateGraph graph = config.getStateSerializer() != null ? new StateGraph(config.getName(), config.getKeyStrategyFactory(), config.getStateSerializer()) : new StateGraph(config.getName(), config.getKeyStrategyFactory());
        ParallelAgent rootAgent = (ParallelAgent)config.getRootAgent();
        graph.addNode(rootAgent.name(), AsyncNodeAction.node_async((NodeAction)new TransparentNode()));
        graph.addEdge("__START__", rootAgent.name());
        String aggregatorNodeName = rootAgent.name() + "_aggregator";
        Object mergeStrategy = config.getCustomProperty("mergeStrategy");
        Integer maxConcurrency = (Integer)config.getCustomProperty("maxConcurrency");
        ArrayList<BaseAgent> baseAgentList = new ArrayList<BaseAgent>(config.getSubAgents().size());
        for (Agent subAgent : config.getSubAgents()) {
            baseAgentList.add((BaseAgent)subAgent);
        }
        graph.addNode(aggregatorNodeName, AsyncNodeAction.node_async((NodeAction)new EnhancedParallelResultAggregator(rootAgent.mergeOutputKey(), baseAgentList, mergeStrategy, maxConcurrency)));
        for (Agent subAgent : config.getSubAgents()) {
            FlowGraphBuildingStrategy.addSubAgentNode(subAgent, graph);
            graph.addEdge(rootAgent.name(), subAgent.name());
            graph.addEdge(subAgent.name(), aggregatorNodeName);
        }
        graph.addEdge(aggregatorNodeName, "__END__");
        return graph;
    }

    @Override
    public String getStrategyType() {
        return FlowAgentEnum.PARALLEL.getType();
    }

    @Override
    public void validateConfig(FlowGraphBuilder.FlowGraphConfig config) {
        FlowGraphBuildingStrategy.super.validateConfig(config);
        this.validateParallelConfig(config);
    }

    private void validateParallelConfig(FlowGraphBuilder.FlowGraphConfig config) {
        if (config.getSubAgents() == null || config.getSubAgents().isEmpty()) {
            throw new IllegalArgumentException("Parallel flow requires at least one sub-agent");
        }
        if (config.getSubAgents().size() < 2) {
            throw new IllegalArgumentException("Parallel flow requires at least 2 sub-agents for meaningful parallel execution");
        }
        if (!(config.getRootAgent() instanceof FlowAgent)) {
            throw new IllegalArgumentException("Parallel flow requires root agent to be a FlowAgent");
        }
        Integer maxConcurrency = (Integer)config.getCustomProperty("maxConcurrency");
        if (maxConcurrency != null && maxConcurrency < 1) {
            throw new IllegalArgumentException("maxConcurrency must be at least 1, but got: " + maxConcurrency);
        }
    }
}

