/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.flow.strategy;

import com.alibaba.cloud.ai.graph.agent.flow.strategy.ConditionalGraphBuildingStrategy;
import com.alibaba.cloud.ai.graph.agent.flow.strategy.FlowGraphBuildingStrategy;
import com.alibaba.cloud.ai.graph.agent.flow.strategy.LoopGraphBuildingStrategy;
import com.alibaba.cloud.ai.graph.agent.flow.strategy.ParallelGraphBuildingStrategy;
import com.alibaba.cloud.ai.graph.agent.flow.strategy.RoutingGraphBuildingStrategy;
import com.alibaba.cloud.ai.graph.agent.flow.strategy.SequentialGraphBuildingStrategy;
import com.alibaba.cloud.ai.graph.agent.flow.strategy.SupervisorGraphBuildingStrategy;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class FlowGraphBuildingStrategyRegistry {
    private static final FlowGraphBuildingStrategyRegistry INSTANCE = new FlowGraphBuildingStrategyRegistry();
    private final Map<String, FlowGraphBuildingStrategy> strategies = new ConcurrentHashMap<String, FlowGraphBuildingStrategy>();

    private FlowGraphBuildingStrategyRegistry() {
        this.registerDefaultStrategies();
    }

    public static FlowGraphBuildingStrategyRegistry getInstance() {
        return INSTANCE;
    }

    public void registerStrategy(FlowGraphBuildingStrategy strategy) {
        if (strategy == null) {
            throw new IllegalArgumentException("Strategy cannot be null");
        }
        String type = strategy.getStrategyType();
        if (type == null || type.trim().isEmpty()) {
            throw new IllegalArgumentException("Strategy type cannot be null or empty");
        }
        if (this.strategies.containsKey(type)) {
            throw new IllegalArgumentException("Strategy type '" + type + "' is already registered");
        }
        this.strategies.put(type, strategy);
    }

    public FlowGraphBuildingStrategy getStrategy(String type) {
        if (type == null || type.trim().isEmpty()) {
            throw new IllegalArgumentException("Strategy type cannot be null or empty");
        }
        FlowGraphBuildingStrategy strategy = this.strategies.get(type);
        if (strategy == null) {
            throw new IllegalArgumentException("No strategy registered for type: " + type);
        }
        return strategy;
    }

    public boolean hasStrategy(String type) {
        return type != null && this.strategies.containsKey(type);
    }

    public Set<String> getRegisteredTypes() {
        return Set.copyOf(this.strategies.keySet());
    }

    public FlowGraphBuildingStrategy unregisterStrategy(String type) {
        return this.strategies.remove(type);
    }

    public void clear() {
        this.strategies.clear();
    }

    private void registerDefaultStrategies() {
        this.registerStrategy(new SequentialGraphBuildingStrategy());
        this.registerStrategy(new RoutingGraphBuildingStrategy());
        this.registerStrategy(new ParallelGraphBuildingStrategy());
        this.registerStrategy(new ConditionalGraphBuildingStrategy());
        this.registerStrategy(new LoopGraphBuildingStrategy());
        this.registerStrategy(new SupervisorGraphBuildingStrategy());
    }
}

